/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablehoppers.hikari.metrics;

import java.util.concurrent.atomic.AtomicLong;
import me.angeschossen.upgradeablehoppers.hikari.util.ClockSource;

public abstract class PoolStats {
    private final AtomicLong GAGFH;
    private final long Srqvu;
    protected volatile int totalConnections;
    protected volatile int idleConnections;
    protected volatile int activeConnections;
    protected volatile int pendingThreads;
    protected volatile int maxConnections;
    protected volatile int minConnections;

    public PoolStats(long l) {
        this.Srqvu = l;
        this.GAGFH = new AtomicLong();
    }

    public int getTotalConnections() {
        if (this.GAGFH()) {
            this.update();
        }
        return this.totalConnections;
    }

    public int getIdleConnections() {
        if (this.GAGFH()) {
            this.update();
        }
        return this.idleConnections;
    }

    public int getActiveConnections() {
        if (this.GAGFH()) {
            this.update();
        }
        return this.activeConnections;
    }

    public int getPendingThreads() {
        if (this.GAGFH()) {
            this.update();
        }
        return this.pendingThreads;
    }

    public int getMaxConnections() {
        if (this.GAGFH()) {
            this.update();
        }
        return this.maxConnections;
    }

    public int getMinConnections() {
        if (this.GAGFH()) {
            this.update();
        }
        return this.minConnections;
    }

    protected abstract void update();

    private boolean GAGFH() {
        long l;
        long l2;
        do {
            l = ClockSource.currentTime();
            l2 = this.GAGFH.get();
            if (l2 <= l) continue;
            return false;
        } while (!this.GAGFH.compareAndSet(l2, ClockSource.plusMillis(l, this.Srqvu)));
        return true;
    }
}

