/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablehoppers.hikari.metrics.micrometer;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import me.angeschossen.upgradeablehoppers.hikari.metrics.IMetricsTracker;
import me.angeschossen.upgradeablehoppers.hikari.metrics.PoolStats;

public class MicrometerMetricsTracker
implements IMetricsTracker {
    public static final String HIKARI_METRIC_NAME_PREFIX = "hikaricp";
    private static final String GAGFH = "pool";
    private static final String Srqvu = "hikaricp.connections.acquire";
    private static final String qGVpb = "hikaricp.connections.usage";
    private static final String Lqpzc = "hikaricp.connections.creation";
    private static final String lwJV = "hikaricp.connections.timeout";
    private static final String EMqEv = "hikaricp.connections";
    private static final String mToYg = "hikaricp.connections.idle";
    private static final String aazaq = "hikaricp.connections.active";
    private static final String gXWTv = "hikaricp.connections.pending";
    private static final String nzWuu = "hikaricp.connections.max";
    private static final String TqFJL = "hikaricp.connections.min";
    private final Timer WAGHG;
    private final Counter UyMP;
    private final Timer yfrbP;
    private final Timer VyMXK;
    private final Gauge hPPy;
    private final Gauge UQQfL;
    private final Gauge antrD;
    private final Gauge NIzf;
    private final Gauge XiKV;
    private final Gauge knAZu;
    private final MeterRegistry Yhbnj;
    private final PoolStats fDxZ;

    MicrometerMetricsTracker(String string, PoolStats poolStats, MeterRegistry meterRegistry) {
        this.fDxZ = poolStats;
        this.Yhbnj = meterRegistry;
        this.WAGHG = Timer.builder((String)Srqvu).description("Connection acquire time").tags(new String[]{GAGFH, string}).register(meterRegistry);
        this.VyMXK = Timer.builder((String)Lqpzc).description("Connection creation time").tags(new String[]{GAGFH, string}).register(meterRegistry);
        this.yfrbP = Timer.builder((String)qGVpb).description("Connection usage time").tags(new String[]{GAGFH, string}).register(meterRegistry);
        this.UyMP = Counter.builder((String)lwJV).description("Connection timeout total count").tags(new String[]{GAGFH, string}).register(meterRegistry);
        this.hPPy = Gauge.builder((String)EMqEv, (Object)poolStats, PoolStats::getTotalConnections).description("Total connections").tags(new String[]{GAGFH, string}).register(meterRegistry);
        this.UQQfL = Gauge.builder((String)mToYg, (Object)poolStats, PoolStats::getIdleConnections).description("Idle connections").tags(new String[]{GAGFH, string}).register(meterRegistry);
        this.antrD = Gauge.builder((String)aazaq, (Object)poolStats, PoolStats::getActiveConnections).description("Active connections").tags(new String[]{GAGFH, string}).register(meterRegistry);
        this.NIzf = Gauge.builder((String)gXWTv, (Object)poolStats, PoolStats::getPendingThreads).description("Pending threads").tags(new String[]{GAGFH, string}).register(meterRegistry);
        this.XiKV = Gauge.builder((String)nzWuu, (Object)poolStats, PoolStats::getMaxConnections).description("Max connections").tags(new String[]{GAGFH, string}).register(meterRegistry);
        this.knAZu = Gauge.builder((String)TqFJL, (Object)poolStats, PoolStats::getMinConnections).description("Min connections").tags(new String[]{GAGFH, string}).register(meterRegistry);
    }

    @Override
    public void recordConnectionAcquiredNanos(long l) {
        this.WAGHG.record(l, TimeUnit.NANOSECONDS);
    }

    @Override
    public void recordConnectionUsageMillis(long l) {
        this.yfrbP.record(l, TimeUnit.MILLISECONDS);
    }

    @Override
    public void recordConnectionTimeout() {
        this.UyMP.increment();
    }

    @Override
    public void recordConnectionCreatedMillis(long l) {
        this.VyMXK.record(l, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        this.Yhbnj.remove((Meter)this.WAGHG);
        this.Yhbnj.remove((Meter)this.UyMP);
        this.Yhbnj.remove((Meter)this.yfrbP);
        this.Yhbnj.remove((Meter)this.VyMXK);
        this.Yhbnj.remove((Meter)this.hPPy);
        this.Yhbnj.remove((Meter)this.UQQfL);
        this.Yhbnj.remove((Meter)this.antrD);
        this.Yhbnj.remove((Meter)this.NIzf);
        this.Yhbnj.remove((Meter)this.XiKV);
        this.Yhbnj.remove((Meter)this.knAZu);
    }
}

