/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablehoppers.slf4j;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import me.angeschossen.upgradeablehoppers.slf4j.ILoggerFactory;
import me.angeschossen.upgradeablehoppers.slf4j.Logger;
import me.angeschossen.upgradeablehoppers.slf4j.event.SubstituteLoggingEvent;
import me.angeschossen.upgradeablehoppers.slf4j.helpers.NOPLoggerFactory;
import me.angeschossen.upgradeablehoppers.slf4j.helpers.SubstituteLogger;
import me.angeschossen.upgradeablehoppers.slf4j.helpers.SubstituteLoggerFactory;
import me.angeschossen.upgradeablehoppers.slf4j.helpers.Util;
import me.angeschossen.upgradeablehoppers.slf4j.impl.StaticLoggerBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoggerFactory {
    static final String GAGFH = "http://www.slf4j.org/codes.html";
    static final String Srqvu = "http://www.slf4j.org/codes.html#StaticLoggerBinder";
    static final String qGVpb = "http://www.slf4j.org/codes.html#multiple_bindings";
    static final String Lqpzc = "http://www.slf4j.org/codes.html#null_LF";
    static final String lwJV = "http://www.slf4j.org/codes.html#version_mismatch";
    static final String EMqEv = "http://www.slf4j.org/codes.html#substituteLogger";
    static final String mToYg = "http://www.slf4j.org/codes.html#loggerNameMismatch";
    static final String aazaq = "http://www.slf4j.org/codes.html#replay";
    static final String gXWTv = "http://www.slf4j.org/codes.html#unsuccessfulInit";
    static final String nzWuu = "org.slf4j.LoggerFactory in failed state. Original exception was thrown EARLIER. See also http://www.slf4j.org/codes.html#unsuccessfulInit";
    static final int TqFJL = 0;
    static final int WAGHG = 1;
    static final int UyMP = 2;
    static final int yfrbP = 3;
    static final int VyMXK = 4;
    static volatile int hPPy = 0;
    static final SubstituteLoggerFactory UQQfL = new SubstituteLoggerFactory();
    static final NOPLoggerFactory antrD = new NOPLoggerFactory();
    static final String NIzf = "slf4j.detectLoggerNameMismatch";
    static final String XiKV = "java.vendor.url";
    static boolean knAZu = Util.safeGetBooleanSystemProperty("slf4j.detectLoggerNameMismatch");
    private static final String[] Yhbnj = new String[]{"1.6", "1.7"};
    private static String fDxZ = "me/angeschossen/upgradeablehoppers/slf4j/impl/StaticLoggerBinder.class";

    private LoggerFactory() {
    }

    static void GAGFH() {
        hPPy = 0;
    }

    private static final void qGVpb() {
        LoggerFactory.Lqpzc();
        if (hPPy == 3) {
            LoggerFactory.gXWTv();
        }
    }

    private static boolean GAGFH(String string) {
        if (string == null) {
            return false;
        }
        if (string.contains("me/angeschossen/upgradeablehoppers/slf4j/impl/StaticLoggerBinder")) {
            return true;
        }
        return string.contains("me.angeschossen.upgradeablehoppers.slf4j.impl.StaticLoggerBinder");
    }

    private static final void Lqpzc() {
        block11: {
            try {
                Set<URL> set = null;
                if (!LoggerFactory.nzWuu()) {
                    set = LoggerFactory.Srqvu();
                    LoggerFactory.Srqvu(set);
                }
                StaticLoggerBinder.getSingleton();
                hPPy = 3;
                LoggerFactory.qGVpb(set);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                String string = noClassDefFoundError.getMessage();
                if (LoggerFactory.GAGFH(string)) {
                    hPPy = 4;
                    Util.report("Failed to load class \"org.slf4j.impl.StaticLoggerBinder\".");
                    Util.report("Defaulting to no-operation (NOP) logger implementation");
                    Util.report("See http://www.slf4j.org/codes.html#StaticLoggerBinder for further details.");
                    break block11;
                }
                LoggerFactory.GAGFH(noClassDefFoundError);
                throw noClassDefFoundError;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                String string = noSuchMethodError.getMessage();
                if (string != null && string.contains("me.angeschossen.upgradeablehoppers.slf4j.impl.StaticLoggerBinder.getSingleton()")) {
                    hPPy = 2;
                    Util.report("slf4j-api 1.6.x (or later) is incompatible with this binding.");
                    Util.report("Your binding is version 1.5.5 or earlier.");
                    Util.report("Upgrade your binding to version 1.6.x.");
                }
                throw noSuchMethodError;
            }
            catch (Exception exception) {
                LoggerFactory.GAGFH(exception);
                throw new IllegalStateException("Unexpected initialization failure", exception);
            }
            finally {
                LoggerFactory.lwJV();
            }
        }
    }

    private static void lwJV() {
        LoggerFactory.EMqEv();
        LoggerFactory.mToYg();
        UQQfL.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void EMqEv() {
        SubstituteLoggerFactory substituteLoggerFactory = UQQfL;
        synchronized (substituteLoggerFactory) {
            UQQfL.postInitialization();
            for (SubstituteLogger substituteLogger : UQQfL.getLoggers()) {
                Logger logger = LoggerFactory.getLogger(substituteLogger.getName());
                substituteLogger.setDelegate(logger);
            }
        }
    }

    static void GAGFH(Throwable throwable) {
        hPPy = 2;
        Util.report("Failed to instantiate SLF4J LoggerFactory", throwable);
    }

    private static void mToYg() {
        int n;
        LinkedBlockingQueue<SubstituteLoggingEvent> linkedBlockingQueue = UQQfL.getEventQueue();
        int n2 = linkedBlockingQueue.size();
        int n3 = 0;
        int n4 = 128;
        ArrayList arrayList = new ArrayList(128);
        while ((n = linkedBlockingQueue.drainTo(arrayList, 128)) != 0) {
            for (SubstituteLoggingEvent substituteLoggingEvent : arrayList) {
                LoggerFactory.GAGFH(substituteLoggingEvent);
                if (n3++ != 0) continue;
                LoggerFactory.GAGFH(substituteLoggingEvent, n2);
            }
            arrayList.clear();
        }
    }

    private static void GAGFH(SubstituteLoggingEvent substituteLoggingEvent, int n) {
        if (substituteLoggingEvent.getLogger().isDelegateEventAware()) {
            LoggerFactory.GAGFH(n);
        } else if (!substituteLoggingEvent.getLogger().isDelegateNOP()) {
            LoggerFactory.aazaq();
        }
    }

    private static void GAGFH(SubstituteLoggingEvent substituteLoggingEvent) {
        if (substituteLoggingEvent == null) {
            return;
        }
        SubstituteLogger substituteLogger = substituteLoggingEvent.getLogger();
        String string = substituteLogger.getName();
        if (substituteLogger.isDelegateNull()) {
            throw new IllegalStateException("Delegate logger cannot be null at this state.");
        }
        if (!substituteLogger.isDelegateNOP()) {
            if (substituteLogger.isDelegateEventAware()) {
                substituteLogger.log(substituteLoggingEvent);
            } else {
                Util.report(string);
            }
        }
    }

    private static void aazaq() {
        Util.report("The following set of substitute loggers may have been accessed");
        Util.report("during the initialization phase. Logging calls during this");
        Util.report("phase were not honored. However, subsequent logging calls to these");
        Util.report("loggers will work as normally expected.");
        Util.report("See also http://www.slf4j.org/codes.html#substituteLogger");
    }

    private static void GAGFH(int n) {
        Util.report("A number (" + n + ") of logging calls during the initialization phase have been intercepted and are");
        Util.report("now being replayed. These are subject to the filtering rules of the underlying logging system.");
        Util.report("See also http://www.slf4j.org/codes.html#replay");
    }

    private static final void gXWTv() {
        try {
            String string = StaticLoggerBinder.REQUESTED_API_VERSION;
            boolean bl = false;
            for (String string2 : Yhbnj) {
                if (!string.startsWith(string2)) continue;
                bl = true;
            }
            if (!bl) {
                Util.report("The requested version " + string + " by your slf4j binding is not compatible with " + Arrays.asList(Yhbnj).toString());
                Util.report("See http://www.slf4j.org/codes.html#version_mismatch for further details.");
            }
        }
        catch (NoSuchFieldError noSuchFieldError) {
        }
        catch (Throwable throwable) {
            Util.report("Unexpected problem occured during version sanity check", throwable);
        }
    }

    static Set<URL> Srqvu() {
        LinkedHashSet<URL> linkedHashSet = new LinkedHashSet<URL>();
        try {
            ClassLoader classLoader = LoggerFactory.class.getClassLoader();
            Enumeration<URL> enumeration = classLoader == null ? ClassLoader.getSystemResources(fDxZ) : classLoader.getResources(fDxZ);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                linkedHashSet.add(uRL);
            }
        }
        catch (IOException iOException) {
            Util.report("Error getting resources from path", iOException);
        }
        return linkedHashSet;
    }

    private static boolean GAGFH(Set<URL> set) {
        return set.size() > 1;
    }

    private static void Srqvu(Set<URL> set) {
        if (LoggerFactory.GAGFH(set)) {
            Util.report("Class path contains multiple SLF4J bindings.");
            for (URL uRL : set) {
                Util.report("Found binding in [" + uRL + "]");
            }
            Util.report("See http://www.slf4j.org/codes.html#multiple_bindings for an explanation.");
        }
    }

    private static boolean nzWuu() {
        String string = Util.safeGetSystemProperty(XiKV);
        if (string == null) {
            return false;
        }
        return string.toLowerCase().contains("android");
    }

    private static void qGVpb(Set<URL> set) {
        if (set != null && LoggerFactory.GAGFH(set)) {
            Util.report("Actual binding is of type [" + StaticLoggerBinder.getSingleton().getLoggerFactoryClassStr() + "]");
        }
    }

    public static Logger getLogger(String string) {
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        return iLoggerFactory.getLogger(string);
    }

    public static Logger getLogger(Class<?> clazz) {
        Class<?> clazz2;
        Logger logger = LoggerFactory.getLogger(clazz.getName());
        if (knAZu && (clazz2 = Util.getCallingClass()) != null && LoggerFactory.GAGFH(clazz, clazz2)) {
            Util.report(String.format("Detected logger name mismatch. Given name: \"%s\"; computed name: \"%s\".", logger.getName(), clazz2.getName()));
            Util.report("See http://www.slf4j.org/codes.html#loggerNameMismatch for an explanation");
        }
        return logger;
    }

    private static boolean GAGFH(Class<?> clazz, Class<?> clazz2) {
        return !clazz2.isAssignableFrom(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static ILoggerFactory getILoggerFactory() {
        if (hPPy == 0) {
            Class<LoggerFactory> clazz = LoggerFactory.class;
            // MONITORENTER : me.angeschossen.upgradeablehoppers.slf4j.LoggerFactory.class
            if (hPPy == 0) {
                hPPy = 1;
                LoggerFactory.qGVpb();
            }
            // MONITOREXIT : clazz
        }
        switch (hPPy) {
            case 3: {
                return StaticLoggerBinder.getSingleton().getLoggerFactory();
            }
            case 4: {
                return antrD;
            }
            case 2: {
                throw new IllegalStateException(nzWuu);
            }
            case 1: {
                return UQQfL;
            }
        }
        throw new IllegalStateException("Unreachable code");
    }
}

