/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.upgradeablehoppers.slf4j;

import java.io.Closeable;
import java.util.Map;
import me.angeschossen.upgradeablehoppers.slf4j.helpers.NOPMDCAdapter;
import me.angeschossen.upgradeablehoppers.slf4j.helpers.Util;
import me.angeschossen.upgradeablehoppers.slf4j.impl.StaticMDCBinder;
import me.angeschossen.upgradeablehoppers.slf4j.spi.MDCAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDC {
    static final String GAGFH = "http://www.slf4j.org/codes.html#null_MDCA";
    static final String Srqvu = "http://www.slf4j.org/codes.html#no_static_mdc_binder";
    static MDCAdapter qGVpb;

    private MDC() {
    }

    private static MDCAdapter GAGFH() {
        try {
            return StaticMDCBinder.getSingleton().getMDCA();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return StaticMDCBinder.SINGLETON.getMDCA();
        }
    }

    public static void put(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("key parameter cannot be null");
        }
        if (qGVpb == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        qGVpb.put(string, string2);
    }

    public static MDCCloseable putCloseable(String string, String string2) {
        MDC.put(string, string2);
        return new MDCCloseable(string);
    }

    public static String get(String string) {
        if (string == null) {
            throw new IllegalArgumentException("key parameter cannot be null");
        }
        if (qGVpb == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        return qGVpb.get(string);
    }

    public static void remove(String string) {
        if (string == null) {
            throw new IllegalArgumentException("key parameter cannot be null");
        }
        if (qGVpb == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        qGVpb.remove(string);
    }

    public static void clear() {
        if (qGVpb == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        qGVpb.clear();
    }

    public static Map<String, String> getCopyOfContextMap() {
        if (qGVpb == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        return qGVpb.getCopyOfContextMap();
    }

    public static void setContextMap(Map<String, String> map) {
        if (qGVpb == null) {
            throw new IllegalStateException("MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA");
        }
        qGVpb.setContextMap(map);
    }

    public static MDCAdapter getMDCAdapter() {
        return qGVpb;
    }

    static {
        try {
            qGVpb = MDC.GAGFH();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            qGVpb = new NOPMDCAdapter();
            String string = noClassDefFoundError.getMessage();
            if (string != null && string.contains("StaticMDCBinder")) {
                Util.report("Failed to load class \"org.slf4j.impl.StaticMDCBinder\".");
                Util.report("Defaulting to no-operation MDCAdapter implementation.");
                Util.report("See http://www.slf4j.org/codes.html#no_static_mdc_binder for further details.");
            }
            throw noClassDefFoundError;
        }
        catch (Exception exception) {
            Util.report("MDC binding unsuccessful.", exception);
        }
    }

    public static class MDCCloseable
    implements Closeable {
        private final String GAGFH;

        private MDCCloseable(String string) {
            this.GAGFH = string;
        }

        public void close() {
            MDC.remove(this.GAGFH);
        }
    }
}

