/*
 * Decompiled with CFR 0.152.
 */
package dev.lone.itemsadder.Core.OtherPlugins.Citizens;

import dev.lone.itemsadder.Core.OtherPlugins.Citizens.CustomEntityTrait;
import ia.m.X;
import ia.m.km;
import ia.m.ks;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitInfo;
import org.apache.commons.lang.reflect.MethodUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class CitizensHook {
    private static TraitInfo trait;

    public static boolean isRegistered() {
        return trait != null;
    }

    public static void register() {
        trait = TraitInfo.create(CustomEntityTrait.class).withName("customentity");
        CitizensAPI.getTraitFactory().registerTrait(trait);
        km.S("Registered Citizens NPC Trait: " + trait.getTraitName());
    }

    public static void unregister() {
        if (trait != null) {
            CitizensAPI.getTraitFactory().deregisterTrait(trait);
            trait = null;
        }
    }

    public static void reload() {
        try {
            km.S("Reloading ItemsAdder Custom Entities Citizens NPCs");
            try {
                ((Citizens)CitizensAPI.getPlugin()).storeNPCs(false);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                Method method = MethodUtils.getAccessibleMethod(Citizens.class, (String)"storeNPCs", Boolean.TYPE);
                method.invoke((Object)CitizensAPI.getPlugin(), false);
            }
            CitizensHook.forceRespawnAllCustomEntitiesNPCs();
        }
        catch (Throwable throwable) {
            km.T("Failed to reload Citizens. Try to update to the latest version.");
            throwable.printStackTrace();
        }
    }

    public static void saveAllDelayed() {
        ks.b(CitizensHook::saveAllDelayed, 80L);
    }

    public static void saveAll() {
        try {
            km.S("Saving Citizens NPCs");
            try {
                ((Citizens)CitizensAPI.getPlugin()).storeNPCs(false);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                Method method = MethodUtils.getAccessibleMethod(Citizens.class, (String)"storeNPCs", Boolean.TYPE);
                method.invoke((Object)CitizensAPI.getPlugin(), false);
            }
        }
        catch (Throwable throwable) {
            km.T("Failed to save Citizens NPCs. Try to update to the latest version.");
            throwable.printStackTrace();
        }
    }

    public static void despawnAllCustomEntitiesNPCs() {
        block0: for (NPC nPC : CitizensAPI.getNPCRegistry()) {
            for (Trait trait : nPC.getTraits()) {
                if (!trait.getName().equals("customentity")) continue;
                if (!nPC.isSpawned()) continue block0;
                nPC.despawn();
                km.S("Despawned NPC " + nPC.getId() + " before loading.");
                continue block0;
            }
        }
    }

    public static void forceRespawnAllCustomEntitiesNPCs() {
        try {
            ((Citizens)CitizensAPI.getPlugin()).reload();
        }
        catch (Throwable throwable) {
            km.T("Failed to reload Citizens NPCs. Error:");
            throwable.printStackTrace();
        }
    }

    public static void forceSpawnAllCustomEntitiesNPCs() {
        block0: for (NPC nPC : CitizensAPI.getNPCRegistry()) {
            for (Trait trait : nPC.getTraits()) {
                if (!trait.getName().equals("customentity")) continue;
                if (nPC.isSpawned()) continue block0;
                nPC.spawn(nPC.getStoredLocation());
                km.S("Spawned NPC " + nPC.getId() + " after loading.");
                continue block0;
            }
        }
    }

    public static boolean isNPC(LivingEntity livingEntity) {
        if (livingEntity == null) {
            return false;
        }
        return CitizensAPI.getNPCRegistry().isNPC((Entity)livingEntity);
    }

    public static void despawn(NPC nPC) {
        if (nPC.isSpawned()) {
            nPC.despawn();
        }
    }

    public static void spawn(NPC nPC) {
        if (!nPC.isSpawned()) {
            nPC.spawn(nPC.getStoredLocation());
        }
    }

    public static void respawn(NPC nPC) {
        if (nPC.isSpawned()) {
            nPC.despawn();
            nPC.spawn(nPC.getStoredLocation());
        }
    }

    public static boolean isNameplateVisible(NPC nPC) {
        return (Boolean)nPC.data().get(NPC.Metadata.NAMEPLATE_VISIBLE, (Object)true);
    }

    public static NPC getSelected(CommandSender commandSender) {
        return CitizensAPI.getDefaultNPCSelector().getSelected(commandSender);
    }

    public static X getSelectedNpcEntityRenderer(CommandSender commandSender) {
        NPC nPC = CitizensAPI.getDefaultNPCSelector().getSelected(commandSender);
        if (nPC == null) {
            return null;
        }
        CustomEntityTrait customEntityTrait = (CustomEntityTrait)nPC.getTraitNullable(CustomEntityTrait.class);
        if (customEntityTrait == null) {
            return null;
        }
        return customEntityTrait.getRenderer();
    }

    public static List getNpcsIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (NPC nPC : CitizensAPI.getNPCRegistry()) {
            arrayList.add(Integer.toString(nPC.getId()));
        }
        return arrayList;
    }
}

