/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.internal;

import ia.sh.com.jayway.jsonpath.InvalidPathException;

public class CharacterIndex {
    private static final char OPEN_PARENTHESIS = '(';
    private static final char CLOSE_PARENTHESIS = ')';
    private static final char CLOSE_SQUARE_BRACKET = ']';
    private static final char SPACE = ' ';
    private static final char ESCAPE = '\\';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char MINUS = '-';
    private static final char PERIOD = '.';
    private static final char REGEX = '/';
    private static final char SCI_E = 'E';
    private static final char SCI_e = 'e';
    private final CharSequence charSequence;
    private int position;
    private int endPosition;

    public CharacterIndex(CharSequence charSequence) {
        this.charSequence = charSequence;
        this.position = 0;
        this.endPosition = charSequence.length() - 1;
    }

    public int length() {
        return this.endPosition + 1;
    }

    public char charAt(int n2) {
        return this.charSequence.charAt(n2);
    }

    public char currentChar() {
        return this.charSequence.charAt(this.position);
    }

    public boolean currentCharIs(char c2) {
        return this.charSequence.charAt(this.position) == c2;
    }

    public boolean lastCharIs(char c2) {
        return this.charSequence.charAt(this.endPosition) == c2;
    }

    public boolean nextCharIs(char c2) {
        return this.inBounds(this.position + 1) && this.charSequence.charAt(this.position + 1) == c2;
    }

    public int incrementPosition(int n2) {
        return this.setPosition(this.position + n2);
    }

    public int decrementEndPosition(int n2) {
        return this.setEndPosition(this.endPosition - n2);
    }

    public int setPosition(int n2) {
        this.position = n2;
        return this.position;
    }

    private int setEndPosition(int n2) {
        this.endPosition = n2;
        return this.endPosition;
    }

    public int position() {
        return this.position;
    }

    public int indexOfClosingSquareBracket(int n2) {
        int n3 = n2;
        while (this.inBounds(n3)) {
            if (this.charAt(n3) == ']') {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public int indexOfMatchingCloseChar(int n2, char c2, char c3, boolean bl2, boolean bl3) {
        if (this.charAt(n2) != c2) {
            throw new InvalidPathException("Expected " + c2 + " but found " + this.charAt(n2));
        }
        int n3 = 1;
        int n4 = n2 + 1;
        while (this.inBounds(n4)) {
            char c4;
            if (bl2 && ((c4 = this.charAt(n4)) == '\'' || c4 == '\"')) {
                if ((n4 = this.nextIndexOfUnescaped(n4, c4)) == -1) {
                    throw new InvalidPathException("Could not find matching close quote for " + c4 + " when parsing : " + this.charSequence);
                }
                ++n4;
            }
            if (bl3 && this.charAt(n4) == '/') {
                if ((n4 = this.nextIndexOfUnescaped(n4, '/')) == -1) {
                    throw new InvalidPathException("Could not find matching close for / when parsing regex in : " + this.charSequence);
                }
                ++n4;
            }
            if (this.charAt(n4) == c2) {
                ++n3;
            }
            if (this.charAt(n4) == c3 && --n3 == 0) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    public int indexOfClosingBracket(int n2, boolean bl2, boolean bl3) {
        return this.indexOfMatchingCloseChar(n2, '(', ')', bl2, bl3);
    }

    public int indexOfNextSignificantChar(char c2) {
        return this.indexOfNextSignificantChar(this.position, c2);
    }

    public int indexOfNextSignificantChar(int n2, char c2) {
        int n3 = n2 + 1;
        while (!this.isOutOfBounds(n3) && this.charAt(n3) == ' ') {
            ++n3;
        }
        if (this.charAt(n3) == c2) {
            return n3;
        }
        return -1;
    }

    public int nextIndexOf(char c2) {
        return this.nextIndexOf(this.position + 1, c2);
    }

    public int nextIndexOf(int n2, char c2) {
        int n3 = n2;
        while (!this.isOutOfBounds(n3)) {
            if (this.charAt(n3) == c2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public int nextIndexOfUnescaped(char c2) {
        return this.nextIndexOfUnescaped(this.position, c2);
    }

    public int nextIndexOfUnescaped(int n2, char c2) {
        int n3 = n2 + 1;
        boolean bl2 = false;
        while (!this.isOutOfBounds(n3)) {
            if (bl2) {
                bl2 = false;
            } else if ('\\' == this.charAt(n3)) {
                bl2 = true;
            } else if (c2 == this.charAt(n3)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public char charAtOr(int n2, char c2) {
        if (!this.inBounds(n2)) {
            return c2;
        }
        return this.charAt(n2);
    }

    public boolean nextSignificantCharIs(int n2, char c2) {
        int n3 = n2 + 1;
        while (!this.isOutOfBounds(n3) && this.charAt(n3) == ' ') {
            ++n3;
        }
        return !this.isOutOfBounds(n3) && this.charAt(n3) == c2;
    }

    public boolean nextSignificantCharIs(char c2) {
        return this.nextSignificantCharIs(this.position, c2);
    }

    public char nextSignificantChar() {
        return this.nextSignificantChar(this.position);
    }

    public char nextSignificantChar(int n2) {
        int n3 = n2 + 1;
        while (!this.isOutOfBounds(n3) && this.charAt(n3) == ' ') {
            ++n3;
        }
        if (!this.isOutOfBounds(n3)) {
            return this.charAt(n3);
        }
        return ' ';
    }

    public void readSignificantChar(char c2) {
        if (this.skipBlanks().currentChar() != c2) {
            throw new InvalidPathException(String.format("Expected character: %c", Character.valueOf(c2)));
        }
        this.incrementPosition(1);
    }

    public boolean hasSignificantSubSequence(CharSequence charSequence) {
        this.skipBlanks();
        if (!this.inBounds(this.position + charSequence.length() - 1)) {
            return false;
        }
        if (!this.subSequence(this.position, this.position + charSequence.length()).equals(charSequence)) {
            return false;
        }
        this.incrementPosition(charSequence.length());
        return true;
    }

    public int indexOfPreviousSignificantChar(int n2) {
        int n3 = n2 - 1;
        while (!this.isOutOfBounds(n3) && this.charAt(n3) == ' ') {
            --n3;
        }
        if (!this.isOutOfBounds(n3)) {
            return n3;
        }
        return -1;
    }

    public int indexOfPreviousSignificantChar() {
        return this.indexOfPreviousSignificantChar(this.position);
    }

    public char previousSignificantChar(int n2) {
        int n3 = this.indexOfPreviousSignificantChar(n2);
        if (n3 == -1) {
            return ' ';
        }
        return this.charAt(n3);
    }

    public char previousSignificantChar() {
        return this.previousSignificantChar(this.position);
    }

    public boolean currentIsTail() {
        return this.position >= this.endPosition;
    }

    public boolean hasMoreCharacters() {
        return this.inBounds(this.position + 1);
    }

    public boolean inBounds(int n2) {
        return n2 >= 0 && n2 <= this.endPosition;
    }

    public boolean inBounds() {
        return this.inBounds(this.position);
    }

    public boolean isOutOfBounds(int n2) {
        return !this.inBounds(n2);
    }

    public CharSequence subSequence(int n2, int n3) {
        return this.charSequence.subSequence(n2, n3);
    }

    public CharSequence charSequence() {
        return this.charSequence;
    }

    public String toString() {
        return this.charSequence.toString();
    }

    public boolean isNumberCharacter(int n2) {
        char c2 = this.charAt(n2);
        return Character.isDigit(c2) || c2 == '-' || c2 == '.' || c2 == 'E' || c2 == 'e';
    }

    public CharacterIndex skipBlanks() {
        while (this.inBounds() && this.position < this.endPosition && this.currentChar() == ' ') {
            this.incrementPosition(1);
        }
        return this;
    }

    private CharacterIndex skipBlanksAtEnd() {
        while (this.inBounds() && this.position < this.endPosition && this.lastCharIs(' ')) {
            this.decrementEndPosition(1);
        }
        return this;
    }

    public CharacterIndex trim() {
        this.skipBlanks();
        this.skipBlanksAtEnd();
        return this;
    }
}

