/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.internal.filter;

import ia.sh.com.jayway.jsonpath.InvalidPathException;
import ia.sh.com.jayway.jsonpath.JsonPathException;
import ia.sh.com.jayway.jsonpath.Predicate;
import ia.sh.com.jayway.jsonpath.Predicate$PredicateContext;
import ia.sh.com.jayway.jsonpath.internal.Path;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNodes;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNodes$BooleanNode;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNodes$ClassNode;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNodes$JsonNode;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNodes$NullNode;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNodes$NumberNode;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNodes$OffsetDateTimeNode;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNodes$PathNode;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNodes$PatternNode;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNodes$PredicateNode;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNodes$StringNode;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNodes$UndefinedNode;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNodes$ValueListNode;
import ia.sh.com.jayway.jsonpath.internal.path.PathCompiler;
import ia.sh.net.minidev.json.parser.JSONParser;
import java.time.OffsetDateTime;
import java.util.regex.Pattern;

public abstract class ValueNode {
    public abstract Class type(Predicate$PredicateContext var1);

    public boolean isPatternNode() {
        return false;
    }

    public ValueNodes$PatternNode asPatternNode() {
        throw new InvalidPathException("Expected regexp node");
    }

    public boolean isPathNode() {
        return false;
    }

    public ValueNodes$PathNode asPathNode() {
        throw new InvalidPathException("Expected path node");
    }

    public boolean isNumberNode() {
        return false;
    }

    public ValueNodes$NumberNode asNumberNode() {
        throw new InvalidPathException("Expected number node");
    }

    public boolean isStringNode() {
        return false;
    }

    public ValueNodes$StringNode asStringNode() {
        throw new InvalidPathException("Expected string node");
    }

    public boolean isBooleanNode() {
        return false;
    }

    public ValueNodes$BooleanNode asBooleanNode() {
        throw new InvalidPathException("Expected boolean node");
    }

    public boolean isJsonNode() {
        return false;
    }

    public ValueNodes$JsonNode asJsonNode() {
        throw new InvalidPathException("Expected json node");
    }

    public boolean isPredicateNode() {
        return false;
    }

    public ValueNodes$PredicateNode asPredicateNode() {
        throw new InvalidPathException("Expected predicate node");
    }

    public boolean isValueListNode() {
        return false;
    }

    public ValueNodes$ValueListNode asValueListNode() {
        throw new InvalidPathException("Expected value list node");
    }

    public boolean isNullNode() {
        return false;
    }

    public ValueNodes$NullNode asNullNode() {
        throw new InvalidPathException("Expected null node");
    }

    public ValueNodes$UndefinedNode asUndefinedNode() {
        throw new InvalidPathException("Expected undefined node");
    }

    public boolean isUndefinedNode() {
        return false;
    }

    public boolean isClassNode() {
        return false;
    }

    public ValueNodes$ClassNode asClassNode() {
        throw new InvalidPathException("Expected class node");
    }

    public boolean isOffsetDateTimeNode() {
        return false;
    }

    public ValueNodes$OffsetDateTimeNode asOffsetDateTimeNode() {
        throw new InvalidPathException("Expected offsetDateTime node");
    }

    private static boolean isPath(Object object) {
        if (object == null || !(object instanceof String)) {
            return false;
        }
        String string = object.toString().trim();
        if (string.length() <= 0) {
            return false;
        }
        char c2 = string.charAt(0);
        if (c2 == '@' || c2 == '$') {
            try {
                PathCompiler.compile(string, new Predicate[0]);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    private static boolean isJson(Object object) {
        if (object == null || !(object instanceof String)) {
            return false;
        }
        String string = object.toString().trim();
        if (string.length() <= 1) {
            return false;
        }
        char c2 = string.charAt(0);
        char c3 = string.charAt(string.length() - 1);
        if (c2 == '[' && c3 == ']' || c2 == '{' && c3 == '}') {
            try {
                new JSONParser(-1).parse(string);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public static ValueNode toValueNode(Object object) {
        if (object == null) {
            return ValueNodes.NULL_NODE;
        }
        if (object instanceof ValueNode) {
            return (ValueNode)object;
        }
        if (object instanceof Class) {
            return ValueNode.createClassNode((Class)object);
        }
        if (ValueNode.isPath(object)) {
            return new ValueNodes$PathNode(object.toString(), false, false);
        }
        if (ValueNode.isJson(object)) {
            return ValueNode.createJsonNode(object.toString());
        }
        if (object instanceof String) {
            return ValueNode.createStringNode(object.toString(), true);
        }
        if (object instanceof Character) {
            return ValueNode.createStringNode(object.toString(), false);
        }
        if (object instanceof Number) {
            return ValueNode.createNumberNode(object.toString());
        }
        if (object instanceof Boolean) {
            return ValueNode.createBooleanNode(object.toString());
        }
        if (object instanceof Pattern) {
            return ValueNode.createPatternNode((Pattern)object);
        }
        if (object instanceof OffsetDateTime) {
            return ValueNode.createOffsetDateTimeNode(object.toString());
        }
        throw new JsonPathException("Could not determine value type");
    }

    public static ValueNodes$StringNode createStringNode(CharSequence charSequence, boolean bl2) {
        return new ValueNodes$StringNode(charSequence, bl2);
    }

    public static ValueNodes$ClassNode createClassNode(Class clazz) {
        return new ValueNodes$ClassNode(clazz);
    }

    public static ValueNodes$NumberNode createNumberNode(CharSequence charSequence) {
        return new ValueNodes$NumberNode(charSequence);
    }

    public static ValueNodes$BooleanNode createBooleanNode(CharSequence charSequence) {
        return Boolean.parseBoolean(charSequence.toString()) ? ValueNodes.TRUE : ValueNodes.FALSE;
    }

    public static ValueNodes$NullNode createNullNode() {
        return ValueNodes.NULL_NODE;
    }

    public static ValueNodes$JsonNode createJsonNode(CharSequence charSequence) {
        return new ValueNodes$JsonNode(charSequence);
    }

    public static ValueNodes$JsonNode createJsonNode(Object object) {
        return new ValueNodes$JsonNode(object);
    }

    public static ValueNodes$PatternNode createPatternNode(CharSequence charSequence) {
        return new ValueNodes$PatternNode(charSequence);
    }

    public static ValueNodes$PatternNode createPatternNode(Pattern pattern) {
        return new ValueNodes$PatternNode(pattern);
    }

    public static ValueNodes$OffsetDateTimeNode createOffsetDateTimeNode(CharSequence charSequence) {
        return new ValueNodes$OffsetDateTimeNode(charSequence);
    }

    public static ValueNodes$UndefinedNode createUndefinedNode() {
        return ValueNodes.UNDEFINED;
    }

    public static ValueNodes$PathNode createPathNode(CharSequence charSequence, boolean bl2, boolean bl3) {
        return new ValueNodes$PathNode(charSequence, bl2, bl3);
    }

    public static ValueNode createPathNode(Path path) {
        return new ValueNodes$PathNode(path);
    }
}

