/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.internal.filter;

import ia.sh.com.jayway.jsonpath.Predicate$PredicateContext;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNode;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNodes;
import ia.sh.com.jayway.jsonpath.internal.filter.ValueNodes$ValueListNode;
import ia.sh.net.minidev.json.parser.JSONParser;
import ia.sh.net.minidev.json.parser.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ValueNodes$JsonNode
extends ValueNode {
    private final Object json;
    private final boolean parsed;

    ValueNodes$JsonNode(CharSequence charSequence) {
        this.json = charSequence.toString();
        this.parsed = false;
    }

    ValueNodes$JsonNode(Object object) {
        this.json = object;
        this.parsed = true;
    }

    @Override
    public Class type(Predicate$PredicateContext predicate$PredicateContext) {
        if (this.isArray(predicate$PredicateContext)) {
            return List.class;
        }
        if (this.isMap(predicate$PredicateContext)) {
            return Map.class;
        }
        if (this.parse(predicate$PredicateContext) instanceof Number) {
            return Number.class;
        }
        if (this.parse(predicate$PredicateContext) instanceof String) {
            return String.class;
        }
        if (this.parse(predicate$PredicateContext) instanceof Boolean) {
            return Boolean.class;
        }
        return Void.class;
    }

    @Override
    public boolean isJsonNode() {
        return true;
    }

    @Override
    public ValueNodes$JsonNode asJsonNode() {
        return this;
    }

    public ValueNode asValueListNode(Predicate$PredicateContext predicate$PredicateContext) {
        if (!this.isArray(predicate$PredicateContext)) {
            return ValueNodes.UNDEFINED;
        }
        return new ValueNodes$ValueListNode(Collections.unmodifiableList((List)this.parse(predicate$PredicateContext)));
    }

    public Object parse(Predicate$PredicateContext predicate$PredicateContext) {
        try {
            return this.parsed ? this.json : new JSONParser(-1).parse(this.json.toString());
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(parseException);
        }
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public Object getJson() {
        return this.json;
    }

    public boolean isArray(Predicate$PredicateContext predicate$PredicateContext) {
        return this.parse(predicate$PredicateContext) instanceof List;
    }

    public boolean isMap(Predicate$PredicateContext predicate$PredicateContext) {
        return this.parse(predicate$PredicateContext) instanceof Map;
    }

    public int length(Predicate$PredicateContext predicate$PredicateContext) {
        return this.isArray(predicate$PredicateContext) ? ((List)this.parse(predicate$PredicateContext)).size() : -1;
    }

    public boolean isEmpty(Predicate$PredicateContext predicate$PredicateContext) {
        if (this.isArray(predicate$PredicateContext) || this.isMap(predicate$PredicateContext)) {
            return ((Collection)this.parse(predicate$PredicateContext)).size() == 0;
        }
        if (this.parse(predicate$PredicateContext) instanceof String) {
            return ((String)this.parse(predicate$PredicateContext)).length() == 0;
        }
        return true;
    }

    public String toString() {
        return this.json.toString();
    }

    public boolean equals(ValueNodes$JsonNode valueNodes$JsonNode, Predicate$PredicateContext predicate$PredicateContext) {
        if (this == valueNodes$JsonNode) {
            return true;
        }
        return !(this.json == null ? valueNodes$JsonNode.json != null : !this.json.equals(valueNodes$JsonNode.parse(predicate$PredicateContext)));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ValueNodes$JsonNode)) {
            return false;
        }
        ValueNodes$JsonNode valueNodes$JsonNode = (ValueNodes$JsonNode)object;
        return !(this.json == null ? valueNodes$JsonNode.json != null : !this.json.equals(valueNodes$JsonNode.json));
    }
}

