/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.internal.path;

import ia.sh.com.jayway.jsonpath.Filter;
import ia.sh.com.jayway.jsonpath.InvalidPathException;
import ia.sh.com.jayway.jsonpath.Predicate;
import ia.sh.com.jayway.jsonpath.internal.CharacterIndex;
import ia.sh.com.jayway.jsonpath.internal.Path;
import ia.sh.com.jayway.jsonpath.internal.Utils;
import ia.sh.com.jayway.jsonpath.internal.filter.FilterCompiler;
import ia.sh.com.jayway.jsonpath.internal.function.ParamType;
import ia.sh.com.jayway.jsonpath.internal.function.Parameter;
import ia.sh.com.jayway.jsonpath.internal.path.ArrayIndexOperation;
import ia.sh.com.jayway.jsonpath.internal.path.ArraySliceOperation;
import ia.sh.com.jayway.jsonpath.internal.path.CompiledPath;
import ia.sh.com.jayway.jsonpath.internal.path.PathTokenAppender;
import ia.sh.com.jayway.jsonpath.internal.path.PathTokenFactory;
import ia.sh.com.jayway.jsonpath.internal.path.RootPathToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class PathCompiler {
    private static final char DOC_CONTEXT = '$';
    private static final char EVAL_CONTEXT = '@';
    private static final char OPEN_SQUARE_BRACKET = '[';
    private static final char CLOSE_SQUARE_BRACKET = ']';
    private static final char OPEN_PARENTHESIS = '(';
    private static final char CLOSE_PARENTHESIS = ')';
    private static final char OPEN_BRACE = '{';
    private static final char CLOSE_BRACE = '}';
    private static final char WILDCARD = '*';
    private static final char PERIOD = '.';
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final char BEGIN_FILTER = '?';
    private static final char COMMA = ',';
    private static final char SPLIT = ':';
    private static final char MINUS = '-';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private final LinkedList filterStack;
    private final CharacterIndex path;

    private PathCompiler(String string, LinkedList linkedList) {
        this(new CharacterIndex(string), linkedList);
    }

    private PathCompiler(CharacterIndex characterIndex, LinkedList linkedList) {
        this.filterStack = linkedList;
        this.path = characterIndex;
    }

    private Path compile() {
        RootPathToken rootPathToken = this.readContextToken();
        return new CompiledPath(rootPathToken, rootPathToken.getPathFragment().equals("$"));
    }

    public static Path compile(String string, Predicate ... predicateArray) {
        try {
            CharacterIndex characterIndex = new CharacterIndex(string);
            characterIndex.trim();
            if (characterIndex.charAt(0) != '$' && characterIndex.charAt(0) != '@') {
                characterIndex = new CharacterIndex("$." + string);
                characterIndex.trim();
            }
            if (characterIndex.lastCharIs('.')) {
                PathCompiler.fail("Path must not end with a '.' or '..'");
            }
            LinkedList<Predicate> linkedList = new LinkedList<Predicate>(Arrays.asList(predicateArray));
            return new PathCompiler(characterIndex, linkedList).compile();
        }
        catch (Exception exception) {
            InvalidPathException invalidPathException = exception instanceof InvalidPathException ? (InvalidPathException)exception : new InvalidPathException(exception);
            throw invalidPathException;
        }
    }

    private void readWhitespace() {
        char c2;
        while (this.path.inBounds() && this.isWhitespace(c2 = this.path.currentChar())) {
            this.path.incrementPosition(1);
        }
    }

    private Boolean isPathContext(char c2) {
        return c2 == '$' || c2 == '@';
    }

    private RootPathToken readContextToken() {
        this.readWhitespace();
        if (!this.isPathContext(this.path.currentChar()).booleanValue()) {
            throw new InvalidPathException("Path must start with '$' or '@'");
        }
        RootPathToken rootPathToken = PathTokenFactory.createRootPathToken(this.path.currentChar());
        if (this.path.currentIsTail()) {
            return rootPathToken;
        }
        this.path.incrementPosition(1);
        if (this.path.currentChar() != '.' && this.path.currentChar() != '[') {
            PathCompiler.fail("Illegal character at position " + this.path.position() + " expected '.' or '['");
        }
        PathTokenAppender pathTokenAppender = rootPathToken.getPathTokenAppender();
        this.readNextToken(pathTokenAppender);
        return rootPathToken;
    }

    private boolean readNextToken(PathTokenAppender pathTokenAppender) {
        char c2 = this.path.currentChar();
        switch (c2) {
            case '[': {
                if (!(this.readBracketPropertyToken(pathTokenAppender) || this.readArrayToken(pathTokenAppender) || this.readWildCardToken(pathTokenAppender) || this.readFilterToken(pathTokenAppender) || this.readPlaceholderToken(pathTokenAppender))) {
                    PathCompiler.fail("Could not parse token starting at position " + this.path.position() + ". Expected ?, ', 0-9, * ");
                }
                return true;
            }
            case '.': {
                if (!this.readDotToken(pathTokenAppender)) {
                    PathCompiler.fail("Could not parse token starting at position " + this.path.position());
                }
                return true;
            }
            case '*': {
                if (!this.readWildCardToken(pathTokenAppender)) {
                    PathCompiler.fail("Could not parse token starting at position " + this.path.position());
                }
                return true;
            }
        }
        if (!this.readPropertyOrFunctionToken(pathTokenAppender)) {
            PathCompiler.fail("Could not parse token starting at position " + this.path.position());
        }
        return true;
    }

    private boolean readDotToken(PathTokenAppender pathTokenAppender) {
        if (this.path.currentCharIs('.') && this.path.nextCharIs('.')) {
            pathTokenAppender.appendPathToken(PathTokenFactory.crateScanToken());
            this.path.incrementPosition(2);
        } else {
            if (!this.path.hasMoreCharacters()) {
                throw new InvalidPathException("Path must not end with a '.");
            }
            this.path.incrementPosition(1);
        }
        if (this.path.currentCharIs('.')) {
            throw new InvalidPathException("Character '.' on position " + this.path.position() + " is not valid.");
        }
        return this.readNextToken(pathTokenAppender);
    }

    private boolean readPropertyOrFunctionToken(PathTokenAppender pathTokenAppender) {
        int n2;
        if (this.path.currentCharIs('[') || this.path.currentCharIs('*') || this.path.currentCharIs('.') || this.path.currentCharIs(' ')) {
            return false;
        }
        int n3 = n2 = this.path.position();
        int n4 = 0;
        boolean bl2 = false;
        while (this.path.inBounds(n3)) {
            char c2 = this.path.charAt(n3);
            if (c2 == ' ') {
                throw new InvalidPathException("Use bracket notion ['my prop'] if your property contains blank characters. position: " + this.path.position());
            }
            if (c2 == '.' || c2 == '[') {
                n4 = n3;
                break;
            }
            if (c2 == '(') {
                bl2 = true;
                n4 = n3;
                break;
            }
            ++n3;
        }
        if (n4 == 0) {
            n4 = this.path.length();
        }
        List list = null;
        if (bl2) {
            int n5;
            int n6 = 1;
            for (n5 = n3 + 1; n5 < this.path.length(); ++n5) {
                if (this.path.charAt(n5) == ')') {
                    --n6;
                } else if (this.path.charAt(n5) == '(') {
                    ++n6;
                }
                if (n6 == 0) break;
            }
            if (n6 != 0) {
                String string = this.path.subSequence(n2, n4).toString();
                throw new InvalidPathException("Arguments to function: '" + string + "' are not closed properly.");
            }
            if (this.path.inBounds(n3 + 1)) {
                n5 = this.path.charAt(n3 + 1);
                if (n5 != 41) {
                    this.path.setPosition(n4 + 1);
                    String string = this.path.subSequence(n2, n4).toString();
                    list = this.parseFunctionParameters(string);
                } else {
                    this.path.setPosition(n3 + 1);
                }
            } else {
                this.path.setPosition(n3);
            }
        } else {
            this.path.setPosition(n4);
        }
        String string = this.path.subSequence(n2, n4).toString();
        if (bl2) {
            pathTokenAppender.appendPathToken(PathTokenFactory.createFunctionPathToken(string, list));
        } else {
            pathTokenAppender.appendPathToken(PathTokenFactory.createSinglePropertyPathToken(string, '\''));
        }
        return this.path.currentIsTail() || this.readNextToken(pathTokenAppender);
    }

    private List parseFunctionParameters(String string) {
        ParamType paramType = null;
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = false;
        int n6 = 0;
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        StringBuilder stringBuilder = new StringBuilder();
        while (this.path.inBounds() && !bl2) {
            char c2 = this.path.currentChar();
            this.path.incrementPosition(1);
            if (paramType == null) {
                if (this.isWhitespace(c2)) continue;
                if (c2 == '{' || Character.isDigit(c2) || '\"' == c2) {
                    paramType = ParamType.JSON;
                } else if (this.isPathContext(c2).booleanValue()) {
                    paramType = ParamType.PATH;
                }
            }
            switch (c2) {
                case '\"': {
                    if (n6 != 92 && n5 > 0) {
                        --n5;
                        break;
                    }
                    ++n5;
                    break;
                }
                case '(': {
                    ++n2;
                    break;
                }
                case '{': {
                    ++n4;
                    break;
                }
                case '[': {
                    ++n3;
                    break;
                }
                case '}': {
                    if (0 == n4) {
                        throw new InvalidPathException("Unexpected close brace '}' at character position: " + this.path.position());
                    }
                    --n4;
                    break;
                }
                case ']': {
                    if (0 == n3) {
                        throw new InvalidPathException("Unexpected close bracket ']' at character position: " + this.path.position());
                    }
                    --n3;
                    break;
                }
                case ')': {
                    if (0 > --n2 || n6 == 40) {
                        stringBuilder.append(c2);
                    }
                }
                case ',': {
                    if (false != n5 || 0 != n4 || 0 != n3 || (0 != n2 || ')' != c2) && 1 != n2) break;
                    boolean bl3 = bl2 = 0 == n2;
                    if (null == paramType) break;
                    Parameter parameter = null;
                    switch (paramType) {
                        case JSON: {
                            parameter = new Parameter(stringBuilder.toString());
                            break;
                        }
                        case PATH: {
                            LinkedList linkedList = new LinkedList();
                            PathCompiler pathCompiler = new PathCompiler(stringBuilder.toString(), linkedList);
                            parameter = new Parameter(pathCompiler.compile());
                        }
                    }
                    if (null != parameter) {
                        arrayList.add(parameter);
                    }
                    stringBuilder.delete(0, stringBuilder.length());
                    paramType = null;
                }
            }
            if (paramType != null && (c2 != ',' || 0 != n4 || 0 != n3 || 1 != n2)) {
                stringBuilder.append(c2);
            }
            n6 = c2;
        }
        if (0 != n4 || 0 != n2 || 0 != n3) {
            throw new InvalidPathException("Arguments to function: '" + string + "' are not closed properly.");
        }
        return arrayList;
    }

    private boolean isWhitespace(char c2) {
        return c2 == ' ' || c2 == '\t' || c2 == '\n' || c2 == '\r';
    }

    private boolean readPlaceholderToken(PathTokenAppender pathTokenAppender) {
        if (!this.path.currentCharIs('[')) {
            return false;
        }
        int n2 = this.path.indexOfNextSignificantChar('?');
        if (n2 == -1) {
            return false;
        }
        char c2 = this.path.nextSignificantChar(n2);
        if (c2 != ']' && c2 != ',') {
            return false;
        }
        int n3 = this.path.position() + 1;
        int n4 = this.path.nextIndexOf(n3, ']');
        if (n4 == -1) {
            return false;
        }
        String string = this.path.subSequence(n3, n4).toString();
        String[] stringArray = string.split(",");
        if (this.filterStack.size() < stringArray.length) {
            throw new InvalidPathException("Not enough predicates supplied for filter [" + string + "] at position " + this.path.position());
        }
        ArrayList arrayList = new ArrayList();
        for (String string2 : stringArray) {
            string2 = string2 != null ? string2.trim() : null;
            if (!"?".equals(string2 == null ? "" : string2)) {
                throw new InvalidPathException("Expected '?' but found " + string2);
            }
            arrayList.add(this.filterStack.pop());
        }
        pathTokenAppender.appendPathToken(PathTokenFactory.createPredicatePathToken(arrayList));
        this.path.setPosition(n4 + 1);
        return this.path.currentIsTail() || this.readNextToken(pathTokenAppender);
    }

    private boolean readFilterToken(PathTokenAppender pathTokenAppender) {
        if (!this.path.currentCharIs('[') && !this.path.nextSignificantCharIs('?')) {
            return false;
        }
        int n2 = this.path.position();
        int n3 = this.path.indexOfNextSignificantChar('?');
        if (n3 == -1) {
            return false;
        }
        int n4 = this.path.indexOfNextSignificantChar(n3, '(');
        if (n4 == -1) {
            return false;
        }
        int n5 = this.path.indexOfClosingBracket(n4, true, true);
        if (n5 == -1) {
            return false;
        }
        if (!this.path.nextSignificantCharIs(n5, ']')) {
            return false;
        }
        int n6 = this.path.indexOfNextSignificantChar(n5, ']');
        String string = this.path.subSequence(n2, n6 + 1).toString();
        Filter filter = FilterCompiler.compile(string);
        pathTokenAppender.appendPathToken(PathTokenFactory.createPredicatePathToken(filter));
        this.path.setPosition(n6 + 1);
        return this.path.currentIsTail() || this.readNextToken(pathTokenAppender);
    }

    private boolean readWildCardToken(PathTokenAppender pathTokenAppender) {
        boolean bl2 = this.path.currentCharIs('[');
        if (bl2 && !this.path.nextSignificantCharIs('*')) {
            return false;
        }
        if (!this.path.currentCharIs('*') && this.path.isOutOfBounds(this.path.position() + 1)) {
            return false;
        }
        if (bl2) {
            int n2 = this.path.indexOfNextSignificantChar('*');
            if (!this.path.nextSignificantCharIs(n2, ']')) {
                int n3 = n2 + 1;
                throw new InvalidPathException("Expected wildcard token to end with ']' on position " + n3);
            }
            int n4 = this.path.indexOfNextSignificantChar(n2, ']');
            this.path.setPosition(n4 + 1);
        } else {
            this.path.incrementPosition(1);
        }
        pathTokenAppender.appendPathToken(PathTokenFactory.createWildCardPathToken());
        return this.path.currentIsTail() || this.readNextToken(pathTokenAppender);
    }

    private boolean readArrayToken(PathTokenAppender pathTokenAppender) {
        int n2;
        if (!this.path.currentCharIs('[')) {
            return false;
        }
        char c2 = this.path.nextSignificantChar();
        if (!Character.isDigit(c2) && c2 != '-' && c2 != ':') {
            return false;
        }
        int n3 = this.path.position() + 1;
        int n4 = this.path.nextIndexOf(n3, ']');
        if (n4 == -1) {
            return false;
        }
        String string = this.path.subSequence(n3, n4).toString().trim();
        if ("*".equals(string)) {
            return false;
        }
        for (n2 = 0; n2 < string.length(); ++n2) {
            char c3 = string.charAt(n2);
            if (Character.isDigit(c3) || c3 == ',' || c3 == '-' || c3 == ':' || c3 == ' ') continue;
            return false;
        }
        n2 = string.contains(":") ? 1 : 0;
        if (n2 != 0) {
            ArraySliceOperation arraySliceOperation = ArraySliceOperation.parse(string);
            pathTokenAppender.appendPathToken(PathTokenFactory.createSliceArrayPathToken(arraySliceOperation));
        } else {
            ArrayIndexOperation arrayIndexOperation = ArrayIndexOperation.parse(string);
            pathTokenAppender.appendPathToken(PathTokenFactory.createIndexArrayPathToken(arrayIndexOperation));
        }
        this.path.setPosition(n4 + 1);
        return this.path.currentIsTail() || this.readNextToken(pathTokenAppender);
    }

    private boolean readBracketPropertyToken(PathTokenAppender pathTokenAppender) {
        int n2;
        int n3;
        if (!this.path.currentCharIs('[')) {
            return false;
        }
        char c2 = this.path.nextSignificantChar();
        if (c2 != '\'' && c2 != '\"') {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = n3 = this.path.position() + 1;
        int n5 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        while (this.path.inBounds(n4)) {
            n2 = this.path.charAt(n4);
            if (bl3) {
                bl3 = false;
            } else if (92 == n2) {
                bl3 = true;
            } else {
                if (n2 == 93 && !bl2) {
                    if (!bl4) break;
                    PathCompiler.fail("Found empty property at index " + n4);
                    break;
                }
                if (n2 == c2) {
                    if (bl2) {
                        char c3 = this.path.nextSignificantChar(n4);
                        if (c3 != ']' && c3 != ',') {
                            PathCompiler.fail("Property must be separated by comma or Property must be terminated close square bracket at index " + n4);
                        }
                        n5 = n4;
                        String string = this.path.subSequence(n3, n5).toString();
                        arrayList.add(Utils.unescape(string));
                        bl2 = false;
                    } else {
                        n3 = n4 + 1;
                        bl2 = true;
                        bl4 = false;
                    }
                } else if (n2 == 44 && !bl2) {
                    if (bl4) {
                        PathCompiler.fail("Found empty property at index " + n4);
                    }
                    bl4 = true;
                }
            }
            ++n4;
        }
        if (bl2) {
            PathCompiler.fail("Property has not been closed - missing closing " + c2);
        }
        n2 = this.path.indexOfNextSignificantChar(n5, ']') + 1;
        this.path.setPosition(n2);
        pathTokenAppender.appendPathToken(PathTokenFactory.createPropertyPathToken(arrayList, c2));
        return this.path.currentIsTail() || this.readNextToken(pathTokenAppender);
    }

    public static boolean fail(String string) {
        throw new InvalidPathException(string);
    }
}

