/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.com.jayway.jsonpath.internal.path;

import ia.sh.com.jayway.jsonpath.InvalidPathException;
import ia.sh.com.jayway.jsonpath.Option;
import ia.sh.com.jayway.jsonpath.PathNotFoundException;
import ia.sh.com.jayway.jsonpath.internal.PathRef;
import ia.sh.com.jayway.jsonpath.internal.Utils;
import ia.sh.com.jayway.jsonpath.internal.path.EvaluationContextImpl;
import ia.sh.com.jayway.jsonpath.internal.path.PathToken;
import java.util.ArrayList;
import java.util.List;

class PropertyPathToken
extends PathToken {
    private final List properties;
    private final String stringDelimiter;

    public PropertyPathToken(List list, char c2) {
        if (list.isEmpty()) {
            throw new InvalidPathException("Empty properties");
        }
        this.properties = list;
        this.stringDelimiter = Character.toString(c2);
    }

    public List getProperties() {
        return this.properties;
    }

    public boolean singlePropertyCase() {
        return this.properties.size() == 1;
    }

    public boolean multiPropertyMergeCase() {
        return this.isLeaf() && this.properties.size() > 1;
    }

    public boolean multiPropertyIterationCase() {
        return !this.isLeaf() && this.properties.size() > 1;
    }

    @Override
    public void evaluate(String string, PathRef pathRef, Object object, EvaluationContextImpl evaluationContextImpl) {
        assert (Utils.onlyOneIsTrueNonThrow(this.singlePropertyCase(), this.multiPropertyMergeCase(), this.multiPropertyIterationCase()));
        if (!evaluationContextImpl.jsonProvider().isMap(object)) {
            if (!this.isUpstreamDefinite() || evaluationContextImpl.options().contains((Object)Option.SUPPRESS_EXCEPTIONS)) {
                return;
            }
            String string2 = object == null ? "null" : object.getClass().getName();
            throw new PathNotFoundException(String.format("Expected to find an object with property %s in path %s but found '%s'. This is not a json object according to the JsonProvider: '%s'.", this.getPathFragment(), string, string2, evaluationContextImpl.configuration().jsonProvider().getClass().getName()));
        }
        if (this.singlePropertyCase() || this.multiPropertyMergeCase()) {
            this.handleObjectProperty(string, object, evaluationContextImpl, this.properties);
            return;
        }
        assert (this.multiPropertyIterationCase());
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(null);
        for (String string3 : this.properties) {
            arrayList.set(0, string3);
            this.handleObjectProperty(string, object, evaluationContextImpl, arrayList);
        }
    }

    @Override
    public boolean isTokenDefinite() {
        return this.singlePropertyCase() || this.multiPropertyMergeCase();
    }

    @Override
    public String getPathFragment() {
        return "[" + Utils.join(",", this.stringDelimiter, this.properties) + "]";
    }
}

