/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.io.protostuff;

import ia.sh.io.protostuff.ByteString;
import ia.sh.io.protostuff.Input;
import ia.sh.io.protostuff.Output;
import ia.sh.io.protostuff.ProtobufException;
import ia.sh.io.protostuff.Schema;
import ia.sh.io.protostuff.StringSerializer$STRING;
import ia.sh.io.protostuff.UninitializedMessageException;
import ia.sh.io.protostuff.WireFormat;
import java.io.DataInput;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public final class CodedInput
implements Input {
    private final byte[] buffer;
    private int bufferSize;
    private int bufferSizeAfterLimit;
    private int bufferPos;
    private final InputStream input;
    private int lastTag;
    private int packedLimit = 0;
    private int totalBytesRetired;
    private int currentLimit = Integer.MAX_VALUE;
    public final boolean decodeNestedMessageAsGroup;
    private int sizeLimit = 0x4000000;
    static final int DEFAULT_SIZE_LIMIT = 0x4000000;
    static final int DEFAULT_BUFFER_SIZE = 4096;

    public static CodedInput newInstance(InputStream inputStream) {
        return new CodedInput(inputStream, false);
    }

    public static CodedInput newInstance(byte[] byArray) {
        return CodedInput.newInstance(byArray, 0, byArray.length);
    }

    public static CodedInput newInstance(byte[] byArray, int n2, int n3) {
        return new CodedInput(byArray, n2, n3, false);
    }

    public int readTag() {
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        int n2 = this.readRawVarint32();
        if (n2 >>> 3 == 0) {
            throw ProtobufException.invalidTag();
        }
        this.lastTag = n2;
        return n2;
    }

    public void checkLastTagWas(int n2) {
        if (this.lastTag != n2) {
            throw ProtobufException.invalidEndTag();
        }
    }

    public boolean skipField(int n2) {
        switch (WireFormat.getTagWireType(n2)) {
            case 0: {
                this.readInt32();
                return true;
            }
            case 1: {
                this.readRawLittleEndian64();
                return true;
            }
            case 2: {
                this.skipRawBytes(this.readRawVarint32());
                return true;
            }
            case 3: {
                this.skipMessage();
                this.checkLastTagWas(WireFormat.makeTag(WireFormat.getTagFieldNumber(n2), 4));
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.readRawLittleEndian32();
                return true;
            }
        }
        throw ProtobufException.invalidWireType();
    }

    public void skipMessage() {
        int n2;
        while ((n2 = this.readTag()) != 0 && this.skipField(n2)) {
        }
    }

    @Override
    public double readDouble() {
        this.checkIfPackedField();
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    @Override
    public float readFloat() {
        this.checkIfPackedField();
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    @Override
    public long readUInt64() {
        this.checkIfPackedField();
        return this.readRawVarint64();
    }

    @Override
    public long readInt64() {
        this.checkIfPackedField();
        return this.readRawVarint64();
    }

    @Override
    public int readInt32() {
        this.checkIfPackedField();
        return this.readRawVarint32();
    }

    @Override
    public long readFixed64() {
        this.checkIfPackedField();
        return this.readRawLittleEndian64();
    }

    @Override
    public int readFixed32() {
        this.checkIfPackedField();
        return this.readRawLittleEndian32();
    }

    @Override
    public boolean readBool() {
        this.checkIfPackedField();
        return this.readRawVarint32() != 0;
    }

    @Override
    public String readString() {
        int n2 = this.readRawVarint32();
        if (n2 <= this.bufferSize - this.bufferPos && n2 > 0) {
            String string = StringSerializer$STRING.deser(this.buffer, this.bufferPos, n2);
            this.bufferPos += n2;
            return string;
        }
        return StringSerializer$STRING.deser(this.readRawBytes(n2));
    }

    @Override
    public void readBytes(ByteBuffer byteBuffer) {
        int n2 = this.readRawVarint32();
        if (n2 <= this.bufferSize - this.bufferPos && n2 > 0) {
            byteBuffer.limit(n2);
            byteBuffer.put(this.buffer, this.bufferPos, n2);
            this.bufferPos += n2;
        } else {
            byteBuffer.put(this.readRawBytes(n2));
        }
    }

    @Override
    public Object mergeObject(Object object, Schema schema) {
        if (this.decodeNestedMessageAsGroup) {
            return this.mergeObjectEncodedAsGroup(object, schema);
        }
        int n2 = this.readRawVarint32();
        int n3 = this.pushLimit(n2);
        if (object == null) {
            object = schema.newMessage();
        }
        schema.mergeFrom(this, object);
        if (!schema.isInitialized(object)) {
            throw new UninitializedMessageException(object, schema);
        }
        this.checkLastTagWas(0);
        this.popLimit(n3);
        return object;
    }

    private Object mergeObjectEncodedAsGroup(Object object, Schema schema) {
        if (object == null) {
            object = schema.newMessage();
        }
        schema.mergeFrom(this, object);
        if (!schema.isInitialized(object)) {
            throw new UninitializedMessageException(object, schema);
        }
        this.checkLastTagWas(0);
        return object;
    }

    @Override
    public ByteString readBytes() {
        int n2 = this.readRawVarint32();
        if (n2 == 0) {
            return ByteString.EMPTY;
        }
        if (n2 <= this.bufferSize - this.bufferPos && n2 > 0) {
            ByteString byteString = ByteString.copyFrom(this.buffer, this.bufferPos, n2);
            this.bufferPos += n2;
            return byteString;
        }
        return ByteString.wrap(this.readRawBytes(n2));
    }

    @Override
    public int readUInt32() {
        this.checkIfPackedField();
        return this.readRawVarint32();
    }

    @Override
    public int readEnum() {
        this.checkIfPackedField();
        return this.readRawVarint32();
    }

    @Override
    public int readSFixed32() {
        this.checkIfPackedField();
        return this.readRawLittleEndian32();
    }

    @Override
    public long readSFixed64() {
        this.checkIfPackedField();
        return this.readRawLittleEndian64();
    }

    @Override
    public int readSInt32() {
        this.checkIfPackedField();
        return CodedInput.decodeZigZag32(this.readRawVarint32());
    }

    @Override
    public long readSInt64() {
        this.checkIfPackedField();
        return CodedInput.decodeZigZag64(this.readRawVarint64());
    }

    public int readRawVarint32() {
        byte by2 = this.readRawByte();
        if (by2 >= 0) {
            return by2;
        }
        int n2 = by2 & 0x7F;
        by2 = this.readRawByte();
        if (by2 >= 0) {
            n2 |= by2 << 7;
        } else {
            n2 |= (by2 & 0x7F) << 7;
            by2 = this.readRawByte();
            if (by2 >= 0) {
                n2 |= by2 << 14;
            } else {
                n2 |= (by2 & 0x7F) << 14;
                by2 = this.readRawByte();
                if (by2 >= 0) {
                    n2 |= by2 << 21;
                } else {
                    n2 |= (by2 & 0x7F) << 21;
                    by2 = this.readRawByte();
                    n2 |= by2 << 28;
                    if (by2 < 0) {
                        for (int i2 = 0; i2 < 5; ++i2) {
                            if (this.readRawByte() < 0) continue;
                            return n2;
                        }
                        throw ProtobufException.malformedVarint();
                    }
                }
            }
        }
        return n2;
    }

    static int readRawVarint32(InputStream inputStream) {
        int n2 = inputStream.read();
        if (n2 == -1) {
            throw ProtobufException.truncatedMessage();
        }
        if ((n2 & 0x80) == 0) {
            return n2;
        }
        return CodedInput.readRawVarint32(inputStream, n2);
    }

    static int readRawVarint32(InputStream inputStream, int n2) {
        int n3;
        int n4;
        int n5 = n2 & 0x7F;
        for (n4 = 7; n4 < 32; n4 += 7) {
            n3 = inputStream.read();
            if (n3 == -1) {
                throw ProtobufException.truncatedMessage();
            }
            n5 |= (n3 & 0x7F) << n4;
            if ((n3 & 0x80) != 0) continue;
            return n5;
        }
        while (n4 < 64) {
            n3 = inputStream.read();
            if (n3 == -1) {
                throw ProtobufException.truncatedMessage();
            }
            if ((n3 & 0x80) == 0) {
                return n5;
            }
            n4 += 7;
        }
        throw ProtobufException.malformedVarint();
    }

    static int readRawVarint32(DataInput dataInput, byte by2) {
        byte by3;
        int n2;
        int n3 = by2 & 0x7F;
        for (n2 = 7; n2 < 32; n2 += 7) {
            by3 = dataInput.readByte();
            n3 |= (by3 & 0x7F) << n2;
            if ((by3 & 0x80) != 0) continue;
            return n3;
        }
        while (n2 < 64) {
            by3 = dataInput.readByte();
            if ((by3 & 0x80) == 0) {
                return n3;
            }
            n2 += 7;
        }
        throw ProtobufException.malformedVarint();
    }

    public long readRawVarint64() {
        long l2 = 0L;
        for (int i2 = 0; i2 < 64; i2 += 7) {
            byte by2 = this.readRawByte();
            l2 |= (long)(by2 & 0x7F) << i2;
            if ((by2 & 0x80) != 0) continue;
            return l2;
        }
        throw ProtobufException.malformedVarint();
    }

    public int readRawLittleEndian32() {
        byte by2 = this.readRawByte();
        byte by3 = this.readRawByte();
        byte by4 = this.readRawByte();
        byte by5 = this.readRawByte();
        return by2 & 0xFF | (by3 & 0xFF) << 8 | (by4 & 0xFF) << 16 | (by5 & 0xFF) << 24;
    }

    public long readRawLittleEndian64() {
        byte by2 = this.readRawByte();
        byte by3 = this.readRawByte();
        byte by4 = this.readRawByte();
        byte by5 = this.readRawByte();
        byte by6 = this.readRawByte();
        byte by7 = this.readRawByte();
        byte by8 = this.readRawByte();
        byte by9 = this.readRawByte();
        return (long)by2 & 0xFFL | ((long)by3 & 0xFFL) << 8 | ((long)by4 & 0xFFL) << 16 | ((long)by5 & 0xFFL) << 24 | ((long)by6 & 0xFFL) << 32 | ((long)by7 & 0xFFL) << 40 | ((long)by8 & 0xFFL) << 48 | ((long)by9 & 0xFFL) << 56;
    }

    public static int decodeZigZag32(int n2) {
        return n2 >>> 1 ^ -(n2 & 1);
    }

    public static long decodeZigZag64(long l2) {
        return l2 >>> 1 ^ -(l2 & 1L);
    }

    public CodedInput(byte[] byArray, int n2, int n3, boolean bl2) {
        this.buffer = byArray;
        this.bufferSize = n2 + n3;
        this.bufferPos = n2;
        this.totalBytesRetired = -n2;
        this.input = null;
        this.decodeNestedMessageAsGroup = bl2;
    }

    public CodedInput(InputStream inputStream, boolean bl2) {
        this(inputStream, new byte[4096], 0, 0, bl2);
    }

    public CodedInput(InputStream inputStream, byte[] byArray, boolean bl2) {
        this(inputStream, byArray, 0, 0, bl2);
    }

    public CodedInput(InputStream inputStream, byte[] byArray, int n2, int n3, boolean bl2) {
        this.buffer = byArray;
        this.bufferSize = n3;
        this.bufferPos = n2;
        this.totalBytesRetired = -n2;
        this.input = inputStream;
        this.decodeNestedMessageAsGroup = bl2;
    }

    public int setSizeLimit(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Size limit cannot be negative: " + n2);
        }
        int n3 = this.sizeLimit;
        this.sizeLimit = n2;
        return n3;
    }

    public void resetSizeCounter() {
        this.totalBytesRetired = -this.bufferPos;
    }

    public void reset() {
        this.bufferSize = 0;
        this.bufferPos = 0;
        this.bufferSizeAfterLimit = 0;
        this.currentLimit = Integer.MAX_VALUE;
        this.lastTag = 0;
        this.packedLimit = 0;
        this.sizeLimit = 0x4000000;
        this.resetSizeCounter();
    }

    public int pushLimit(int n2) {
        if (n2 < 0) {
            throw ProtobufException.negativeSize();
        }
        int n3 = this.currentLimit;
        if ((n2 += this.totalBytesRetired + this.bufferPos) > n3) {
            throw ProtobufException.truncatedMessage();
        }
        this.currentLimit = n2;
        this.recomputeBufferSizeAfterLimit();
        return n3;
    }

    private void recomputeBufferSizeAfterLimit() {
        this.bufferSize += this.bufferSizeAfterLimit;
        int n2 = this.totalBytesRetired + this.bufferSize;
        if (n2 > this.currentLimit) {
            this.bufferSizeAfterLimit = n2 - this.currentLimit;
            this.bufferSize -= this.bufferSizeAfterLimit;
        } else {
            this.bufferSizeAfterLimit = 0;
        }
    }

    public void popLimit(int n2) {
        this.currentLimit = n2;
        this.recomputeBufferSizeAfterLimit();
    }

    public int getBytesUntilLimit() {
        if (this.currentLimit == Integer.MAX_VALUE) {
            return -1;
        }
        int n2 = this.totalBytesRetired + this.bufferPos;
        return this.currentLimit - n2;
    }

    public boolean isCurrentFieldPacked() {
        return this.packedLimit != 0 && this.packedLimit != this.getTotalBytesRead();
    }

    public boolean isAtEnd() {
        return this.bufferPos == this.bufferSize && !this.refillBuffer(false);
    }

    public int getTotalBytesRead() {
        return this.totalBytesRetired + this.bufferPos;
    }

    private boolean refillBuffer(boolean bl2) {
        if (this.bufferPos < this.bufferSize) {
            throw new IllegalStateException("refillBuffer() called when buffer wasn't empty.");
        }
        if (this.totalBytesRetired + this.bufferSize == this.currentLimit) {
            if (bl2) {
                throw ProtobufException.truncatedMessage();
            }
            return false;
        }
        this.totalBytesRetired += this.bufferSize;
        this.bufferPos = 0;
        int n2 = this.bufferSize = this.input == null ? -1 : this.input.read(this.buffer);
        if (this.bufferSize == 0 || this.bufferSize < -1) {
            throw new IllegalStateException("InputStream#read(byte[]) returned invalid result: " + this.bufferSize + "\nThe InputStream implementation is buggy.");
        }
        if (this.bufferSize == -1) {
            this.bufferSize = 0;
            if (bl2) {
                throw ProtobufException.truncatedMessage();
            }
            return false;
        }
        this.recomputeBufferSizeAfterLimit();
        int n3 = this.totalBytesRetired + this.bufferSize + this.bufferSizeAfterLimit;
        if (n3 > this.sizeLimit || n3 < 0) {
            throw ProtobufException.sizeLimitExceeded();
        }
        return true;
    }

    public byte readRawByte() {
        if (this.bufferPos == this.bufferSize) {
            this.refillBuffer(true);
        }
        return this.buffer[this.bufferPos++];
    }

    public byte[] readRawBytes(int n2) {
        int n3;
        byte[] byArray;
        if (n2 < 0) {
            throw ProtobufException.negativeSize();
        }
        if (this.totalBytesRetired + this.bufferPos + n2 > this.currentLimit) {
            this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.bufferPos);
            throw ProtobufException.truncatedMessage();
        }
        if (n2 <= this.bufferSize - this.bufferPos) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(this.buffer, this.bufferPos, byArray2, 0, n2);
            this.bufferPos += n2;
            return byArray2;
        }
        if (n2 < this.buffer.length) {
            byte[] byArray3 = new byte[n2];
            int n4 = this.bufferSize - this.bufferPos;
            System.arraycopy(this.buffer, this.bufferPos, byArray3, 0, n4);
            this.bufferPos = this.bufferSize;
            this.refillBuffer(true);
            while (n2 - n4 > this.bufferSize) {
                System.arraycopy(this.buffer, 0, byArray3, n4, this.bufferSize);
                n4 += this.bufferSize;
                this.bufferPos = this.bufferSize;
                this.refillBuffer(true);
            }
            System.arraycopy(this.buffer, 0, byArray3, n4, n2 - n4);
            this.bufferPos = n2 - n4;
            return byArray3;
        }
        int n5 = this.bufferPos;
        int n6 = this.bufferSize;
        this.totalBytesRetired += this.bufferSize;
        this.bufferPos = 0;
        this.bufferSize = 0;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (int i2 = n2 - (n6 - n5); i2 > 0; i2 -= byArray.length) {
            int n7;
            byArray = new byte[Math.min(i2, this.buffer.length)];
            for (n3 = 0; n3 < byArray.length; n3 += n7) {
                int n8 = n7 = this.input == null ? -1 : this.input.read(byArray, n3, byArray.length - n3);
                if (n7 == -1) {
                    throw ProtobufException.truncatedMessage();
                }
                this.totalBytesRetired += n7;
            }
            arrayList.add(byArray);
        }
        byArray = new byte[n2];
        n3 = n6 - n5;
        System.arraycopy(this.buffer, n5, byArray, 0, n3);
        for (byte[] byArray4 : arrayList) {
            System.arraycopy(byArray4, 0, byArray, n3, byArray4.length);
            n3 += byArray4.length;
        }
        return byArray;
    }

    public void skipRawBytes(int n2) {
        if (n2 < 0) {
            throw ProtobufException.negativeSize();
        }
        if (this.totalBytesRetired + this.bufferPos + n2 > this.currentLimit) {
            this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.bufferPos);
            throw ProtobufException.truncatedMessage();
        }
        if (n2 <= this.bufferSize - this.bufferPos) {
            this.bufferPos += n2;
        } else {
            int n3 = this.bufferSize - this.bufferPos;
            this.bufferPos = this.bufferSize;
            this.refillBuffer(true);
            while (n2 - n3 > this.bufferSize) {
                n3 += this.bufferSize;
                this.bufferPos = this.bufferSize;
                this.refillBuffer(true);
            }
            this.bufferPos = n2 - n3;
        }
    }

    @Override
    public int readFieldNumber(Schema schema) {
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        if (this.isCurrentFieldPacked()) {
            if (this.packedLimit < this.getTotalBytesRead()) {
                throw ProtobufException.misreportedSize();
            }
            return this.lastTag >>> 3;
        }
        this.packedLimit = 0;
        int n2 = this.readRawVarint32();
        int n3 = n2 >>> 3;
        if (n3 == 0) {
            if (this.decodeNestedMessageAsGroup && 7 == (n2 & 7)) {
                this.lastTag = 0;
                return 0;
            }
            throw ProtobufException.invalidTag();
        }
        if (this.decodeNestedMessageAsGroup && 4 == (n2 & 7)) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = n2;
        return n3;
    }

    private void checkIfPackedField() {
        if (this.packedLimit == 0 && WireFormat.getTagWireType(this.lastTag) == 2) {
            int n2 = this.readRawVarint32();
            if (n2 < 0) {
                throw ProtobufException.negativeSize();
            }
            this.packedLimit = this.getTotalBytesRead() + n2;
        }
    }

    @Override
    public byte[] readByteArray() {
        int n2 = this.readRawVarint32();
        if (n2 <= this.bufferSize - this.bufferPos && n2 > 0) {
            byte[] byArray = new byte[n2];
            System.arraycopy(this.buffer, this.bufferPos, byArray, 0, n2);
            this.bufferPos += n2;
            return byArray;
        }
        return this.readRawBytes(n2);
    }

    @Override
    public void handleUnknownField(int n2, Schema schema) {
        this.skipField(this.lastTag);
    }

    @Override
    public void transferByteRangeTo(Output output, boolean bl2, int n2, boolean bl3) {
        int n3 = this.readRawVarint32();
        if (n3 <= this.bufferSize - this.bufferPos && n3 > 0) {
            output.writeByteRange(bl2, n2, this.buffer, this.bufferPos, n3, bl3);
            this.bufferPos += n3;
        } else {
            output.writeByteRange(bl2, n2, this.readRawBytes(n3), 0, n3, bl3);
        }
    }

    public int getLastTag() {
        return this.lastTag;
    }

    @Override
    public ByteBuffer readByteBuffer() {
        return ByteBuffer.wrap(this.readByteArray());
    }
}

