/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.util;

import ia.sh.org.apache.commons.math3.Field;
import ia.sh.org.apache.commons.math3.distribution.UniformIntegerDistribution;
import ia.sh.org.apache.commons.math3.exception.DimensionMismatchException;
import ia.sh.org.apache.commons.math3.exception.MathArithmeticException;
import ia.sh.org.apache.commons.math3.exception.MathIllegalArgumentException;
import ia.sh.org.apache.commons.math3.exception.MathInternalError;
import ia.sh.org.apache.commons.math3.exception.NoDataException;
import ia.sh.org.apache.commons.math3.exception.NonMonotonicSequenceException;
import ia.sh.org.apache.commons.math3.exception.NotANumberException;
import ia.sh.org.apache.commons.math3.exception.NotPositiveException;
import ia.sh.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import ia.sh.org.apache.commons.math3.exception.NullArgumentException;
import ia.sh.org.apache.commons.math3.exception.NumberIsTooLargeException;
import ia.sh.org.apache.commons.math3.exception.util.Localizable;
import ia.sh.org.apache.commons.math3.exception.util.LocalizedFormats;
import ia.sh.org.apache.commons.math3.random.RandomGenerator;
import ia.sh.org.apache.commons.math3.random.Well19937c;
import ia.sh.org.apache.commons.math3.util.FastMath;
import ia.sh.org.apache.commons.math3.util.MathArrays$1;
import ia.sh.org.apache.commons.math3.util.MathArrays$2;
import ia.sh.org.apache.commons.math3.util.MathArrays$OrderDirection;
import ia.sh.org.apache.commons.math3.util.MathArrays$PairDoubleInteger;
import ia.sh.org.apache.commons.math3.util.MathArrays$Position;
import ia.sh.org.apache.commons.math3.util.MathUtils;
import ia.sh.org.apache.commons.math3.util.Precision;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

public class MathArrays {
    private MathArrays() {
    }

    public static double[] scale(double d2, double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray2[i2] = dArray[i2] * d2;
        }
        return dArray2;
    }

    public static void scaleInPlace(double d2, double[] dArray) {
        int n2 = 0;
        while (n2 < dArray.length) {
            int n3 = n2++;
            dArray[n3] = dArray[n3] * d2;
        }
    }

    public static double[] ebeAdd(double[] dArray, double[] dArray2) {
        MathArrays.checkEqualLength(dArray, dArray2);
        double[] dArray3 = (double[])dArray.clone();
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            int n2 = i2;
            dArray3[n2] = dArray3[n2] + dArray2[i2];
        }
        return dArray3;
    }

    public static double[] ebeSubtract(double[] dArray, double[] dArray2) {
        MathArrays.checkEqualLength(dArray, dArray2);
        double[] dArray3 = (double[])dArray.clone();
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            int n2 = i2;
            dArray3[n2] = dArray3[n2] - dArray2[i2];
        }
        return dArray3;
    }

    public static double[] ebeMultiply(double[] dArray, double[] dArray2) {
        MathArrays.checkEqualLength(dArray, dArray2);
        double[] dArray3 = (double[])dArray.clone();
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            int n2 = i2;
            dArray3[n2] = dArray3[n2] * dArray2[i2];
        }
        return dArray3;
    }

    public static double[] ebeDivide(double[] dArray, double[] dArray2) {
        MathArrays.checkEqualLength(dArray, dArray2);
        double[] dArray3 = (double[])dArray.clone();
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            int n2 = i2;
            dArray3[n2] = dArray3[n2] / dArray2[i2];
        }
        return dArray3;
    }

    public static double distance1(double[] dArray, double[] dArray2) {
        MathArrays.checkEqualLength(dArray, dArray2);
        double d2 = 0.0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            d2 += FastMath.abs(dArray[i2] - dArray2[i2]);
        }
        return d2;
    }

    public static int distance1(int[] nArray, int[] nArray2) {
        MathArrays.checkEqualLength(nArray, nArray2);
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            n2 += FastMath.abs(nArray[i2] - nArray2[i2]);
        }
        return n2;
    }

    public static double distance(double[] dArray, double[] dArray2) {
        MathArrays.checkEqualLength(dArray, dArray2);
        double d2 = 0.0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            double d3 = dArray[i2] - dArray2[i2];
            d2 += d3 * d3;
        }
        return FastMath.sqrt(d2);
    }

    public static double cosAngle(double[] dArray, double[] dArray2) {
        return MathArrays.linearCombination(dArray, dArray2) / (MathArrays.safeNorm(dArray) * MathArrays.safeNorm(dArray2));
    }

    public static double distance(int[] nArray, int[] nArray2) {
        MathArrays.checkEqualLength(nArray, nArray2);
        double d2 = 0.0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            double d3 = nArray[i2] - nArray2[i2];
            d2 += d3 * d3;
        }
        return FastMath.sqrt(d2);
    }

    public static double distanceInf(double[] dArray, double[] dArray2) {
        MathArrays.checkEqualLength(dArray, dArray2);
        double d2 = 0.0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            d2 = FastMath.max(d2, FastMath.abs(dArray[i2] - dArray2[i2]));
        }
        return d2;
    }

    public static int distanceInf(int[] nArray, int[] nArray2) {
        MathArrays.checkEqualLength(nArray, nArray2);
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            n2 = FastMath.max(n2, FastMath.abs(nArray[i2] - nArray2[i2]));
        }
        return n2;
    }

    public static boolean isMonotonic(Comparable[] comparableArray, MathArrays$OrderDirection mathArrays$OrderDirection, boolean bl2) {
        Comparable comparable = comparableArray[0];
        int n2 = comparableArray.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            switch (mathArrays$OrderDirection) {
                case INCREASING: {
                    int n3 = comparable.compareTo(comparableArray[i2]);
                    if (!(bl2 ? n3 >= 0 : n3 > 0)) break;
                    return false;
                }
                case DECREASING: {
                    int n3 = comparableArray[i2].compareTo(comparable);
                    if (!(bl2 ? n3 >= 0 : n3 > 0)) break;
                    return false;
                }
                default: {
                    throw new MathInternalError();
                }
            }
            comparable = comparableArray[i2];
        }
        return true;
    }

    public static boolean isMonotonic(double[] dArray, MathArrays$OrderDirection mathArrays$OrderDirection, boolean bl2) {
        return MathArrays.checkOrder(dArray, mathArrays$OrderDirection, bl2, false);
    }

    public static boolean checkEqualLength(double[] dArray, double[] dArray2, boolean bl2) {
        if (dArray.length == dArray2.length) {
            return true;
        }
        if (bl2) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        return false;
    }

    public static void checkEqualLength(double[] dArray, double[] dArray2) {
        MathArrays.checkEqualLength(dArray, dArray2, true);
    }

    public static boolean checkEqualLength(int[] nArray, int[] nArray2, boolean bl2) {
        if (nArray.length == nArray2.length) {
            return true;
        }
        if (bl2) {
            throw new DimensionMismatchException(nArray.length, nArray2.length);
        }
        return false;
    }

    public static void checkEqualLength(int[] nArray, int[] nArray2) {
        MathArrays.checkEqualLength(nArray, nArray2, true);
    }

    public static boolean checkOrder(double[] dArray, MathArrays$OrderDirection mathArrays$OrderDirection, boolean bl2, boolean bl3) {
        int n2;
        double d2 = dArray[0];
        int n3 = dArray.length;
        block4: for (n2 = 1; n2 < n3; ++n2) {
            switch (mathArrays$OrderDirection) {
                case INCREASING: {
                    if (!(bl2 ? dArray[n2] <= d2 : dArray[n2] < d2)) break;
                    break block4;
                }
                case DECREASING: {
                    if (!(bl2 ? dArray[n2] >= d2 : dArray[n2] > d2)) break;
                    break block4;
                }
                default: {
                    throw new MathInternalError();
                }
            }
            d2 = dArray[n2];
        }
        if (n2 == n3) {
            return true;
        }
        if (bl3) {
            throw new NonMonotonicSequenceException(dArray[n2], (Number)d2, n2, mathArrays$OrderDirection, bl2);
        }
        return false;
    }

    public static void checkOrder(double[] dArray, MathArrays$OrderDirection mathArrays$OrderDirection, boolean bl2) {
        MathArrays.checkOrder(dArray, mathArrays$OrderDirection, bl2, true);
    }

    public static void checkOrder(double[] dArray) {
        MathArrays.checkOrder(dArray, MathArrays$OrderDirection.INCREASING, true);
    }

    public static void checkRectangular(long[][] lArray) {
        MathUtils.checkNotNull(lArray);
        for (int i2 = 1; i2 < lArray.length; ++i2) {
            if (lArray[i2].length == lArray[0].length) continue;
            throw new DimensionMismatchException((Localizable)LocalizedFormats.DIFFERENT_ROWS_LENGTHS, lArray[i2].length, lArray[0].length);
        }
    }

    public static void checkPositive(double[] dArray) {
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (!(dArray[i2] <= 0.0)) continue;
            throw new NotStrictlyPositiveException(dArray[i2]);
        }
    }

    public static void checkNotNaN(double[] dArray) {
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (!Double.isNaN(dArray[i2])) continue;
            throw new NotANumberException();
        }
    }

    public static void checkNonNegative(long[] lArray) {
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            if (lArray[i2] >= 0L) continue;
            throw new NotPositiveException(lArray[i2]);
        }
    }

    public static void checkNonNegative(long[][] lArray) {
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            for (int i3 = 0; i3 < lArray[i2].length; ++i3) {
                if (lArray[i2][i3] >= 0L) continue;
                throw new NotPositiveException(lArray[i2][i3]);
            }
        }
    }

    public static double safeNorm(double[] dArray) {
        double d2 = 3.834E-20;
        double d3 = 1.304E19;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = dArray.length;
        double d10 = d3 / d9;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            double d11 = FastMath.abs(dArray[i2]);
            if (d11 < d2 || d11 > d10) {
                double d12;
                if (d11 > d2) {
                    if (d11 > d7) {
                        d12 = d7 / d11;
                        d4 = 1.0 + d4 * d12 * d12;
                        d7 = d11;
                        continue;
                    }
                    d12 = d11 / d7;
                    d4 += d12 * d12;
                    continue;
                }
                if (d11 > d8) {
                    d12 = d8 / d11;
                    d6 = 1.0 + d6 * d12 * d12;
                    d8 = d11;
                    continue;
                }
                if (d11 == 0.0) continue;
                d12 = d11 / d8;
                d6 += d12 * d12;
                continue;
            }
            d5 += d11 * d11;
        }
        double d13 = d4 != 0.0 ? d7 * Math.sqrt(d4 + d5 / d7 / d7) : (d5 == 0.0 ? d8 * Math.sqrt(d6) : (d5 >= d8 ? Math.sqrt(d5 * (1.0 + d8 / d5 * (d8 * d6))) : Math.sqrt(d8 * (d5 / d8 + d8 * d6))));
        return d13;
    }

    public static void sortInPlace(double[] dArray, double[] ... dArray2) {
        MathArrays.sortInPlace(dArray, MathArrays$OrderDirection.INCREASING, dArray2);
    }

    public static void sortInPlace(double[] dArray, MathArrays$OrderDirection mathArrays$OrderDirection, double[] ... dArray2) {
        Object object;
        int n2;
        if (dArray == null) {
            throw new NullArgumentException();
        }
        int n3 = dArray2.length;
        int n4 = dArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            double[] dArray3 = dArray2[i2];
            if (dArray3 == null) {
                throw new NullArgumentException();
            }
            if (dArray3.length == n4) continue;
            throw new DimensionMismatchException(dArray3.length, n4);
        }
        ArrayList<MathArrays$PairDoubleInteger> arrayList = new ArrayList<MathArrays$PairDoubleInteger>(n4);
        for (int i3 = 0; i3 < n4; ++i3) {
            arrayList.add(new MathArrays$PairDoubleInteger(dArray[i3], i3));
        }
        Comparator comparator = mathArrays$OrderDirection == MathArrays$OrderDirection.INCREASING ? new MathArrays$1() : new MathArrays$2();
        Collections.sort(arrayList, comparator);
        int[] nArray = new int[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            object = (MathArrays$PairDoubleInteger)arrayList.get(n2);
            dArray[n2] = ((MathArrays$PairDoubleInteger)object).getKey();
            nArray[n2] = ((MathArrays$PairDoubleInteger)object).getValue();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            object = dArray2[n2];
            double[] dArray4 = (double[])object.clone();
            for (int i4 = 0; i4 < n4; ++i4) {
                object[i4] = dArray4[nArray[i4]];
            }
        }
    }

    public static int[] copyOf(int[] nArray) {
        return MathArrays.copyOf(nArray, nArray.length);
    }

    public static double[] copyOf(double[] dArray) {
        return MathArrays.copyOf(dArray, dArray.length);
    }

    public static int[] copyOf(int[] nArray, int n2) {
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, FastMath.min(n2, nArray.length));
        return nArray2;
    }

    public static double[] copyOf(double[] dArray, int n2) {
        double[] dArray2 = new double[n2];
        System.arraycopy(dArray, 0, dArray2, 0, FastMath.min(n2, dArray.length));
        return dArray2;
    }

    public static double[] copyOfRange(double[] dArray, int n2, int n3) {
        int n4 = n3 - n2;
        double[] dArray2 = new double[n4];
        System.arraycopy(dArray, n2, dArray2, 0, FastMath.min(n4, dArray.length - n2));
        return dArray2;
    }

    public static double linearCombination(double[] dArray, double[] dArray2) {
        MathArrays.checkEqualLength(dArray, dArray2);
        int n2 = dArray.length;
        if (n2 == 1) {
            return dArray[0] * dArray2[0];
        }
        double[] dArray3 = new double[n2];
        double d2 = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            double d3 = dArray[i2];
            double d4 = Double.longBitsToDouble(Double.doubleToRawLongBits(d3) & 0xFFFFFFFFF8000000L);
            double d5 = d3 - d4;
            double d6 = dArray2[i2];
            double d7 = Double.longBitsToDouble(Double.doubleToRawLongBits(d6) & 0xFFFFFFFFF8000000L);
            double d8 = d6 - d7;
            dArray3[i2] = d3 * d6;
            double d9 = d5 * d8 - (dArray3[i2] - d4 * d7 - d5 * d7 - d4 * d8);
            d2 += d9;
        }
        double d10 = dArray3[0];
        double d11 = dArray3[1];
        double d12 = d10 + d11;
        double d13 = d12 - d11;
        double d14 = d11 - (d12 - d13) + (d10 - d13);
        int n3 = n2 - 1;
        for (int i3 = 1; i3 < n3; ++i3) {
            d11 = dArray3[i3 + 1];
            double d15 = d12 + d11;
            d13 = d15 - d11;
            d14 += d11 - (d15 - d13) + (d12 - d13);
            d12 = d15;
        }
        double d16 = d12 + (d2 + d14);
        if (Double.isNaN(d16)) {
            d16 = 0.0;
            for (int i4 = 0; i4 < n2; ++i4) {
                d16 += dArray[i4] * dArray2[i4];
            }
        }
        return d16;
    }

    public static double linearCombination(double d2, double d3, double d4, double d5) {
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15 = d2 * d3;
        double d16 = d4 * d5;
        double d17 = d15 + d16;
        double d18 = Double.longBitsToDouble(Double.doubleToRawLongBits(d2) & 0xFFFFFFFFF8000000L);
        double d19 = d2 - d18;
        double d20 = d19 * (d14 = d3 - (d13 = Double.longBitsToDouble(Double.doubleToRawLongBits(d3) & 0xFFFFFFFFF8000000L))) - (d15 - d18 * d13 - d19 * d13 - d18 * d14);
        double d21 = d17 + (d20 + (d12 = (d11 = d4 - (d10 = Double.longBitsToDouble(Double.doubleToRawLongBits(d4) & 0xFFFFFFFFF8000000L))) * (d9 = d5 - (d8 = Double.longBitsToDouble(Double.doubleToRawLongBits(d5) & 0xFFFFFFFFF8000000L))) - (d16 - d10 * d8 - d11 * d8 - d10 * d9)) + (d7 = d16 - (d17 - (d6 = d17 - d16)) + (d15 - d6)));
        if (Double.isNaN(d21)) {
            d21 = d2 * d3 + d4 * d5;
        }
        return d21;
    }

    public static double linearCombination(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        double d16;
        double d17;
        double d18;
        double d19;
        double d20;
        double d21;
        double d22;
        double d23;
        double d24 = d2 * d3;
        double d25 = d4 * d5;
        double d26 = d24 + d25;
        double d27 = d6 * d7;
        double d28 = d26 + d27;
        double d29 = Double.longBitsToDouble(Double.doubleToRawLongBits(d2) & 0xFFFFFFFFF8000000L);
        double d30 = d2 - d29;
        double d31 = d30 * (d23 = d3 - (d22 = Double.longBitsToDouble(Double.doubleToRawLongBits(d3) & 0xFFFFFFFFF8000000L))) - (d24 - d29 * d22 - d30 * d22 - d29 * d23);
        double d32 = d28 + (d31 + (d21 = (d20 = d4 - (d19 = Double.longBitsToDouble(Double.doubleToRawLongBits(d4) & 0xFFFFFFFFF8000000L))) * (d18 = d5 - (d17 = Double.longBitsToDouble(Double.doubleToRawLongBits(d5) & 0xFFFFFFFFF8000000L))) - (d25 - d19 * d17 - d20 * d17 - d19 * d18)) + (d16 = (d15 = d6 - (d14 = Double.longBitsToDouble(Double.doubleToRawLongBits(d6) & 0xFFFFFFFFF8000000L))) * (d13 = d7 - (d12 = Double.longBitsToDouble(Double.doubleToRawLongBits(d7) & 0xFFFFFFFFF8000000L))) - (d27 - d14 * d12 - d15 * d12 - d14 * d13)) + (d11 = d25 - (d26 - (d10 = d26 - d25)) + (d24 - d10)) + (d9 = d27 - (d28 - (d8 = d28 - d27)) + (d26 - d8)));
        if (Double.isNaN(d32)) {
            d32 = d2 * d3 + d4 * d5 + d6 * d7;
        }
        return d32;
    }

    public static double linearCombination(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        double d16;
        double d17;
        double d18;
        double d19;
        double d20;
        double d21;
        double d22;
        double d23;
        double d24;
        double d25;
        double d26;
        double d27;
        double d28;
        double d29;
        double d30;
        double d31;
        double d32;
        double d33 = d2 * d3;
        double d34 = d4 * d5;
        double d35 = d33 + d34;
        double d36 = d6 * d7;
        double d37 = d35 + d36;
        double d38 = d8 * d9;
        double d39 = d37 + d38;
        double d40 = Double.longBitsToDouble(Double.doubleToRawLongBits(d2) & 0xFFFFFFFFF8000000L);
        double d41 = d2 - d40;
        double d42 = d41 * (d32 = d3 - (d31 = Double.longBitsToDouble(Double.doubleToRawLongBits(d3) & 0xFFFFFFFFF8000000L))) - (d33 - d40 * d31 - d41 * d31 - d40 * d32);
        double d43 = d39 + (d42 + (d30 = (d29 = d4 - (d28 = Double.longBitsToDouble(Double.doubleToRawLongBits(d4) & 0xFFFFFFFFF8000000L))) * (d27 = d5 - (d26 = Double.longBitsToDouble(Double.doubleToRawLongBits(d5) & 0xFFFFFFFFF8000000L))) - (d34 - d28 * d26 - d29 * d26 - d28 * d27)) + (d25 = (d24 = d6 - (d23 = Double.longBitsToDouble(Double.doubleToRawLongBits(d6) & 0xFFFFFFFFF8000000L))) * (d22 = d7 - (d21 = Double.longBitsToDouble(Double.doubleToRawLongBits(d7) & 0xFFFFFFFFF8000000L))) - (d36 - d23 * d21 - d24 * d21 - d23 * d22)) + (d20 = (d19 = d8 - (d18 = Double.longBitsToDouble(Double.doubleToRawLongBits(d8) & 0xFFFFFFFFF8000000L))) * (d17 = d9 - (d16 = Double.longBitsToDouble(Double.doubleToRawLongBits(d9) & 0xFFFFFFFFF8000000L))) - (d38 - d18 * d16 - d19 * d16 - d18 * d17)) + (d15 = d34 - (d35 - (d14 = d35 - d34)) + (d33 - d14)) + (d13 = d36 - (d37 - (d12 = d37 - d36)) + (d35 - d12)) + (d11 = d38 - (d39 - (d10 = d39 - d38)) + (d37 - d10)));
        if (Double.isNaN(d43)) {
            d43 = d2 * d3 + d4 * d5 + d6 * d7 + d8 * d9;
        }
        return d43;
    }

    public static boolean equals(float[] fArray, float[] fArray2) {
        if (fArray == null || fArray2 == null) {
            return !(fArray == null ^ fArray2 == null);
        }
        if (fArray.length != fArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (Precision.equals(fArray[i2], fArray2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIncludingNaN(float[] fArray, float[] fArray2) {
        if (fArray == null || fArray2 == null) {
            return !(fArray == null ^ fArray2 == null);
        }
        if (fArray.length != fArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (Precision.equalsIncludingNaN(fArray[i2], fArray2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            return !(dArray == null ^ dArray2 == null);
        }
        if (dArray.length != dArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (Precision.equals(dArray[i2], dArray2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIncludingNaN(double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            return !(dArray == null ^ dArray2 == null);
        }
        if (dArray.length != dArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (Precision.equalsIncludingNaN(dArray[i2], dArray2[i2])) continue;
            return false;
        }
        return true;
    }

    public static double[] normalizeArray(double[] dArray, double d2) {
        int n2;
        if (Double.isInfinite(d2)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NORMALIZE_INFINITE, new Object[0]);
        }
        if (Double.isNaN(d2)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NORMALIZE_NAN, new Object[0]);
        }
        double d3 = 0.0;
        int n3 = dArray.length;
        double[] dArray2 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            if (Double.isInfinite(dArray[n2])) {
                throw new MathIllegalArgumentException(LocalizedFormats.INFINITE_ARRAY_ELEMENT, dArray[n2], n2);
            }
            if (Double.isNaN(dArray[n2])) continue;
            d3 += dArray[n2];
        }
        if (d3 == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ARRAY_SUMS_TO_ZERO, new Object[0]);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArray2[n2] = Double.isNaN(dArray[n2]) ? Double.NaN : dArray[n2] * d2 / d3;
        }
        return dArray2;
    }

    public static Object[] buildArray(Field field, int n2) {
        Object[] objectArray = (Object[])Array.newInstance(field.getRuntimeClass(), n2);
        Arrays.fill(objectArray, field.getZero());
        return objectArray;
    }

    public static Object[][] buildArray(Field field, int n2, int n3) {
        Object[][] objectArray;
        if (n3 < 0) {
            Object[] objectArray2 = MathArrays.buildArray(field, 0);
            objectArray = (Object[][])Array.newInstance(objectArray2.getClass(), n2);
        } else {
            objectArray = (Object[][])Array.newInstance(field.getRuntimeClass(), n2, n3);
            for (int i2 = 0; i2 < n2; ++i2) {
                Arrays.fill(objectArray[i2], field.getZero());
            }
        }
        return objectArray;
    }

    public static double[] convolve(double[] dArray, double[] dArray2) {
        MathUtils.checkNotNull(dArray);
        MathUtils.checkNotNull(dArray2);
        int n2 = dArray.length;
        int n3 = dArray2.length;
        if (n2 == 0 || n3 == 0) {
            throw new NoDataException();
        }
        int n4 = n2 + n3 - 1;
        double[] dArray3 = new double[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            double d2 = 0.0;
            int n5 = FastMath.max(0, i2 + 1 - n2);
            int n6 = i2 - n5;
            while (n5 < n3 && n6 >= 0) {
                d2 += dArray[n6--] * dArray2[n5++];
            }
            dArray3[i2] = d2;
        }
        return dArray3;
    }

    public static void shuffle(int[] nArray, int n2, MathArrays$Position mathArrays$Position) {
        MathArrays.shuffle(nArray, n2, mathArrays$Position, new Well19937c());
    }

    public static void shuffle(int[] nArray, int n2, MathArrays$Position mathArrays$Position, RandomGenerator randomGenerator) {
        switch (mathArrays$Position) {
            case TAIL: {
                for (int i2 = nArray.length - 1; i2 >= n2; --i2) {
                    int n3 = i2 == n2 ? n2 : new UniformIntegerDistribution(randomGenerator, n2, i2).sample();
                    int n4 = nArray[n3];
                    nArray[n3] = nArray[i2];
                    nArray[i2] = n4;
                }
                break;
            }
            case HEAD: {
                for (int i3 = 0; i3 <= n2; ++i3) {
                    int n5 = i3 == n2 ? n2 : new UniformIntegerDistribution(randomGenerator, i3, n2).sample();
                    int n6 = nArray[n5];
                    nArray[n5] = nArray[i3];
                    nArray[i3] = n6;
                }
                break;
            }
            default: {
                throw new MathInternalError();
            }
        }
    }

    public static void shuffle(int[] nArray, RandomGenerator randomGenerator) {
        MathArrays.shuffle(nArray, 0, MathArrays$Position.TAIL, randomGenerator);
    }

    public static void shuffle(int[] nArray) {
        MathArrays.shuffle(nArray, new Well19937c());
    }

    public static int[] natural(int n2) {
        return MathArrays.sequence(n2, 0, 1);
    }

    public static int[] sequence(int n2, int n3, int n4) {
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = n3 + i2 * n4;
        }
        return nArray;
    }

    public static boolean verifyValues(double[] dArray, int n2, int n3) {
        return MathArrays.verifyValues(dArray, n2, n3, false);
    }

    public static boolean verifyValues(double[] dArray, int n2, int n3, boolean bl2) {
        if (dArray == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        if (n2 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.START_POSITION, n2);
        }
        if (n3 < 0) {
            throw new NotPositiveException((Localizable)LocalizedFormats.LENGTH, n3);
        }
        if (n2 + n3 > dArray.length) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.SUBARRAY_ENDS_AFTER_ARRAY_END, (Number)(n2 + n3), dArray.length, true);
        }
        return n3 != 0 || bl2;
    }

    public static boolean verifyValues(double[] dArray, double[] dArray2, int n2, int n3) {
        return MathArrays.verifyValues(dArray, dArray2, n2, n3, false);
    }

    public static boolean verifyValues(double[] dArray, double[] dArray2, int n2, int n3, boolean bl2) {
        if (dArray2 == null || dArray == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        MathArrays.checkEqualLength(dArray2, dArray);
        boolean bl3 = false;
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            double d2 = dArray2[i2];
            if (Double.isNaN(d2)) {
                throw new MathIllegalArgumentException(LocalizedFormats.NAN_ELEMENT_AT_INDEX, i2);
            }
            if (Double.isInfinite(d2)) {
                throw new MathIllegalArgumentException(LocalizedFormats.INFINITE_ARRAY_ELEMENT, d2, i2);
            }
            if (d2 < 0.0) {
                throw new MathIllegalArgumentException(LocalizedFormats.NEGATIVE_ELEMENT_AT_INDEX, i2, d2);
            }
            if (bl3 || !(d2 > 0.0)) continue;
            bl3 = true;
        }
        if (!bl3) {
            throw new MathIllegalArgumentException(LocalizedFormats.WEIGHT_AT_LEAST_ONE_NON_ZERO, new Object[0]);
        }
        return MathArrays.verifyValues(dArray, n2, n3, bl2);
    }

    public static double[] concatenate(double[] ... dArray) {
        int n2 = 0;
        for (double[] dArray2 : dArray) {
            n2 += dArray2.length;
        }
        int n3 = 0;
        int n4 = 0;
        double[] dArray3 = new double[n2];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            n4 = dArray[i2].length;
            System.arraycopy(dArray[i2], 0, dArray3, n3, n4);
            n3 += n4;
        }
        return dArray3;
    }

    public static double[] unique(double[] dArray) {
        int n2;
        TreeSet<Double> treeSet = new TreeSet<Double>();
        for (n2 = 0; n2 < dArray.length; ++n2) {
            treeSet.add(dArray[n2]);
        }
        n2 = treeSet.size();
        double[] dArray2 = new double[n2];
        Iterator iterator = treeSet.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            dArray2[n2 - ++n3] = (Double)iterator.next();
        }
        return dArray2;
    }
}

