/*
 * Decompiled with CFR 0.152.
 */
package ia.sh.org.apache.commons.math3.util;

import ia.sh.org.apache.commons.math3.exception.MathArithmeticException;
import ia.sh.org.apache.commons.math3.exception.MathIllegalArgumentException;
import ia.sh.org.apache.commons.math3.exception.util.LocalizedFormats;
import ia.sh.org.apache.commons.math3.util.FastMath;
import java.math.BigDecimal;

public class Precision {
    public static final double EPSILON;
    public static final double SAFE_MIN;
    private static final long EXPONENT_OFFSET = 1023L;
    private static final long SGN_MASK = Long.MIN_VALUE;
    private static final int SGN_MASK_FLOAT = Integer.MIN_VALUE;
    private static final double POSITIVE_ZERO = 0.0;
    private static final long POSITIVE_ZERO_DOUBLE_BITS;
    private static final long NEGATIVE_ZERO_DOUBLE_BITS;
    private static final int POSITIVE_ZERO_FLOAT_BITS;
    private static final int NEGATIVE_ZERO_FLOAT_BITS;

    private Precision() {
    }

    public static int compareTo(double d2, double d3, double d4) {
        if (Precision.equals(d2, d3, d4)) {
            return 0;
        }
        if (d2 < d3) {
            return -1;
        }
        return 1;
    }

    public static int compareTo(double d2, double d3, int n2) {
        if (Precision.equals(d2, d3, n2)) {
            return 0;
        }
        if (d2 < d3) {
            return -1;
        }
        return 1;
    }

    public static boolean equals(float f2, float f3) {
        return Precision.equals(f2, f3, 1);
    }

    public static boolean equalsIncludingNaN(float f2, float f3) {
        return f2 != f2 || f3 != f3 ? !(f2 != f2 ^ f3 != f3) : Precision.equals(f2, f3, 1);
    }

    public static boolean equals(float f2, float f3, float f4) {
        return Precision.equals(f2, f3, 1) || FastMath.abs(f3 - f2) <= f4;
    }

    public static boolean equalsIncludingNaN(float f2, float f3, float f4) {
        return Precision.equalsIncludingNaN(f2, f3) || FastMath.abs(f3 - f2) <= f4;
    }

    public static boolean equals(float f2, float f3, int n2) {
        boolean bl2;
        int n3;
        int n4 = Float.floatToRawIntBits(f2);
        if (((n4 ^ (n3 = Float.floatToRawIntBits(f3))) & Integer.MIN_VALUE) == 0) {
            bl2 = FastMath.abs(n4 - n3) <= n2;
        } else {
            int n5;
            int n6;
            if (n4 < n3) {
                n6 = n3 - POSITIVE_ZERO_FLOAT_BITS;
                n5 = n4 - NEGATIVE_ZERO_FLOAT_BITS;
            } else {
                n6 = n4 - POSITIVE_ZERO_FLOAT_BITS;
                n5 = n3 - NEGATIVE_ZERO_FLOAT_BITS;
            }
            bl2 = n6 > n2 ? false : n5 <= n2 - n6;
        }
        return bl2 && !Float.isNaN(f2) && !Float.isNaN(f3);
    }

    public static boolean equalsIncludingNaN(float f2, float f3, int n2) {
        return f2 != f2 || f3 != f3 ? !(f2 != f2 ^ f3 != f3) : Precision.equals(f2, f3, n2);
    }

    public static boolean equals(double d2, double d3) {
        return Precision.equals(d2, d3, 1);
    }

    public static boolean equalsIncludingNaN(double d2, double d3) {
        return d2 != d2 || d3 != d3 ? !(d2 != d2 ^ d3 != d3) : Precision.equals(d2, d3, 1);
    }

    public static boolean equals(double d2, double d3, double d4) {
        return Precision.equals(d2, d3, 1) || FastMath.abs(d3 - d2) <= d4;
    }

    public static boolean equalsWithRelativeTolerance(double d2, double d3, double d4) {
        if (Precision.equals(d2, d3, 1)) {
            return true;
        }
        double d5 = FastMath.max(FastMath.abs(d2), FastMath.abs(d3));
        double d6 = FastMath.abs((d2 - d3) / d5);
        return d6 <= d4;
    }

    public static boolean equalsIncludingNaN(double d2, double d3, double d4) {
        return Precision.equalsIncludingNaN(d2, d3) || FastMath.abs(d3 - d2) <= d4;
    }

    public static boolean equals(double d2, double d3, int n2) {
        boolean bl2;
        long l2;
        long l3 = Double.doubleToRawLongBits(d2);
        if (((l3 ^ (l2 = Double.doubleToRawLongBits(d3))) & Long.MIN_VALUE) == 0L) {
            bl2 = FastMath.abs(l3 - l2) <= (long)n2;
        } else {
            long l4;
            long l5;
            if (l3 < l2) {
                l5 = l2 - POSITIVE_ZERO_DOUBLE_BITS;
                l4 = l3 - NEGATIVE_ZERO_DOUBLE_BITS;
            } else {
                l5 = l3 - POSITIVE_ZERO_DOUBLE_BITS;
                l4 = l2 - NEGATIVE_ZERO_DOUBLE_BITS;
            }
            bl2 = l5 > (long)n2 ? false : l4 <= (long)n2 - l5;
        }
        return bl2 && !Double.isNaN(d2) && !Double.isNaN(d3);
    }

    public static boolean equalsIncludingNaN(double d2, double d3, int n2) {
        return d2 != d2 || d3 != d3 ? !(d2 != d2 ^ d3 != d3) : Precision.equals(d2, d3, n2);
    }

    public static double round(double d2, int n2) {
        return Precision.round(d2, n2, 4);
    }

    public static double round(double d2, int n2, int n3) {
        try {
            double d3 = new BigDecimal(Double.toString(d2)).setScale(n2, n3).doubleValue();
            return d3 == 0.0 ? 0.0 * d2 : d3;
        }
        catch (NumberFormatException numberFormatException) {
            if (Double.isInfinite(d2)) {
                return d2;
            }
            return Double.NaN;
        }
    }

    public static float round(float f2, int n2) {
        return Precision.round(f2, n2, 4);
    }

    public static float round(float f2, int n2, int n3) {
        float f3 = FastMath.copySign(1.0f, f2);
        float f4 = (float)FastMath.pow(10.0, n2) * f3;
        return (float)Precision.roundUnscaled(f2 * f4, f3, n3) / f4;
    }

    private static double roundUnscaled(double d2, double d3, int n2) {
        switch (n2) {
            case 2: {
                if (d3 == -1.0) {
                    d2 = FastMath.floor(FastMath.nextAfter(d2, Double.NEGATIVE_INFINITY));
                    break;
                }
                d2 = FastMath.ceil(FastMath.nextAfter(d2, Double.POSITIVE_INFINITY));
                break;
            }
            case 1: {
                d2 = FastMath.floor(FastMath.nextAfter(d2, Double.NEGATIVE_INFINITY));
                break;
            }
            case 3: {
                if (d3 == -1.0) {
                    d2 = FastMath.ceil(FastMath.nextAfter(d2, Double.POSITIVE_INFINITY));
                    break;
                }
                d2 = FastMath.floor(FastMath.nextAfter(d2, Double.NEGATIVE_INFINITY));
                break;
            }
            case 5: {
                d2 = FastMath.nextAfter(d2, Double.NEGATIVE_INFINITY);
                double d4 = d2 - FastMath.floor(d2);
                if (d4 > 0.5) {
                    d2 = FastMath.ceil(d2);
                    break;
                }
                d2 = FastMath.floor(d2);
                break;
            }
            case 6: {
                double d5 = d2 - FastMath.floor(d2);
                if (d5 > 0.5) {
                    d2 = FastMath.ceil(d2);
                    break;
                }
                if (d5 < 0.5) {
                    d2 = FastMath.floor(d2);
                    break;
                }
                if (FastMath.floor(d2) / 2.0 == FastMath.floor(FastMath.floor(d2) / 2.0)) {
                    d2 = FastMath.floor(d2);
                    break;
                }
                d2 = FastMath.ceil(d2);
                break;
            }
            case 4: {
                d2 = FastMath.nextAfter(d2, Double.POSITIVE_INFINITY);
                double d6 = d2 - FastMath.floor(d2);
                if (d6 >= 0.5) {
                    d2 = FastMath.ceil(d2);
                    break;
                }
                d2 = FastMath.floor(d2);
                break;
            }
            case 7: {
                if (d2 == FastMath.floor(d2)) break;
                throw new MathArithmeticException();
            }
            case 0: {
                if (d2 == FastMath.floor(d2)) break;
                d2 = FastMath.ceil(FastMath.nextAfter(d2, Double.POSITIVE_INFINITY));
                break;
            }
            default: {
                throw new MathIllegalArgumentException(LocalizedFormats.INVALID_ROUNDING_METHOD, n2, "ROUND_CEILING", 2, "ROUND_DOWN", 1, "ROUND_FLOOR", 3, "ROUND_HALF_DOWN", 5, "ROUND_HALF_EVEN", 6, "ROUND_HALF_UP", 4, "ROUND_UNNECESSARY", 7, "ROUND_UP", 0);
            }
        }
        return d2;
    }

    public static double representableDelta(double d2, double d3) {
        return d2 + d3 - d2;
    }

    static {
        POSITIVE_ZERO_DOUBLE_BITS = Double.doubleToRawLongBits(0.0);
        NEGATIVE_ZERO_DOUBLE_BITS = Double.doubleToRawLongBits(-0.0);
        POSITIVE_ZERO_FLOAT_BITS = Float.floatToRawIntBits(0.0f);
        NEGATIVE_ZERO_FLOAT_BITS = Float.floatToRawIntBits(-0.0f);
        EPSILON = Double.longBitsToDouble(4368491638549381120L);
        SAFE_MIN = Double.longBitsToDouble(0x10000000000000L);
    }
}

