/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.ViaAPI;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import me.casperge.interfaces.CustomBiome;
import me.casperge.interfaces.NmsCode;
import me.casperge.realisticseasons.Version;
import me.casperge.realisticseasons.api.DMap;
import me.casperge.realisticseasons.api.MMobs;
import me.casperge.realisticseasons.api.PAPI;
import me.casperge.realisticseasons.api.SeasonBiome;
import me.casperge.realisticseasons.api.SeasonsAPI;
import me.casperge.realisticseasons.api.WGuard;
import me.casperge.realisticseasons.biome.BiomeRegister;
import me.casperge.realisticseasons.blockscanner.ChunkSupplier;
import me.casperge.realisticseasons.blockscanner.blocksaver.BlockStorage;
import me.casperge.realisticseasons.calendar.TimeManager;
import me.casperge.realisticseasons.commands.BiomeCommand;
import me.casperge.realisticseasons.commands.RealisticSeasonsCommand;
import me.casperge.realisticseasons.commands.RealisticSeasonsTabCompl;
import me.casperge.realisticseasons.commands.SeasonCommand;
import me.casperge.realisticseasons.commands.ToggleFahrenheitCommand;
import me.casperge.realisticseasons.commands.ToggleParticleCommand;
import me.casperge.realisticseasons.commands.ToggleSeasonsCommand;
import me.casperge.realisticseasons.commands.ToggleTemperatureCommand;
import me.casperge.realisticseasons.data.BiomeFileLoader;
import me.casperge.realisticseasons.data.DataHandler;
import me.casperge.realisticseasons.data.LanguageManager;
import me.casperge.realisticseasons.data.Settings;
import me.casperge.realisticseasons.data.chunksaver.ChunkDataHandler;
import me.casperge.realisticseasons.event.BlockEvents;
import me.casperge.realisticseasons.event.ChunkLoadManager;
import me.casperge.realisticseasons.event.EntityEvents;
import me.casperge.realisticseasons.event.WorldEvents;
import me.casperge.realisticseasons.metrics.bukkit.Metrics;
import me.casperge.realisticseasons.metrics.charts.SimplePie;
import me.casperge.realisticseasons.particle.ParticleManager;
import me.casperge.realisticseasons.season.Season;
import me.casperge.realisticseasons.season.SeasonCycle;
import me.casperge.realisticseasons.season.SeasonManager;
import me.casperge.realisticseasons.season.SubSeason;
import me.casperge.realisticseasons.seasonevent.EventManager;
import me.casperge.realisticseasons.temperature.TemperatureManager;
import me.casperge.realisticseasons.utils.AnimalUtils;
import me.casperge.realisticseasons.utils.BiomeMappings;
import me.casperge.realisticseasons.utils.BlockUtils;
import me.casperge.realisticseasons.utils.ChunkUtils;
import me.casperge.realisticseasons.utils.JavaUtils;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitWorker;

public class RealisticSeasons
extends JavaPlugin {
    private ChunkUtils chunkutils;
    private BlockUtils blockutils;
    private SeasonManager seasonManager;
    private DataHandler datareader;
    private PAPI papi;
    private DMap dynmap;
    private NmsCode nmsCode;
    private Settings settings;
    private AnimalUtils animalutils;
    private RealisticSeasonsCommand command;
    private RealisticSeasonsTabCompl tabcompleter;
    private boolean isPaper = false;
    private boolean hasWorldGuard = false;
    private WGuard wguard;
    private LanguageManager lman;
    private BiomeRegister breg;
    public boolean hasTerra = false;
    private SeasonCycle seasonCycle;
    private TimeManager timemanager;
    private static RealisticSeasons main;
    private TemperatureManager tempman;
    private EventManager eventman;
    private ParticleManager pman;
    private boolean dynmapOnScheduled = false;
    public boolean hasTimePauser = false;
    public static AtomicBoolean isEnabled;
    public boolean isFreshInstall;
    private HashMap<String, SeasonBiome> seasonBiomesAPI = new HashMap();
    private ViaAPI api;
    private BlockStorage blockStorage;
    private List<BukkitRunnable> activeRunnables = new ArrayList<BukkitRunnable>();
    private Metrics metrics;
    private boolean hasViaVersion = false;
    private ZonedDateTime loadedTime;
    private ChunkDataHandler asyncChunkHandler;
    public File configFile;
    private FileConfiguration config;
    public boolean debugMode = false;
    private List<CustomBiome> customBiomes = new ArrayList<CustomBiome>();
    public static String fsdfdv;

    public void onLoad() {
        this.loadWG();
    }

    public void onEnable() {
        RealisticSeasons.loadConfig0();
        Version.version = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
        try {
            Class.forName("com.viaversion.viaversion.api.Via");
            this.hasViaVersion = true;
            this.api = Via.getAPI();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        int n = 15602;
        boolean bl = false;
        this.metrics = new Metrics(this, n);
        main = this;
        new SeasonsAPI(this);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                RealisticSeasons.this.enable();
            }
        });
    }

    public boolean loadConfig() {
        boolean bl = true;
        this.configFile = new File(main.getDataFolder(), "config.yml");
        if (!this.configFile.exists()) {
            bl = false;
            try {
                InputStream inputStream = this.getResource("config.yml");
                FileUtils.copyInputStreamToFile(inputStream, this.configFile);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        JavaUtils.saveDefaultConfigValues("/config.yml", "config.yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        return bl;
    }

    public FileConfiguration getRSConfig() {
        return this.config;
    }

    public void enable() {
        try {
            Class.forName("com.destroystokyo.paper.ParticleBuilder");
            this.isPaper = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        boolean bl = this.loadConfig();
        this.settings = new Settings(this, bl);
        this.blockStorage = new BlockStorage(this);
        if (this.getPlugin().getDescription().getVersion().matches(".*[a-zA-Z]+.*")) {
            return;
        }
        this.lman = new LanguageManager(this);
        this.nmsCode = Version.setupBiomeRegister();
        if (this.nmsCode == null) {
            this.getLogger().severe("Failed to load RealisticSeasons!");
            this.getLogger().severe("Your server version is not compatible with this plugin!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
        this.tempman = new TemperatureManager(this);
        this.breg = new BiomeRegister();
        new BiomeFileLoader(this);
        this.seasonManager = new SeasonManager(this);
        if (this.getServer().getPluginManager().isPluginEnabled("dynmap")) {
            this.dynmap = new DMap(this);
        }
        if (this.getServer().getPluginManager().isPluginEnabled("Terra")) {
            this.hasTerra = true;
        }
        this.chunkutils = new ChunkUtils(this);
        this.blockutils = new BlockUtils(this);
        this.animalutils = new AnimalUtils(this);
        this.timemanager = new TimeManager(this);
        this.seasonCycle = new SeasonCycle(this);
        this.datareader = new DataHandler(this);
        this.eventman = new EventManager(this);
        this.getCommand("season").setExecutor((CommandExecutor)new SeasonCommand(this));
        this.command = new RealisticSeasonsCommand(this);
        this.getCommand("realisticseasons").setExecutor((CommandExecutor)this.command);
        this.getCommand("toggleseasoncolors").setExecutor((CommandExecutor)new ToggleSeasonsCommand(this));
        this.getCommand("toggletemperature").setExecutor((CommandExecutor)new ToggleTemperatureCommand(this));
        this.getCommand("toggleseasonparticles").setExecutor((CommandExecutor)new ToggleParticleCommand(this));
        this.getCommand("togglefahrenheit").setExecutor((CommandExecutor)new ToggleFahrenheitCommand(this));
        this.getCommand("rs").setExecutor((CommandExecutor)this.command);
        this.getCommand("currentbiome").setExecutor((CommandExecutor)new BiomeCommand(this));
        this.tabcompleter = new RealisticSeasonsTabCompl(this);
        this.getCommand("realisticseasons").setTabCompleter((TabCompleter)this.tabcompleter);
        this.getCommand("rs").setTabCompleter((TabCompleter)this.tabcompleter);
        Version.setupChunkPacketEvent(this);
        new ChunkLoadManager(this);
        this.seasonManager.setup();
        new BlockEvents(this);
        new EntityEvents(this);
        new WorldEvents(this);
        this.seasonCycle.runTaskTimer((Plugin)this, 200L, 200L);
        this.loadPAPI();
        this.tempman.load();
        ChunkSupplier chunkSupplier = new ChunkSupplier(this);
        if (Bukkit.getPluginManager().getPlugin("MythicMobs") != null) {
            new MMobs(this);
        }
        chunkSupplier.runTaskTimer((Plugin)this, 100L, 20L);
        this.pman = new ParticleManager(this);
        this.asyncChunkHandler = new ChunkDataHandler(main);
        Bukkit.getLogger().info("[RealisticSeasons] Total biomes registered on server: " + String.valueOf(this.nmsCode.getAllBiomes().size()));
        Bukkit.getScheduler().runTaskLater((Plugin)main, new Runnable(){

            @Override
            public void run() {
                List<String> list = RealisticSeasons.this.getActiveAsyncTasks();
                if (list.size() > 200) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    for (String string : list) {
                        boolean bl = false;
                        for (String string2 : hashMap.keySet()) {
                            if (!string.equals(string2)) continue;
                            hashMap.put(string2, (Integer)hashMap.get(string2) + 1);
                            bl = true;
                        }
                        if (bl) continue;
                        hashMap.put(string, 1);
                    }
                    Bukkit.getLogger().severe("[RealisticSeasons] WARNING: over " + String.valueOf(list.size()) + " async tasks created by RealisticSeasons are active. Please report this message and the contents below to the developer.");
                    Bukkit.getLogger().severe("[RealisticSeasons] Active tasks: ");
                    for (String string : hashMap.keySet()) {
                        Bukkit.getLogger().severe("[RealisticSeasons] " + string + ": " + String.valueOf(hashMap.get(string)) + " instances");
                    }
                }
            }
        }, 600L);
        Callable<String> callable = new Callable<String>(){

            @Override
            public String call() {
                Boolean bl = main.getTemperatureManager().getTempData().isEnabled();
                return bl.toString();
            }
        };
        this.metrics.addCustomChart(new SimplePie("temperature_system_enabled", callable));
        Callable<String> callable2 = new Callable<String>(){

            @Override
            public String call() {
                if (!main.getSettings().calendarEnabled) {
                    return "false";
                }
                Boolean bl = ((RealisticSeasons)RealisticSeasons.this).settings.syncWorldTimeWithRealWorld;
                return bl.toString();
            }
        };
        this.metrics.addCustomChart(new SimplePie("time_synchronized_with_real_time", callable2));
        Callable<String> callable3 = new Callable<String>(){

            @Override
            public String call() {
                Boolean bl = RealisticSeasons.this.getNMSUtils().getCustomBiomes(((RealisticSeasons)RealisticSeasons.this).settings.biomeDisplayName).size() > 0;
                return bl.toString();
            }
        };
        this.metrics.addCustomChart(new SimplePie("custom_world_generator", callable3));
        this.seasonManager.checkWorlds();
    }

    public void onDisable() {
        isEnabled.set(false);
        if (this.dynmapOnScheduled) {
            this.dynmap.setFullRenderPause(false);
        }
        this.datareader.save();
    }

    public boolean supportsCustomBiomes(Player player) {
        if (!this.hasViaVersion) {
            return true;
        }
        return this.api.getPlayerVersion((Object)player) >= 751;
    }

    public void reload() {
        this.settings.reload();
        for (World world : this.seasonManager.worldData.keySet()) {
            if (this.seasonManager.getSeason(world).equals((Object)Season.DISABLED)) continue;
            this.seasonManager.clearChunkCheckedList(world, this.seasonManager.getSeason(world));
            this.seasonManager.clearChunkQueue(world, this.seasonManager.getSeason(world));
        }
        this.lman.reload();
        this.tempman.getTempData().load();
        this.timemanager.load();
        this.eventman.load();
    }

    public static RealisticSeasons getInstance() {
        return main;
    }

    public ParticleManager getParticleManager() {
        return this.pman;
    }

    public void addRunnable(BukkitRunnable bukkitRunnable) {
        this.activeRunnables.add(bukkitRunnable);
    }

    public ChunkUtils getChunkUtils() {
        return this.chunkutils;
    }

    public BlockUtils getBlockUtils() {
        return this.blockutils;
    }

    public SeasonManager getSeasonManager() {
        return this.seasonManager;
    }

    public SeasonCycle getSeasonCycle() {
        return this.seasonCycle;
    }

    public DataHandler getDataReader() {
        return this.datareader;
    }

    public TemperatureManager getTemperatureManager() {
        return this.tempman;
    }

    public LanguageManager getLangManager() {
        return this.lman;
    }

    public NmsCode getNMSUtils() {
        return this.nmsCode;
    }

    public EventManager getEventManager() {
        return this.eventman;
    }

    public TimeManager getTimeManager() {
        return this.timemanager;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public BiomeRegister getBiomeRegister() {
        return this.breg;
    }

    public AnimalUtils getAnimalUtils() {
        return this.animalutils;
    }

    public BlockStorage getBlockStorage() {
        return this.blockStorage;
    }

    public JavaPlugin getPlugin() {
        return this;
    }

    public boolean isPaper() {
        return this.isPaper;
    }

    public void loadPAPI() {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.papi = new PAPI(this);
            this.papi.register();
        }
    }

    public String setPlaceHolders(String string, Player player) {
        if (this.papi != null) {
            return this.papi.setPlaceHolders(player, string);
        }
        return string;
    }

    public void updateDynmap(Season season, SubSeason subSeason, World world) {
        if (this.dynmap == null) {
            return;
        }
        if (!RealisticSeasons.main.getSettings().pauseDynmapInWinter) {
            return;
        }
        if (season == Season.WINTER) {
            if (!this.dynmap.isFullRenderPause()) {
                this.dynmap.setFullRenderPause(true);
            }
        } else if (season == Season.SPRING) {
            if (subSeason.getPhase() >= 2) {
                if (this.dynmap.isFullRenderPause()) {
                    this.dynmap.setFullRenderPause(false);
                }
            } else if (!this.dynmap.isFullRenderPause()) {
                this.dynmap.setFullRenderPause(true);
            }
        } else if (this.dynmap.isFullRenderPause()) {
            this.dynmap.setFullRenderPause(false);
        }
    }

    public void loadWG() {
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null) {
            if (Bukkit.getPluginManager().getPlugin("WorldEdit") != null) {
                this.wguard = new WGuard(this);
                this.hasWorldGuard = true;
            } else {
                Bukkit.getLogger().info("You'll need WorldEdit installed on your server to use WorldGuard with RealisticSeasons!");
            }
        }
    }

    public boolean hasWorldGuard() {
        return this.hasWorldGuard;
    }

    public WGuard getWorldGuardAPI() {
        return this.wguard;
    }

    public boolean hasSeasons(int n, int n2, World world) {
        if (!this.hasWorldGuard) {
            return true;
        }
        return this.wguard.hasSeasonEffects(n, n2, world);
    }

    public boolean hasBlockChanges(int n, int n2, World world) {
        if (!this.settings.modifyBlocks) {
            return false;
        }
        if (!this.hasWorldGuard) {
            return true;
        }
        return this.wguard.hasBlockChanges(n, n2, world);
    }

    public boolean hasMobSpawns(int n, int n2, World world) {
        if (!this.hasWorldGuard) {
            return true;
        }
        return this.wguard.hasMobSpawns(n, n2, world);
    }

    public int createSeasonsBiome(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl) {
        if (this.settings.optimizedBiomes) {
            string2 = String.valueOf(this.customBiomes.size());
        }
        CustomBiome customBiome = RealisticSeasons.createCustomBiome(string2.toLowerCase(), this.settings.biomeDisplayName, string);
        if (!string3.equals("")) {
            customBiome.setSkyColor(string3);
        }
        if (!string4.equals("")) {
            customBiome.setWaterColor(string4);
        }
        if (!string5.equals("")) {
            customBiome.setWaterFogColor(string5);
        }
        if (!string6.equals("")) {
            customBiome.setGrassColor(string6);
        } else {
            String string9 = BiomeMappings.getGrassHex(string);
            if (!string9.equals("CUSTOM")) {
                customBiome.setGrassColor(BiomeMappings.getGrassHex(string));
            } else {
                customBiome.setGrassColor(string9);
            }
        }
        if (!string7.equals("")) {
            customBiome.setFoliageColor(string7);
        }
        if (!string8.equals("")) {
            customBiome.setFogColor(string8);
        }
        if (bl) {
            customBiome.setFrozen(true);
            customBiome.setTemperature(Float.valueOf(0.0f));
        }
        if (this.settings.optimizedBiomes) {
            for (CustomBiome customBiome2 : this.customBiomes) {
                if (!customBiome2.getGrassColor().equalsIgnoreCase(customBiome.getGrassColor()) || !customBiome2.getSkyColor().equalsIgnoreCase(customBiome.getSkyColor()) || !customBiome2.getWaterColor().equalsIgnoreCase(customBiome.getWaterColor()) || !customBiome2.getWaterFogColor().equalsIgnoreCase(customBiome.getWaterFogColor()) || !customBiome2.getFoliageColor().equalsIgnoreCase(customBiome.getFoliageColor()) || !customBiome2.getFogColor().equalsIgnoreCase(customBiome.getFogColor()) || customBiome2.isFrozen() != customBiome.isFrozen() || customBiome2.getGrassType() != customBiome.getGrassType()) continue;
                return customBiome2.getBiomeID();
            }
        }
        customBiome.register();
        this.customBiomes.add(customBiome);
        return customBiome.getBiomeID();
    }

    public HashMap<String, SeasonBiome> getSeasonBiomesForAPI() {
        return this.seasonBiomesAPI;
    }

    public void addSeasonBiomeForAPI(String string, SeasonBiome seasonBiome) {
        this.seasonBiomesAPI.put(string, seasonBiome);
    }

    public ZonedDateTime getLoadedTime() {
        return this.loadedTime;
    }

    public void setLoadedTime(ZonedDateTime zonedDateTime) {
        this.loadedTime = zonedDateTime;
    }

    public ChunkDataHandler getAsyncChunkHandler() {
        return this.asyncChunkHandler;
    }

    public static CustomBiome createCustomBiome(String string, String string2, String string3) {
        return Version.createCustomBiome(string, string2, string3);
    }

    public List<String> getActiveAsyncTasks() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (BukkitWorker bukkitWorker : Bukkit.getScheduler().getActiveWorkers()) {
            if (!bukkitWorker.getOwner().equals((Object)this)) continue;
            arrayList.add(bukkitWorker.getThread().getName());
        }
        return arrayList;
    }

    static {
        isEnabled = new AtomicBoolean(true);
        fsdfdv = "%%__USER__%%";
    }

    private static /* bridge */ /* synthetic */ void loadConfig0() {
        try {
            URLConnection con = new URL("https://api.spigotmc.org/legacy/premium.php?user_id=%%__USER__%%&resource_id=%%__RESOURCE__%%&nonce=9379992").openConnection();
            con.setConnectTimeout(1000);
            con.setReadTimeout(1000);
            ((HttpURLConnection)con).setInstanceFollowRedirects(true);
            String response = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            if ("false".equals(response)) {
                throw new RuntimeException("Access to this plugin has been disabled! Please contact the author!");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

