/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.api.CustomWorldGenerator;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;

public class CustomBiomeFileLoader {
    public static void writeFiles(CustomWorldGenerator customWorldGenerator) {
        String string = customWorldGenerator.toString();
        String string2 = customWorldGenerator.getResourceFolderName();
        String[] stringArray = CustomBiomeFileLoader.getResources(RealisticSeasons.class, string2);
        if (stringArray == null || stringArray.length == 0) {
            Bukkit.getLogger().severe("Could not load " + string + " files of RealisticSeasons");
            return;
        }
        for (String string3 : stringArray) {
            File file = new File(RealisticSeasons.getInstance().getDataFolder() + "/biomes", string3);
            if (file.exists()) continue;
            try {
                InputStream inputStream = RealisticSeasons.getInstance().getResource(string2 + "/" + string3);
                FileUtils.copyInputStreamToFile(inputStream, file);
            }
            catch (Exception exception) {
                Bukkit.getLogger().severe("[RealisticSeasons] Could not install biome file");
                Bukkit.getLogger().severe("[RealisticSeasons] File: " + string2 + File.separator + string3);
                exception.printStackTrace();
            }
        }
    }

    private static String[] getResources(Class clazz, String string) {
        RealisticSeasons realisticSeasons = RealisticSeasons.getInstance();
        URL uRL = clazz.getClassLoader().getResource(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = uRL.getPath().substring(5, uRL.getPath().indexOf("!"));
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(URLDecoder.decode(string2, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            realisticSeasons.getServer().getConsoleSender().sendMessage("ERROR - getResources() - couldn't decode the Jar file to index resources.");
        }
        catch (IOException iOException) {
            realisticSeasons.getServer().getConsoleSender().sendMessage("ERROR - getResources() - couldn't perform IO operations on jar file");
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            String string3 = enumeration.nextElement().getName();
            if (!string3.startsWith(string)) continue;
            String string4 = string3.substring(string.length() + 1);
            String string5 = string3.substring(string3.length() - 1);
            if (string5 == File.separator || !string4.matches(".*[a-zA-Z0-9].*")) continue;
            arrayList.add(string4);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static List<CustomWorldGenerator> getAlreadyInstalledGenerators() {
        ArrayList<CustomWorldGenerator> arrayList = new ArrayList<CustomWorldGenerator>();
        File file = new File("plugins/RealisticSeasons/biomes/");
        for (File file2 : file.listFiles()) {
            CustomWorldGenerator customWorldGenerator;
            String string;
            if (!file2.getName().contains("_") || !CustomWorldGenerator.isWorldGenerator(string = file2.getName().split("_")[0]) || arrayList.contains((Object)(customWorldGenerator = CustomWorldGenerator.fromFile(string)))) continue;
            arrayList.add(customWorldGenerator);
        }
        return arrayList;
    }

    public static List<CustomWorldGenerator> getActiveGenerators() {
        ArrayList<CustomWorldGenerator> arrayList = new ArrayList<CustomWorldGenerator>();
        for (String string : RealisticSeasons.getInstance().getNMSUtils().getCustomBiomes(RealisticSeasons.getInstance().getSettings().biomeDisplayName)) {
            CustomWorldGenerator customWorldGenerator;
            if (!CustomWorldGenerator.isKnownBiome(string) || arrayList.contains((Object)(customWorldGenerator = CustomWorldGenerator.fromBiome(string)))) continue;
            arrayList.add(customWorldGenerator);
        }
        return arrayList;
    }
}

