/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.api;

import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.season.Season;
import me.casperge.realisticseasons.temperature.TemperatureManager;
import me.casperge.realisticseasons.utils.JavaUtils;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class PAPI
extends PlaceholderExpansion {
    private RealisticSeasons main;
    private StringBuilder text;
    private String bottleEmoij = new String(Character.toChars(129514));

    public PAPI(RealisticSeasons realisticSeasons) {
        this.main = realisticSeasons;
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String getAuthor() {
        return "CasperSwagerman";
    }

    public String getIdentifier() {
        return "rs";
    }

    public String getVersion() {
        return "1.0.0";
    }

    public String onRequest(OfflinePlayer offlinePlayer, String string) {
        for (Object object : this.main.getSeasonManager().worldData.keySet()) {
            if (string.equals("season_" + object.getName())) {
                Season season = this.main.getSeasonManager().getSeason((World)object);
                if (season == Season.DISABLED) {
                    return "DISABLED";
                }
                return season.toString();
            }
            if (string.equals("next_season_" + object.getName())) {
                Season season = this.main.getSeasonManager().getNextSeason((World)object);
                if (season == Season.DISABLED) {
                    return "DISABLED";
                }
                return season.toString();
            }
            if (string.equals("days_until_next_season_" + object.getName())) {
                if (!this.main.getSettings().doSeasonCycle) {
                    return "DISABLED";
                }
                return String.valueOf(this.main.getTimeManager().getDaysUntilNextSeason((World)object));
            }
            if (string.equals("day_" + object.getName())) {
                return String.valueOf(this.main.getTimeManager().getDate((World)object).getDay());
            }
            if (string.equals("year_" + object.getName())) {
                return String.valueOf(this.main.getTimeManager().getDate((World)object).getYear());
            }
            if (string.equals("month_" + object.getName())) {
                return String.valueOf(this.main.getTimeManager().getDate((World)object).getMonth());
            }
            if (string.equals("month_asname_" + object.getName())) {
                return this.main.getTimeManager().getCalendar().getMonth(this.main.getTimeManager().getDate((World)object).getMonth()).getName();
            }
            if (string.equals("weekday_" + object.getName())) {
                return this.main.getTimeManager().getWeekDay(this.main.getTimeManager().getDate((World)object));
            }
            if (string.equals("seasonlength_" + object.getName())) {
                return String.valueOf(this.main.getTimeManager().getTotalDays(this.main.getSeasonManager().getSeason((World)object)));
            }
            if (string.equals("time_" + object.getName())) {
                return this.main.getTimeManager().getTimeAsString((World)object);
            }
            if (!string.equals("active_events_" + object.getName())) continue;
            return this.main.getEventManager().getActiveEventsAsString((World)object);
        }
        if (offlinePlayer != null) {
            if (offlinePlayer.isOnline()) {
                Object object;
                Player player = offlinePlayer.getPlayer();
                if (string.equals("season")) {
                    object = this.main.getSeasonManager().getSeason(player.getWorld());
                    if (object == Season.DISABLED) {
                        return "DISABLED";
                    }
                    return object.toString();
                }
                if (string.equals("next_season")) {
                    object = this.main.getSeasonManager().getNextSeason(player.getWorld());
                    if (object == Season.DISABLED) {
                        return "DISABLED";
                    }
                    return object.toString();
                }
                if (string.equals("days_until_next_season")) {
                    if (!this.main.getSettings().doSeasonCycle) {
                        return "DISABLED";
                    }
                    object = this.main.getSeasonManager().getSeason(player.getWorld());
                    if (object == Season.DISABLED || object == Season.RESTORE) {
                        return "DISABLED";
                    }
                    return String.valueOf(this.main.getTimeManager().getDaysUntilNextSeason(player.getWorld()));
                }
                if (string.equals("seasonlength")) {
                    return String.valueOf(this.main.getTimeManager().getTotalDays(this.main.getSeasonManager().getSeason(player.getWorld())));
                }
                if (string.equals("day")) {
                    return String.valueOf(this.main.getTimeManager().getDate(player.getWorld()).getDay());
                }
                if (string.equals("year")) {
                    return String.valueOf(this.main.getTimeManager().getDate(player.getWorld()).getYear());
                }
                if (string.equals("month")) {
                    return String.valueOf(this.main.getTimeManager().getDate(player.getWorld()).getMonth());
                }
                if (string.equals("month_asname")) {
                    return this.main.getTimeManager().getCalendar().getMonth(this.main.getTimeManager().getDate(player.getWorld()).getMonth()).getName();
                }
                if (string.equals("weekday")) {
                    return this.main.getTimeManager().getWeekDay(this.main.getTimeManager().getDate(player.getWorld()));
                }
                if (string.equals("time")) {
                    return this.main.getTimeManager().getTimeAsString(player.getWorld());
                }
                if (string.equals("active_events")) {
                    return this.main.getEventManager().getActiveEventsAsString(player.getWorld());
                }
                if (string.equals("temperature")) {
                    int n = this.main.getTemperatureManager().getTemperature(player);
                    if (player.getFireTicks() > 0 && !this.main.getTemperatureManager().hasRSBurn(player.getUniqueId())) {
                        n += 100;
                    }
                    if (this.main.getTemperatureManager().getTempData().getTempSettings().isConvertToFahrenheit() && !this.main.getTemperatureManager().hasFahrenheitEnabled(player) || !this.main.getTemperatureManager().getTempData().getTempSettings().isConvertToFahrenheit() && this.main.getTemperatureManager().hasFahrenheitEnabled(player)) {
                        return String.valueOf(JavaUtils.convertToFahrenheit(n)) + this.main.getTemperatureManager().getTempData().getTempSettings().getFahrenheitMessage();
                    }
                    return String.valueOf(n) + this.main.getTemperatureManager().getTempData().getTempSettings().getCelciusMessage();
                }
                if (string.equals("temperaturecolor")) {
                    boolean bl = false;
                    if (player.getFireTicks() > 0 && !this.main.getTemperatureManager().hasRSBurn(player.getUniqueId())) {
                        bl = true;
                    }
                    this.text = new StringBuilder();
                    TemperatureManager temperatureManager = this.main.getTemperatureManager();
                    int n = temperatureManager.getTemperature(player);
                    int n2 = 97;
                    if (temperatureManager.getTempData().getTempSettings().getColdHungerTemp() > n) {
                        n2 = 98;
                    }
                    if (temperatureManager.getTempData().getTempSettings().getColdSlownessTemp() > n) {
                        n2 = 57;
                    }
                    if (temperatureManager.getTempData().getTempSettings().getColdFreezingTemp() > n) {
                        n2 = 49;
                    }
                    if (temperatureManager.getTempData().getTempSettings().getWarmNoHealingTemp() < n) {
                        n2 = 54;
                    }
                    if (temperatureManager.getTempData().getTempSettings().getWarmSlownessTemp() < n) {
                        n2 = 99;
                    }
                    if (temperatureManager.getTempData().getTempSettings().getWarmFireTemp() < n || bl) {
                        n2 = 52;
                    }
                    if (temperatureManager.getTempData().getTempSettings().getBoostMinTemp() <= n && temperatureManager.getTempData().getTempSettings().getBoostMaxTemp() >= n && temperatureManager.getTempData().getTempSettings().getBoostPotionEffects().size() > 0) {
                        n2 = 100;
                    }
                    this.text.append('\u00a7');
                    this.text.append((char)n2);
                    return this.text.toString();
                }
                if (string.equals("air_temperature")) {
                    if (this.main.getTemperatureManager().getTempData().getTempSettings().isConvertToFahrenheit()) {
                        return String.valueOf(JavaUtils.convertToFahrenheit(this.main.getTemperatureManager().getAirTemperature(player.getLocation())));
                    }
                    return String.valueOf(this.main.getTemperatureManager().getAirTemperature(player.getLocation()));
                }
                if (string.equals("air_temperaturecolor")) {
                    this.text = new StringBuilder();
                    object = this.main.getTemperatureManager();
                    int n = object.getAirTemperature(player.getLocation());
                    char c2 = 'a';
                    if (object.getTempData().getTempSettings().getColdHungerTemp() >= n) {
                        c2 = 'b';
                    }
                    if (object.getTempData().getTempSettings().getColdSlownessTemp() >= n) {
                        c2 = '9';
                    }
                    if (object.getTempData().getTempSettings().getColdFreezingTemp() >= n) {
                        c2 = '1';
                    }
                    if (object.getTempData().getTempSettings().getWarmNoHealingTemp() <= n) {
                        c2 = '6';
                    }
                    if (object.getTempData().getTempSettings().getWarmSlownessTemp() <= n) {
                        c2 = 'c';
                    }
                    if (object.getTempData().getTempSettings().getWarmFireTemp() <= n) {
                        c2 = '4';
                    }
                    if (object.getTempData().getTempSettings().getBoostMinTemp() <= n && object.getTempData().getTempSettings().getBoostMaxTemp() >= n) {
                        c2 = 'd';
                    }
                    this.text.append('\u00a7');
                    this.text.append(c2);
                    return this.text.toString();
                }
                if (string.equals("bottle_icon")) {
                    if (this.main.getTemperatureManager().getTempUtils().hasDrinked(player)) {
                        return this.bottleEmoij;
                    }
                    return "";
                }
                if (string.equals("temperature_int")) {
                    int n = this.main.getTemperatureManager().getTemperature(player);
                    if (player.getFireTicks() > 0 && !this.main.getTemperatureManager().hasRSBurn(player.getUniqueId())) {
                        n += 100;
                    }
                    if (this.main.getTemperatureManager().getTempData().getTempSettings().isConvertToFahrenheit() && !this.main.getTemperatureManager().hasFahrenheitEnabled(player) || !this.main.getTemperatureManager().getTempData().getTempSettings().isConvertToFahrenheit() && this.main.getTemperatureManager().hasFahrenheitEnabled(player)) {
                        return String.valueOf(JavaUtils.convertToFahrenheit(n));
                    }
                    return String.valueOf(n);
                }
                return null;
            }
            return "Player is offline!";
        }
        return string;
    }

    public String setPlaceHolders(Player player, String string) {
        return PlaceholderAPI.setPlaceholders((Player)player, (String)string);
    }
}

