/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.biome;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import me.casperge.realisticseasons.biome.BiomeRegister;

public class BiomeUtils {
    public static List<int[]> treeFallpackets = new ArrayList<int[]>();
    public static Random r = new Random();

    public static int getSeasonsTemperature(float f) {
        if ((double)f <= 0.1) {
            return -12;
        }
        if ((double)f > 0.1 && (double)f <= 0.3) {
            return -4;
        }
        if ((double)f > 0.3 && (double)f <= 1.0) {
            return 0;
        }
        if ((double)f > 1.0 && (double)f <= 1.4) {
            return 10;
        }
        return 15;
    }

    public static int[] updateBiomes(int[] nArray, int n, int n2, int n3, int n4) {
        boolean bl = false;
        if (n2 != 2) {
            bl = true;
            if (n2 > 2) {
                --n2;
            }
        }
        switch (n) {
            case 0: {
                if (bl) {
                    for (int i = 0; i < nArray.length; ++i) {
                        if (BiomeRegister.getMixWinterReplacement(nArray[i], n2) == 5555) continue;
                        nArray[i] = BiomeRegister.getMixWinterReplacement(nArray[i], n2);
                    }
                } else {
                    for (int i = 0; i < nArray.length; ++i) {
                        if (BiomeRegister.getWinterReplacement(nArray[i]) == 5555) continue;
                        nArray[i] = BiomeRegister.getWinterReplacement(nArray[i]);
                    }
                }
                return nArray;
            }
            case 1: {
                if (bl) {
                    for (int i = 0; i < nArray.length; ++i) {
                        if (BiomeRegister.getMixSummerReplacement(nArray[i], n2) == 5555) continue;
                        nArray[i] = BiomeRegister.getMixSummerReplacement(nArray[i], n2);
                    }
                } else {
                    for (int i = 0; i < nArray.length; ++i) {
                        if (BiomeRegister.getSummerReplacement(nArray[i]) == 5555) continue;
                        nArray[i] = BiomeRegister.getSummerReplacement(nArray[i]);
                    }
                }
                return nArray;
            }
            case 2: {
                if (bl) {
                    for (int i = 0; i < nArray.length; ++i) {
                        if (BiomeRegister.getMixSpringReplacement(nArray[i], n2) == 5555) continue;
                        nArray[i] = BiomeRegister.getMixSpringReplacement(nArray[i], n2);
                    }
                } else {
                    for (int i = 0; i < nArray.length; ++i) {
                        if (BiomeRegister.getSpringReplacement(nArray[i]) == 5555) continue;
                        nArray[i] = BiomeRegister.getSpringReplacement(nArray[i]);
                    }
                }
                return nArray;
            }
            case 3: {
                if (bl) {
                    for (int i = 0; i < nArray.length; ++i) {
                        if (BiomeRegister.getMixFallReplacement(nArray[i], n2) == 5555) continue;
                        nArray[i] = BiomeRegister.getMixFallReplacement(nArray[i], n2);
                    }
                } else {
                    long l = n4;
                    l = (long)n3 + (l << 32);
                    Random random = new Random(l);
                    int n5 = random.nextInt(5);
                    for (int i = 0; i < nArray.length; ++i) {
                        if (BiomeRegister.getFallReplacements(nArray[i]).size() == 1) {
                            if (BiomeRegister.getFallReplacements(nArray[i]).get(0) == 5555) continue;
                            nArray[i] = BiomeRegister.getFallReplacements(nArray[i]).get(0);
                            continue;
                        }
                        nArray[i] = i < 1024 ? BiomeRegister.getFallReplacements(nArray[i]).get(treeFallpackets.get(n5)[i]).intValue() : BiomeRegister.getFallReplacements(nArray[i]).get(treeFallpackets.get(n5)[i % 1024]).intValue();
                    }
                }
                return nArray;
            }
        }
        return nArray;
    }

    public static int getDefaultBiomeTemperature(String string) {
        if (string.equals("BADLANDS")) {
            return 15;
        }
        if (string.equals("JUNGLE")) {
            return 12;
        }
        if (string.equals("BEACH")) {
            return 0;
        }
        if (string.equals("BIRCH_FOREST")) {
            return 0;
        }
        if (string.equals("OCEAN")) {
            return 0;
        }
        if (string.equals("DARK_FOREST")) {
            return 0;
        }
        if (string.equals("DESERT")) {
            return 15;
        }
        if (string.equals("FLOWER_FOREST")) {
            return 0;
        }
        if (string.equals("FOREST")) {
            return 0;
        }
        if (string.equals("TAIGA")) {
            return -4;
        }
        if (string.equals("MOUNTAINS")) {
            return -4;
        }
        if (string.equals("MUSHROOM_FIELDS")) {
            return 0;
        }
        if (string.equals("PLAINS")) {
            return 0;
        }
        if (string.equals("RIVER")) {
            return 0;
        }
        if (string.equals("SAVANNA")) {
            return 10;
        }
        if (string.equals("CAVES")) {
            return 5;
        }
        if (string.equals("FROZEN_BIOMES") || string.equals("FROZEN_MOUNTAINS")) {
            return -12;
        }
        if (string.equals("SWAMP")) {
            return 0;
        }
        return 0;
    }
}

