/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.blockscanner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.blockscanner.BlockEffect;
import me.casperge.realisticseasons.blockscanner.ChunkSystem;
import me.casperge.realisticseasons.blockscanner.SimpleLocation;
import me.casperge.realisticseasons.temperature.TemperatureSettings;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class BlockProcessor {
    private boolean isProcessing = false;
    private HashMap<UUID, Integer> positiveEffects = new HashMap();
    private HashMap<UUID, Integer> negativeEffects = new HashMap();
    private RealisticSeasons main;
    private TemperatureSettings tempsettings;

    public BlockProcessor(RealisticSeasons realisticSeasons) {
        this.main = realisticSeasons;
        this.tempsettings = realisticSeasons.getTemperatureManager().getTempData().getTempSettings();
    }

    public boolean isProcessing() {
        return this.isProcessing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(HashMap<UUID, ChunkSystem> hashMap, HashMap<UUID, SimpleLocation> hashMap2) {
        this.isProcessing = true;
        HashMap<UUID, List<SimpleLocation>> hashMap3 = new HashMap<UUID, List<SimpleLocation>>();
        HashMap<UUID, Integer> hashMap4 = new HashMap<UUID, Integer>();
        this.positiveEffects.clear();
        this.negativeEffects.clear();
        for (UUID object : hashMap.keySet()) {
            if (!hashMap2.containsKey(object)) continue;
            hashMap4.put(object, 0);
            this.negativeEffects.put(object, 0);
            this.positiveEffects.put(object, 0);
        }
        int n = 16;
        for (UUID uUID : hashMap4.keySet()) {
            SimpleLocation simpleLocation = hashMap2.get(uUID);
            for (int i = simpleLocation.getX() - n; i < simpleLocation.getX() + n; ++i) {
                int n2;
                int n3;
                for (n3 = simpleLocation.getZ() - n; n3 < simpleLocation.getZ() + n; ++n3) {
                    for (n2 = simpleLocation.getY() - n; n2 < simpleLocation.getY() + n; ++n2) {
                        if (n2 >= simpleLocation.getMaxY() || n2 < simpleLocation.getMinY()) continue;
                        Material material = hashMap.get(uUID).getBlockType(i, n2, n3);
                        if (material.toString().contains("LEAVE") && n2 != simpleLocation.getMinY() && hashMap.get(uUID).getBlockType(i, n2 - 1, n3).equals((Object)Material.AIR) && BlockProcessor.distanceTo(i, n2, n3, simpleLocation.getX(), simpleLocation.getY(), simpleLocation.getZ()) < 8.0) {
                            if (!hashMap3.containsKey(uUID)) {
                                hashMap3.put(uUID, new ArrayList());
                            }
                            hashMap3.get(uUID).add(new SimpleLocation(i, n2, n3, simpleLocation.getWorldName()));
                        }
                        if (this.tempsettings == null) continue;
                        HashMap<Material, BlockEffect> hashMap5 = this.tempsettings.blockEffects;
                        synchronized (hashMap5) {
                            if (this.tempsettings.hasBlockEffect(material)) {
                                int n4 = this.tempsettings.getBlockEffect(material).getRange();
                                int n5 = this.tempsettings.getBlockEffect(material).getModifier();
                                double d2 = BlockProcessor.distanceTo(simpleLocation.getX(), simpleLocation.getY(), simpleLocation.getZ(), i, n2, n3);
                                n5 -= (int)Math.round(d2 / (double)n4 * (double)n5);
                                if ((double)n4 >= d2) {
                                    if (d2 > 1.4 && !this.hasAnyLineOfSight(simpleLocation, new SimpleBlock(i, n2, n3), hashMap.get(uUID), d2)) {
                                        continue;
                                    }
                                    if (n5 >= 0) {
                                        if (n5 > this.positiveEffects.get(uUID)) {
                                            this.positiveEffects.put(uUID, n5);
                                        }
                                    } else if (n5 < this.negativeEffects.get(uUID)) {
                                        this.negativeEffects.put(uUID, n5);
                                    }
                                }
                            }
                            continue;
                        }
                    }
                }
                n3 = 0;
                n2 = 0;
                if (this.positiveEffects.containsKey(uUID)) {
                    n3 = this.positiveEffects.get(uUID);
                }
                if (this.negativeEffects.containsKey(uUID)) {
                    n2 = this.negativeEffects.get(uUID);
                }
                hashMap4.put(uUID, n3 + n2);
            }
        }
        this.handleTemperatureResult(hashMap4);
        this.handleParticleResults(hashMap3);
        this.isProcessing = false;
    }

    public void handleTemperatureResult(final HashMap<UUID, Integer> hashMap) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.main, new Runnable(){

            @Override
            public void run() {
                BlockProcessor.this.main.getTemperatureManager().getTempData().updateBlockEffects(hashMap);
            }
        }, 0L);
    }

    public void handleParticleResults(final HashMap<UUID, List<SimpleLocation>> hashMap) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.main, new Runnable(){

            @Override
            public void run() {
                ((BlockProcessor)BlockProcessor.this).main.getParticleManager().leaveLocations = hashMap;
            }
        }, 0L);
    }

    public static double distanceTo(int n, int n2, int n3, int n4, int n5, int n6) {
        return Math.sqrt(Math.pow(n - n4, 2.0) + Math.pow(n2 - n5, 2.0) + Math.pow(n3 - n6, 2.0));
    }

    public boolean hasLineOfSight(SimpleLocation simpleLocation, SimpleBlock simpleBlock, ChunkSystem chunkSystem, double d2) {
        SimpleBlock simpleBlock2 = new SimpleBlock(simpleLocation.getX(), simpleLocation.getY(), simpleLocation.getZ());
        SimpleBlock simpleBlock3 = new SimpleBlock(simpleLocation.getX(), simpleLocation.getY() + 1, simpleLocation.getZ());
        return this.hasLineOfSight(simpleBlock2, simpleBlock, chunkSystem, d2) || this.hasLineOfSight(simpleBlock3, simpleBlock, chunkSystem, d2);
    }

    public boolean hasAnyLineOfSight(SimpleLocation simpleLocation, SimpleBlock simpleBlock, ChunkSystem chunkSystem, double d2) {
        SimpleBlock[] simpleBlockArray;
        if (this.hasLineOfSight(simpleLocation, simpleBlock, chunkSystem, d2)) {
            return true;
        }
        for (SimpleBlock simpleBlock2 : simpleBlockArray = new SimpleBlock[]{new SimpleBlock(simpleBlock.getX(), simpleBlock.getY() + 1, simpleBlock.getZ()), new SimpleBlock(simpleBlock.getX(), simpleBlock.getY() - 1, simpleBlock.getZ()), new SimpleBlock(simpleBlock.getX(), simpleBlock.getY(), simpleBlock.getZ() - 1), new SimpleBlock(simpleBlock.getX(), simpleBlock.getY(), simpleBlock.getZ() + 1), new SimpleBlock(simpleBlock.getX() + 1, simpleBlock.getY(), simpleBlock.getZ()), new SimpleBlock(simpleBlock.getX() - 1, simpleBlock.getY(), simpleBlock.getZ())}) {
            Material material = chunkSystem.getBlockType(simpleBlock2.getX(), simpleBlock2.getY(), simpleBlock2.getZ());
            if (!material.equals((Object)Material.AIR) && material.isOccluding() || !this.hasLineOfSight(simpleLocation, simpleBlock2, chunkSystem, d2)) continue;
            return true;
        }
        return false;
    }

    private boolean hasLineOfSight(SimpleBlock simpleBlock, SimpleBlock simpleBlock2, ChunkSystem chunkSystem, double d2) {
        Vector vector = new Vector(simpleBlock.getX(), simpleBlock.getY(), simpleBlock.getZ());
        Vector vector2 = new Vector(simpleBlock2.getX(), simpleBlock2.getY(), simpleBlock2.getZ());
        Vector vector3 = vector.subtract(vector2).normalize();
        Vector vector4 = vector3.multiply(0.5);
        int n = 0;
        while ((double)n < d2 * 2.2) {
            int n2;
            int n3;
            Vector vector5 = vector2.clone();
            Vector vector6 = vector4.clone().multiply(n);
            vector5.add(vector6);
            if (vector6.length() >= d2) break;
            int n4 = vector5.getBlockX();
            if (!chunkSystem.getBlockType(n4, n3 = vector5.getBlockY(), n2 = vector5.getBlockZ()).equals((Object)Material.AIR) && chunkSystem.getBlockType(n4, n3, n2).isOccluding()) {
                return n4 == simpleBlock.getX() && n3 == simpleBlock.getY() && n2 == simpleBlock.getZ();
            }
            ++n;
        }
        return true;
    }

    private class SimpleBlock {
        private int x;
        private int y;
        private int z;

        public SimpleBlock(int n, int n2, int n3) {
            this.x = n;
            this.y = n2;
            this.z = n3;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }
    }
}

