/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.blockscanner.blocksaver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.blockscanner.SimpleLocation;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class BlockStorage {
    private RealisticSeasons main;
    private HashMap<String, List<SimpleLocation>> placedFlowers = new HashMap();
    private AtomicBoolean isReading = new AtomicBoolean(false);

    public BlockStorage(RealisticSeasons realisticSeasons) {
        this.main = realisticSeasons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(ConfigurationSection configurationSection) {
        HashMap<String, List<SimpleLocation>> hashMap = this.placedFlowers;
        synchronized (hashMap) {
            for (String string : configurationSection.getKeys(false)) {
                ArrayList<SimpleLocation> arrayList = new ArrayList<SimpleLocation>();
                List list = configurationSection.getStringList(string);
                for (String string2 : list) {
                    String[] stringArray = string2.split(",");
                    arrayList.add(new SimpleLocation(Integer.valueOf(stringArray[0]), Integer.valueOf(stringArray[1]), Integer.valueOf(stringArray[2]), stringArray[3]));
                }
                this.placedFlowers.put(string, arrayList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(YamlConfiguration yamlConfiguration) {
        yamlConfiguration.set("placedblocks", null);
        HashMap<String, List<SimpleLocation>> hashMap = this.placedFlowers;
        synchronized (hashMap) {
            for (String string : this.placedFlowers.keySet()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (SimpleLocation simpleLocation : this.placedFlowers.get(string)) {
                    arrayList.add(String.valueOf(simpleLocation.getX()) + "," + String.valueOf(simpleLocation.getY()) + "," + String.valueOf(simpleLocation.getZ()) + "," + simpleLocation.getWorldName());
                }
                yamlConfiguration.set("placedblocks." + string, arrayList);
            }
        }
    }

    public void logPlacement(Location location) {
        final SimpleLocation simpleLocation = new SimpleLocation(location, 0, 0);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block8: {
                    if (BlockStorage.this.isReading.get()) {
                        int n = 0;
                        do {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                                break block8;
                            }
                            ++n;
                            if (!BlockStorage.this.isReading.get()) break block8;
                        } while (n <= 20);
                        return;
                    }
                }
                HashMap hashMap = BlockStorage.this.placedFlowers;
                synchronized (hashMap) {
                    for (String string : BlockStorage.this.placedFlowers.keySet()) {
                        if (!string.equalsIgnoreCase(simpleLocation.getWorldName())) continue;
                        List list = (List)BlockStorage.this.placedFlowers.get(string);
                        list.add(simpleLocation);
                        BlockStorage.this.placedFlowers.put(simpleLocation.getWorldName(), list);
                        return;
                    }
                    ArrayList arrayList = new ArrayList();
                    arrayList.add(simpleLocation);
                    BlockStorage.this.placedFlowers.put(simpleLocation.getWorldName(), arrayList);
                    return;
                }
            }
        });
    }

    public void logBreak(final Location location) {
        final SimpleLocation simpleLocation = new SimpleLocation(location, 0, 0);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.main, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block10: {
                    if (BlockStorage.this.isReading.get()) {
                        int n = 0;
                        do {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                                break block10;
                            }
                            ++n;
                            if (!BlockStorage.this.isReading.get()) break block10;
                        } while (n <= 20);
                        return;
                    }
                }
                HashMap hashMap = BlockStorage.this.placedFlowers;
                synchronized (hashMap) {
                    for (String string : BlockStorage.this.placedFlowers.keySet()) {
                        if (!string.equalsIgnoreCase(simpleLocation.getWorldName())) continue;
                        int n = 0;
                        boolean bl = false;
                        for (SimpleLocation simpleLocation2 : (List)BlockStorage.this.placedFlowers.get(string)) {
                            if (simpleLocation2.getX() == location.getBlockX() && simpleLocation2.getY() == location.getBlockY() && simpleLocation2.getZ() == location.getBlockZ()) {
                                bl = true;
                                break;
                            }
                            ++n;
                        }
                        if (!bl) continue;
                        ((List)BlockStorage.this.placedFlowers.get(string)).remove(n);
                    }
                    return;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isManualPlacedFlower(Location location) {
        if (!this.main.getSettings().keepPlayerPlacedPlants) {
            return false;
        }
        this.isReading.set(true);
        HashMap<String, List<SimpleLocation>> hashMap = this.placedFlowers;
        synchronized (hashMap) {
            for (String string : this.placedFlowers.keySet()) {
                if (!string.equalsIgnoreCase(location.getWorld().getName())) continue;
                for (SimpleLocation simpleLocation : this.placedFlowers.get(string)) {
                    if (simpleLocation.getX() != location.getBlockX() || simpleLocation.getY() != location.getBlockY() || simpleLocation.getZ() != location.getBlockZ()) continue;
                    this.isReading.set(false);
                    return true;
                }
            }
        }
        this.isReading.set(false);
        return false;
    }
}

