/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.calendar;

import java.util.ArrayList;
import java.util.HashMap;
import me.casperge.realisticseasons.calendar.Date;
import me.casperge.realisticseasons.calendar.Month;
import me.casperge.realisticseasons.calendar.Week;
import me.casperge.realisticseasons.calendar.Year;
import me.casperge.realisticseasons.season.Season;

public class Calendar {
    private Week week;
    private Year year;
    private Date winterstart;
    private Date springstart;
    private Date summerstart;
    private Date fallstart;
    HashMap<Date, Season> seasonStart = new HashMap();

    public Calendar(Week week, Year year, Date date, Date date2, Date date3, Date date4) {
        this.week = week;
        this.year = year;
        this.winterstart = date;
        this.springstart = date2;
        this.summerstart = date3;
        this.fallstart = date4;
        this.seasonStart.put(date, Season.WINTER);
        this.seasonStart.put(date4, Season.FALL);
        this.seasonStart.put(date3, Season.SUMMER);
        this.seasonStart.put(date2, Season.SPRING);
    }

    public String getWeekDay(int n) {
        return this.week.getWeekDay(n);
    }

    public Month getMonth(int n) {
        return this.year.getMonth(n);
    }

    public Date getSeasonStart(Season season) {
        switch (season) {
            case WINTER: {
                return this.winterstart;
            }
            case SUMMER: {
                return this.summerstart;
            }
            case FALL: {
                return this.fallstart;
            }
            case SPRING: {
                return this.springstart;
            }
        }
        return null;
    }

    public Season getSeason(Date date) {
        HashMap<Date, Integer> hashMap = new HashMap<Date, Integer>();
        ArrayList<Date> arrayList = new ArrayList<Date>();
        arrayList.add(this.summerstart);
        arrayList.add(this.winterstart);
        arrayList.add(this.fallstart);
        arrayList.add(this.springstart);
        for (Date date2 : arrayList) {
            int n = 0;
            for (Date date3 : arrayList) {
                if (date2 == date3 || date2.isLaterInYear(date3)) continue;
                ++n;
            }
            hashMap.put(date2, n);
        }
        for (Date date2 : hashMap.keySet()) {
            arrayList.set((Integer)hashMap.get(date2), date2);
        }
        if (((Date)arrayList.get(0)).isLaterInYear(date) && !((Date)arrayList.get(1)).isLaterInYear(date)) {
            return this.seasonStart.get(arrayList.get(0));
        }
        if (((Date)arrayList.get(1)).isLaterInYear(date) && !((Date)arrayList.get(2)).isLaterInYear(date)) {
            return this.seasonStart.get(arrayList.get(1));
        }
        if (((Date)arrayList.get(2)).isLaterInYear(date) && !((Date)arrayList.get(3)).isLaterInYear(date)) {
            return this.seasonStart.get(arrayList.get(2));
        }
        return this.seasonStart.get(arrayList.get(3));
    }

    public Date getNextDate(Date date) {
        int n = date.getDay();
        int n2 = date.getMonth();
        int n3 = date.getYear();
        Month month = this.getMonth(n2);
        if (n >= month.getLength()) {
            if (n2 >= this.year.getMonths().size()) {
                return new Date(1, 1, n3 + 1);
            }
            return new Date(1, n2 + 1, n3);
        }
        return new Date(n + 1, n2, n3);
    }

    public int getTotalDays(Date date) {
        int n = date.getYear();
        int n2 = 0;
        int n3 = 0;
        for (Month month : this.year.getMonths()) {
            n2 += month.getLength();
        }
        n3 = n2 * n;
        for (Month month : this.year.getMonths()) {
            if (month.getName().equals(this.getMonth(date.getMonth()).getName())) break;
            n3 += month.getLength();
        }
        return n3 + date.getDay();
    }

    public int getTotalDaysPassedThisYear(Date date) {
        int n = 0;
        for (Month month : this.year.getMonths()) {
            if (month.getName().equals(this.getMonth(date.getMonth()).getName())) break;
            n += month.getLength();
        }
        return n + date.getDay();
    }

    public String getWeekDay(Date date) {
        int n = this.getTotalDays(date);
        int n2 = n % this.week.getWeekDays().size();
        return this.getWeekDay(n2);
    }

    public int getWeekDayAsInt(Date date) {
        int n = this.getTotalDays(date);
        int n2 = n % this.week.getWeekDays().size();
        return n2;
    }

    public int getDaysUntil(Date date, Date date2) {
        int n = this.getTotalDaysPassedThisYear(date2);
        int n2 = this.getTotalDaysPassedThisYear(date);
        if (n2 <= n) {
            return n - n2;
        }
        int n3 = 0;
        for (Month month : this.year.getMonths()) {
            n3 += month.getLength();
        }
        return n + (n3 - n2) - 1;
    }

    public int getTotalMonths() {
        return this.year.getMonths().size();
    }

    public int weekDayFromString(String string) {
        return this.week.weekDayFromString(string);
    }
}

