/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.calendar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.calendar.Date;
import me.casperge.realisticseasons.calendar.DayChangeEvent;
import me.casperge.realisticseasons.season.Season;
import me.casperge.realisticseasons.seasonevent.CustomDailyEvent;
import me.casperge.realisticseasons.seasonevent.CustomDatedEvent;
import me.casperge.realisticseasons.seasonevent.CustomWeeklyEvent;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class DayChangeHandler
implements Listener {
    private RealisticSeasons main;
    private final List<Season> seasons = new ArrayList<Season>(Arrays.asList(Season.FALL, Season.WINTER, Season.SUMMER, Season.SPRING));

    public DayChangeHandler(RealisticSeasons realisticSeasons) {
        realisticSeasons.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)realisticSeasons);
        this.main = realisticSeasons;
    }

    @EventHandler
    public void dayChange(DayChangeEvent dayChangeEvent) {
        Date date = dayChangeEvent.getFrom();
        Date date2 = dayChangeEvent.getTo();
        if (this.main.getTemperatureManager().getTempData().isEnabledWorld(dayChangeEvent.getWorld()) && this.main.getTemperatureManager().getTempData().isEnabled()) {
            if (this.seasons.contains((Object)this.main.getSeasonManager().getSeason(dayChangeEvent.getWorld()))) {
                this.main.getTemperatureManager().getTempData().setBaseTemperature(dayChangeEvent.getWorld(), this.main.getTemperatureManager().getTempUtils().generateNewBaseTemperature(dayChangeEvent.getWorld()));
            } else {
                this.main.getTemperatureManager().getTempData().setBaseTemperature(dayChangeEvent.getWorld(), 25);
            }
        }
        if (date == null || date2 == null) {
            return;
        }
        if (this.main.getSettings().doSeasonCycle && this.main.getSeasonManager().getSeason(dayChangeEvent.getWorld()) != this.main.getTimeManager().getCalendar().getSeason(date2)) {
            this.main.getSeasonManager().setSeason(dayChangeEvent.getWorld(), this.main.getTimeManager().getCalendar().getSeason(date2), false);
        }
        for (CustomDailyEvent seasonCustomEvent : this.main.getEventManager().getDailyEvents()) {
            this.main.getEventManager().start(dayChangeEvent.getWorld(), seasonCustomEvent, date2);
        }
        for (CustomWeeklyEvent customWeeklyEvent : this.main.getEventManager().getWeeklyEvents()) {
            if (customWeeklyEvent.isToday(this.main.getTimeManager().getWeekDayAsInt(date2, false))) {
                this.main.getEventManager().start(dayChangeEvent.getWorld(), customWeeklyEvent, date2);
                continue;
            }
            if (customWeeklyEvent.isToday(this.main.getTimeManager().getWeekDayAsInt(date2, false)) || !customWeeklyEvent.isToday(this.main.getTimeManager().getWeekDayAsInt(date, true))) continue;
            this.main.getEventManager().stop(dayChangeEvent.getWorld(), customWeeklyEvent, date2);
        }
        for (CustomDatedEvent customDatedEvent : this.main.getEventManager().getDatedEvents()) {
            if (customDatedEvent.isActive(date2) && !customDatedEvent.isActive(date)) {
                this.main.getEventManager().start(dayChangeEvent.getWorld(), customDatedEvent, date2);
                continue;
            }
            if (customDatedEvent.isActive(date2) || !customDatedEvent.isActive(date)) continue;
            this.main.getEventManager().stop(dayChangeEvent.getWorld(), customDatedEvent, date2);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.main, new Runnable(){

            @Override
            public void run() {
                DayChangeHandler.this.main.getSeasonManager().runSubSeasonCheck();
            }
        }, 1L);
    }
}

