/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.calendar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.casperge.realisticseasons.utils.JavaUtils;
import org.bukkit.Bukkit;

public class DayTime {
    private List<Integer> dayArray = new ArrayList<Integer>();
    private List<Integer> nightArray = new ArrayList<Integer>();
    private int dayLength;
    private int nightLength;

    public DayTime(int n, int n2) {
        this.dayLength = n;
        this.nightLength = n2;
        this.dayArray = DayTime.generateIntList(n);
        this.nightArray = DayTime.generateIntList(n2);
    }

    public int getDayLength() {
        return this.dayLength;
    }

    public int getNightLength() {
        return this.nightLength;
    }

    public List<Integer> getDayArray() {
        return this.dayArray;
    }

    public List<Integer> getNightArray() {
        return this.nightArray;
    }

    public static List<Integer> generateIntList(int n) {
        double d2 = n;
        if (10.0 / d2 <= 1.0) {
            int n2 = JavaUtils.gcd(10, n);
            int n3 = n / n2;
            int n4 = 10 / n2;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < n3; ++i) {
                if (i < n4) {
                    arrayList.add(1);
                    continue;
                }
                arrayList.add(0);
            }
            Collections.shuffle(arrayList);
            return arrayList;
        }
        List<Integer> list = DayTime.getCorrectListBelow10(n);
        Collections.shuffle(list);
        return list;
    }

    public static List<Integer> getCorrectListBelow10(int n) {
        switch (n) {
            case 0: {
                Bukkit.getLogger().severe("Day/night length can't be 0!");
                return null;
            }
            case 1: {
                return Arrays.asList(10);
            }
            case 2: {
                return Arrays.asList(5);
            }
            case 3: {
                return Arrays.asList(3, 3, 4);
            }
            case 4: {
                return Arrays.asList(3, 3, 3, 3, 2, 1);
            }
            case 5: {
                return Arrays.asList(2);
            }
            case 6: {
                return Arrays.asList(2, 2, 1);
            }
            case 7: {
                return Arrays.asList(2, 2, 2, 1, 1, 1, 1);
            }
            case 8: {
                return Arrays.asList(2, 1, 1, 1);
            }
            case 9: {
                return Arrays.asList(2, 1, 1, 1, 1, 1, 1, 1, 1);
            }
            case 10: {
                return Arrays.asList(1);
            }
        }
        return Arrays.asList(1);
    }
}

