/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.api.CustomBiomeFileLoader;
import me.casperge.realisticseasons.api.CustomWorldGenerator;
import me.casperge.realisticseasons.api.SeasonsAPI;
import me.casperge.realisticseasons.api.TemperatureEffect;
import me.casperge.realisticseasons.biome.BiomeRegister;
import me.casperge.realisticseasons.calendar.Date;
import me.casperge.realisticseasons.data.LanguageManager;
import me.casperge.realisticseasons.data.MessageType;
import me.casperge.realisticseasons.season.Season;
import me.casperge.realisticseasons.utils.JavaUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RealisticSeasonsCommand
implements CommandExecutor {
    RealisticSeasons main;
    private HashMap<UUID, TemperatureEffect> tempEffects = new HashMap();
    private final Season[] seasons = new Season[]{Season.WINTER, Season.SUMMER, Season.FALL, Season.WINTER};

    public RealisticSeasonsCommand(RealisticSeasons realisticSeasons) {
        this.main = realisticSeasons;
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            if (player.hasPermission("realisticseasons.admin")) {
                if (stringArray.length < 1) {
                    this.displayHelp(player);
                } else if (stringArray.length == 1) {
                    if (stringArray[0].equalsIgnoreCase("disable")) {
                        if (this.hasSeasons(player)) {
                            this.disable(player.getWorld());
                            player.sendMessage(ChatColor.GREEN + "Disabled seasons in this world");
                        }
                    } else if (stringArray[0].equalsIgnoreCase("getinfo")) {
                        this.main.getSeasonManager().sendSeasonInfo(player);
                    } else if (stringArray[0].equalsIgnoreCase("nextseason")) {
                        if (this.hasSeasons(player) && !this.nextSeason(player.getWorld())) {
                            player.sendMessage(ChatColor.RED + "Seasons are currently disabled in this world, so there isn't a next one");
                            player.sendMessage(ChatColor.RED + "Type '/rs set <spring/summer/fall/winter>' to enable seasons in this world");
                        }
                    } else if (stringArray[0].equalsIgnoreCase("set")) {
                        player.sendMessage(ChatColor.RED + "Please choose between spring, summer, fall and winter");
                    } else if (stringArray[0].equalsIgnoreCase("restoreworld")) {
                        if (!this.setSeason(Season.RESTORE, player.getWorld())) {
                            player.sendMessage(ChatColor.RED + "You can't have seasons in this type of world!");
                        } else {
                            player.sendMessage(ChatColor.GREEN + "Succesfully started restoring this world. It is recommended to still leave the plugin on the server for a while, since unloaded chunks will only be restored once a player loads them.");
                        }
                    } else if (stringArray[0].equalsIgnoreCase("install")) {
                        List<String> list = CustomWorldGenerator.getAllGenerators();
                        boolean bl = true;
                        String string2 = "";
                        for (String string3 : list) {
                            if (bl) {
                                string2 = string3;
                                bl = false;
                                continue;
                            }
                            string2 = "/" + string2;
                        }
                        player.sendMessage(ChatColor.RED + "Usage: /rs install <" + string2 + ">");
                    } else if (stringArray[0].equalsIgnoreCase("pausetime")) {
                        if (player.getWorld().getEnvironment() == World.Environment.NETHER || player.getWorld().getEnvironment() == World.Environment.THE_END) {
                            player.sendMessage(ChatColor.RED + "You can only pause time in an overworld.");
                            return true;
                        }
                        Season season = this.main.getSeasonManager().getSeason(player.getWorld());
                        boolean bl = true;
                        if (season == Season.DISABLED || season == Season.RESTORE) {
                            bl = false;
                        }
                        if (bl && this.main.getSettings().syncWorldTimeWithRealWorld) {
                            player.sendMessage(ChatColor.RED + "You can't pause time while sync time with real world is enabled.");
                            return true;
                        }
                        if (!bl || !this.main.getSettings().affectTime) {
                            boolean bl2 = (Boolean)player.getWorld().getGameRuleValue(GameRule.DO_DAYLIGHT_CYCLE);
                            if (bl2) {
                                player.getWorld().setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
                                player.sendMessage(ChatColor.GREEN + "Time is now paused in this world");
                            } else {
                                player.getWorld().setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)true);
                                player.sendMessage(ChatColor.GREEN + "Time is now resumed in this world");
                            }
                        } else {
                            boolean bl3;
                            if (!((Boolean)player.getWorld().getGameRuleValue(GameRule.DO_DAYLIGHT_CYCLE)).booleanValue()) {
                                player.getWorld().setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
                            }
                            if (bl3 = this.main.getTimeManager().hasTime(player.getWorld())) {
                                this.main.getTimeManager().pauseTime(player.getWorld());
                                player.sendMessage(ChatColor.GREEN + "Time is now paused in this world");
                            } else {
                                this.main.getTimeManager().resumeTime(player.getWorld());
                                player.sendMessage(ChatColor.GREEN + "Time is now resumed in this world");
                            }
                        }
                    } else if (stringArray[0].equalsIgnoreCase("reload")) {
                        player.sendMessage(ChatColor.GREEN + "Succesfully reloaded the RealisticSeasons files");
                        player.sendMessage(ChatColor.GREEN + "Changes made to biome files will require a full restart");
                        this.main.reload();
                    } else if (stringArray[0].equalsIgnoreCase("debug")) {
                        this.main.debugMode = !this.main.debugMode;
                        player.sendMessage(ChatColor.GREEN + "Debug mode is now: " + String.valueOf(this.main.debugMode));
                        this.main.reload();
                    } else {
                        this.displayHelp(player);
                    }
                } else if (stringArray.length == 2) {
                    if (stringArray[0].equalsIgnoreCase("temperature") && stringArray[1].equalsIgnoreCase("toggle")) {
                        if (this.main.getTemperatureManager().getTempData().isEnabledWorld(player.getWorld())) {
                            player.sendMessage(ChatColor.GREEN + "Temperature in this world is now: " + ChatColor.DARK_GREEN + "DISABLED");
                        } else {
                            player.sendMessage(ChatColor.GREEN + "Temperature in this world is now: " + ChatColor.DARK_GREEN + "ENABLED");
                        }
                        this.main.getTemperatureManager().getTempData().toggleTemperature(player.getWorld());
                    } else if (stringArray[0].equalsIgnoreCase("set")) {
                        this.setByPlayer(player, player.getWorld(), stringArray);
                    } else if (stringArray[0].equalsIgnoreCase("setdate")) {
                        if (stringArray[1].split("/").length != 3) {
                            if (this.main.getSettings().americandateformat) {
                                player.sendMessage(ChatColor.RED + "Please use the format: mm/dd/yyyy");
                            } else {
                                player.sendMessage(ChatColor.RED + "Please use the format: dd/mm/yyyy");
                            }
                        } else {
                            boolean bl = true;
                            for (String string4 : stringArray[1].split("/")) {
                                if (JavaUtils.isNumeric(string4)) continue;
                                bl = false;
                            }
                            if (!bl) {
                                if (this.main.getSettings().americandateformat) {
                                    player.sendMessage(ChatColor.RED + "Please use the format: mm/dd/yyyy. Example: 01/05/0001");
                                } else {
                                    player.sendMessage(ChatColor.RED + "Please use the format: dd/mm/yyyy. Example: 01/05/0001");
                                }
                            } else if (Date.fromString(stringArray[1], this.main.getSettings().americandateformat).getMonth() > this.main.getTimeManager().getCalendar().getTotalMonths()) {
                                player.sendMessage(ChatColor.RED + "Month can't be more than " + String.valueOf(this.main.getTimeManager().getCalendar().getTotalMonths()));
                            } else {
                                Date date = Date.fromString(stringArray[1], this.main.getSettings().americandateformat);
                                if (date.getDay() != 0 && date.getMonth() != 0) {
                                    this.main.getTimeManager().setDate(player.getWorld(), date);
                                    player.sendMessage(ChatColor.GREEN + "Changing date to: " + ChatColor.DARK_GREEN + Date.fromString(stringArray[1], this.main.getSettings().americandateformat).toString(this.main.getSettings().americandateformat));
                                }
                            }
                        }
                    } else if (stringArray[0].equalsIgnoreCase("install")) {
                        if (CustomWorldGenerator.isWorldGenerator(stringArray[1])) {
                            CustomWorldGenerator customWorldGenerator = CustomWorldGenerator.fromFile(stringArray[1]);
                            if (CustomBiomeFileLoader.getActiveGenerators().contains((Object)customWorldGenerator)) {
                                if (!CustomBiomeFileLoader.getAlreadyInstalledGenerators().contains((Object)customWorldGenerator)) {
                                    CustomBiomeFileLoader.writeFiles(customWorldGenerator);
                                    player.sendMessage(ChatColor.GREEN + "Successfully installed " + customWorldGenerator.toString() + " configuration files. Please restart your server to activate them.");
                                } else {
                                    player.sendMessage(ChatColor.RED + "Files for " + customWorldGenerator.toString() + " are already detected in the biomes folder. Please remove them first");
                                }
                            } else {
                                player.sendMessage(ChatColor.RED + customWorldGenerator.toString() + " is currently not installed on your server. Please install it first.");
                            }
                        } else {
                            List<String> list = CustomWorldGenerator.getAllGenerators();
                            boolean bl = true;
                            String string5 = "";
                            for (String string6 : list) {
                                if (bl) {
                                    string5 = string6;
                                    bl = false;
                                    continue;
                                }
                                string5 = ", " + string5;
                            }
                            player.sendMessage(ChatColor.RED + "Please choose between " + string5 + "");
                        }
                    } else {
                        this.displayHelp(player);
                    }
                } else {
                    if (stringArray.length == 3) {
                        if (stringArray[0].equalsIgnoreCase("set")) {
                            World world = Bukkit.getWorld((String)stringArray[2]);
                            if (world == null) {
                                player.sendMessage(ChatColor.RED + "Could not find that world!");
                                return true;
                            }
                            this.setByPlayer(player, world, stringArray);
                            return true;
                        }
                        if (stringArray[0].equalsIgnoreCase("temperature") && stringArray[1].equalsIgnoreCase("clear")) {
                            String string7 = stringArray[2];
                            if (Bukkit.getPlayer((String)string7) != null) {
                                Player player2 = Bukkit.getPlayer((String)string7);
                                if (!player2.isOnline()) {
                                    player.sendMessage(ChatColor.RED + "Could not find player: " + string7);
                                    return true;
                                }
                                this.main.getTemperatureManager().getTempData().clearCustomTemperatureEffects(player2);
                                player.sendMessage(ChatColor.GREEN + "Removed all custom temperature effects of " + player2.getDisplayName());
                            } else {
                                player.sendMessage(ChatColor.RED + "Could not find player: " + string7);
                            }
                            return true;
                        }
                        this.displayHelp(player);
                        return true;
                    }
                    if (stringArray.length == 5) {
                        if (stringArray[0].equalsIgnoreCase("temperature") && stringArray[1].equalsIgnoreCase("modify")) {
                            String string8 = stringArray[2];
                            if (Bukkit.getPlayer((String)string8) != null) {
                                final Player player3 = Bukkit.getPlayer((String)string8);
                                if (!player3.isOnline()) {
                                    player.sendMessage(ChatColor.RED + "Could not find player: " + string8);
                                    return true;
                                }
                                if (!JavaUtils.isNumeric(stringArray[3])) {
                                    player.sendMessage(ChatColor.YELLOW + "Usage: /rs temperature modify <player> <temperature-change> <duration(s)>");
                                    player.sendMessage(ChatColor.RED + stringArray[3] + " is not a number.");
                                    return true;
                                }
                                if (!stringArray[4].contains("FIXED(")) {
                                    if (!JavaUtils.isNumeric(stringArray[4])) {
                                        player.sendMessage(ChatColor.YELLOW + "Usage: /rs temperature modify <player> <temperature-change> <duration(s)>");
                                        player.sendMessage(ChatColor.RED + stringArray[4] + " is not a number.");
                                        return true;
                                    }
                                    int n = Integer.parseInt(stringArray[3]);
                                    int n2 = Integer.parseInt(stringArray[4]);
                                    this.main.getTemperatureManager().getTempData().applyCustomEffect(player3, n, n2);
                                    player.sendMessage(ChatColor.GREEN + "Successfully applied a temperature change of " + stringArray[3] + " to " + string8 + " for " + stringArray[4] + "s");
                                } else {
                                    int n = Integer.parseInt(stringArray[3]);
                                    String[] stringArray2 = stringArray[4].replaceAll("FIXED\\(", "").replaceAll("\\)", "").split(",");
                                    final int n3 = Integer.valueOf(stringArray2[0]);
                                    final int n4 = Integer.valueOf(stringArray2[1]);
                                    if (stringArray2.length == 2) {
                                        if (this.tempEffects.containsKey(player3.getUniqueId())) {
                                            TemperatureEffect temperatureEffect = this.tempEffects.get(player3.getUniqueId());
                                            int n5 = temperatureEffect.getModifier();
                                            int n6 = n5 + n;
                                            if (n6 > n4) {
                                                n6 = n4;
                                            }
                                            if (n6 < n3) {
                                                n6 = n3;
                                            }
                                            if (n6 != n5) {
                                                temperatureEffect.cancel();
                                                TemperatureEffect temperatureEffect2 = SeasonsAPI.getInstance().applyPermanentTemperatureEffect(player3, n6);
                                                this.tempEffects.put(player3.getUniqueId(), temperatureEffect2);
                                            }
                                        } else {
                                            if (n > n4) {
                                                n = n4;
                                            }
                                            if (n < n3) {
                                                n = n3;
                                            }
                                            TemperatureEffect temperatureEffect = SeasonsAPI.getInstance().applyPermanentTemperatureEffect(player3, n);
                                            this.tempEffects.put(player3.getUniqueId(), temperatureEffect);
                                        }
                                    } else {
                                        int n7 = Integer.valueOf(stringArray2[2]);
                                        if (this.tempEffects.containsKey(player3.getUniqueId())) {
                                            TemperatureEffect temperatureEffect = this.tempEffects.get(player3.getUniqueId());
                                            int n8 = temperatureEffect.getModifier();
                                            final int n9 = n;
                                            int n10 = n8 + n;
                                            if (n10 > n4) {
                                                n10 = n4;
                                            }
                                            if (n10 < n3) {
                                                n10 = n3;
                                            }
                                            if (n10 != n8) {
                                                temperatureEffect.cancel();
                                                TemperatureEffect temperatureEffect3 = SeasonsAPI.getInstance().applyPermanentTemperatureEffect(player3, n10);
                                                this.tempEffects.put(player3.getUniqueId(), temperatureEffect3);
                                            }
                                            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.main, new Runnable(){

                                                @Override
                                                public void run() {
                                                    TemperatureEffect temperatureEffect = (TemperatureEffect)RealisticSeasonsCommand.this.tempEffects.get(player3.getUniqueId());
                                                    int n = temperatureEffect.getModifier();
                                                    int n2 = n - n9;
                                                    if (n2 > n4) {
                                                        n2 = n4;
                                                    }
                                                    if (n2 < n3) {
                                                        n2 = n3;
                                                    }
                                                    if (n9 > 0 && n2 < 0) {
                                                        n2 = 0;
                                                    }
                                                    if (n9 < 0 && n2 > 0) {
                                                        n2 = 0;
                                                    }
                                                    if (n2 != n) {
                                                        temperatureEffect.cancel();
                                                        TemperatureEffect temperatureEffect2 = SeasonsAPI.getInstance().applyPermanentTemperatureEffect(player3, n2);
                                                        RealisticSeasonsCommand.this.tempEffects.put(player3.getUniqueId(), temperatureEffect2);
                                                    }
                                                }
                                            }, (long)n7);
                                        } else {
                                            if (n > n4) {
                                                n = n4;
                                            }
                                            if (n < n3) {
                                                n = n3;
                                            }
                                            TemperatureEffect temperatureEffect = SeasonsAPI.getInstance().applyPermanentTemperatureEffect(player3, n);
                                            final int n11 = n;
                                            this.tempEffects.put(player3.getUniqueId(), temperatureEffect);
                                            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.main, new Runnable(){

                                                @Override
                                                public void run() {
                                                    TemperatureEffect temperatureEffect = (TemperatureEffect)RealisticSeasonsCommand.this.tempEffects.get(player3.getUniqueId());
                                                    int n = temperatureEffect.getModifier();
                                                    int n2 = n - n11;
                                                    if (n2 > n4) {
                                                        n2 = n4;
                                                    }
                                                    if (n2 < n3) {
                                                        n2 = n3;
                                                    }
                                                    if (n11 > 0 && n2 < 0) {
                                                        n2 = 0;
                                                    }
                                                    if (n11 < 0 && n2 > 0) {
                                                        n2 = 0;
                                                    }
                                                    if (n2 != n) {
                                                        temperatureEffect.cancel();
                                                        TemperatureEffect temperatureEffect2 = SeasonsAPI.getInstance().applyPermanentTemperatureEffect(player3, n2);
                                                        RealisticSeasonsCommand.this.tempEffects.put(player3.getUniqueId(), temperatureEffect2);
                                                    }
                                                }
                                            }, (long)n7);
                                        }
                                    }
                                }
                            } else {
                                player.sendMessage(ChatColor.RED + "Could not find player: " + string8);
                            }
                        } else {
                            this.displayHelp(player);
                        }
                    } else {
                        this.displayHelp(player);
                    }
                }
            } else {
                player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageManager.messages.get((Object)MessageType.NO_PERMISSION)));
            }
        } else if (commandSender instanceof ConsoleCommandSender) {
            if (stringArray.length < 1) {
                this.displayConsoleHelp();
            } else if (stringArray.length == 1) {
                if (stringArray[0].equalsIgnoreCase("install")) {
                    List<String> list = CustomWorldGenerator.getAllGenerators();
                    boolean bl = true;
                    String string9 = "";
                    for (String string10 : list) {
                        if (bl) {
                            string9 = string10;
                            bl = false;
                            continue;
                        }
                        string9 = "/" + string9;
                    }
                    Bukkit.getLogger().info("Usage: /rs install <" + string9 + ">");
                } else if (stringArray[0].equalsIgnoreCase("reload")) {
                    Bukkit.getLogger().info("Succesfully reloaded the RealisticSeasons files");
                    Bukkit.getLogger().info("Changes made to biome files will require a full restart");
                    this.main.reload();
                } else if (stringArray[0].equalsIgnoreCase("biomelist")) {
                    this.logBiomeRegister();
                } else if (stringArray[0].equalsIgnoreCase("debug")) {
                    this.main.debugMode = !this.main.debugMode;
                    Bukkit.getLogger().info("Debug mode is now: " + String.valueOf(this.main.debugMode));
                    this.main.reload();
                } else {
                    this.displayConsoleHelp();
                }
            } else if (stringArray.length == 2) {
                if (stringArray[0].equalsIgnoreCase("disable")) {
                    World world = Bukkit.getWorld((String)stringArray[1]);
                    if (world == null) {
                        Bukkit.getLogger().info("ERROR: Invalid world");
                        return true;
                    }
                    this.disable(world);
                    Bukkit.getLogger().info("Disabled seasons in this world");
                } else if (stringArray[0].equalsIgnoreCase("getinfo")) {
                    World world = Bukkit.getWorld((String)stringArray[1]);
                    if (world == null) {
                        Bukkit.getLogger().info("ERROR: Invalid world");
                        return true;
                    }
                    this.main.getSeasonManager().sendSeasonInfoToConsole(world);
                } else if (stringArray[0].equalsIgnoreCase("nextseason")) {
                    World world = Bukkit.getWorld((String)stringArray[1]);
                    if (world == null) {
                        Bukkit.getLogger().info("ERROR: Invalid world");
                        return true;
                    }
                    if (!this.nextSeason(world)) {
                        Bukkit.getLogger().info("Seasons are currently disabled in this world, so there isn't a next one");
                        Bukkit.getLogger().info("Type '/rs set <spring/summer/fall/winter>' to enable seasons in this world");
                    }
                } else if (stringArray[0].equalsIgnoreCase("restoreworld")) {
                    World world = Bukkit.getWorld((String)stringArray[1]);
                    if (world == null) {
                        Bukkit.getLogger().info("ERROR: Invalid world");
                        return true;
                    }
                    if (!this.setSeason(Season.RESTORE, world)) {
                        Bukkit.getLogger().info("You can't have seasons in this type of world!");
                    } else {
                        Bukkit.getLogger().info("Succesfully started restoring this world. It is recommended to still leave the plugin on the server for a while, since unloaded chunks will only be restored once a player loads them.");
                    }
                } else if (stringArray[0].equalsIgnoreCase("pausetime")) {
                    World world = Bukkit.getWorld((String)stringArray[1]);
                    if (world == null) {
                        Bukkit.getLogger().info("ERROR: Invalid world");
                        return true;
                    }
                    if (world.getEnvironment() == World.Environment.NETHER || world.getEnvironment() == World.Environment.THE_END) {
                        Bukkit.getLogger().info("You can only pause time in an overworld.");
                        return true;
                    }
                    Season season = this.main.getSeasonManager().getSeason(world);
                    boolean bl = true;
                    if (season == Season.DISABLED || season == Season.RESTORE) {
                        bl = false;
                    }
                    if (bl && this.main.getSettings().syncWorldTimeWithRealWorld) {
                        Bukkit.getLogger().info("You can't pause time while sync time with real world is enabled.");
                        return true;
                    }
                    if (!bl || !this.main.getSettings().affectTime) {
                        boolean bl4 = (Boolean)world.getGameRuleValue(GameRule.DO_DAYLIGHT_CYCLE);
                        if (bl4) {
                            world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
                            Bukkit.getLogger().info("Time is now paused in this world");
                        } else {
                            world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)true);
                            Bukkit.getLogger().info("Time is now resumed in this world");
                        }
                    } else {
                        boolean bl5;
                        if (!((Boolean)world.getGameRuleValue(GameRule.DO_DAYLIGHT_CYCLE)).booleanValue()) {
                            world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
                        }
                        if (bl5 = this.main.getTimeManager().hasTime(world)) {
                            this.main.getTimeManager().pauseTime(world);
                            Bukkit.getLogger().info("Time is now paused in this world");
                        } else {
                            this.main.getTimeManager().resumeTime(world);
                            Bukkit.getLogger().info("Time is now resumed in this world");
                        }
                    }
                } else if (stringArray[0].equalsIgnoreCase("install")) {
                    if (CustomWorldGenerator.isWorldGenerator(stringArray[1])) {
                        CustomWorldGenerator customWorldGenerator = CustomWorldGenerator.fromFile(stringArray[1]);
                        if (CustomBiomeFileLoader.getActiveGenerators().contains((Object)customWorldGenerator)) {
                            if (!CustomBiomeFileLoader.getAlreadyInstalledGenerators().contains((Object)customWorldGenerator)) {
                                CustomBiomeFileLoader.writeFiles(customWorldGenerator);
                                Bukkit.getLogger().info("Successfully installed " + customWorldGenerator.toString() + " configuration files. Please restart your server to activate them.");
                            } else {
                                Bukkit.getLogger().info("Files for " + customWorldGenerator.toString() + " are already detected in the biomes folder. Please remove them first");
                            }
                        } else {
                            Bukkit.getLogger().info(customWorldGenerator.toString() + " is currently not installed on your server. Please install it first.");
                        }
                    } else {
                        List<String> list = CustomWorldGenerator.getAllGenerators();
                        boolean bl = true;
                        String string11 = "";
                        for (String string12 : list) {
                            if (bl) {
                                string11 = string12;
                                bl = false;
                                continue;
                            }
                            string11 = ", " + string11;
                        }
                        Bukkit.getLogger().info("Please choose between " + string11 + "");
                    }
                } else {
                    this.displayConsoleHelp();
                }
            } else if (stringArray.length == 3) {
                if (stringArray[0].equalsIgnoreCase("temperature") && stringArray[1].equalsIgnoreCase("toggle")) {
                    World world = Bukkit.getWorld((String)stringArray[2]);
                    if (world == null) {
                        Bukkit.getLogger().info("ERROR: Invalid world");
                        return true;
                    }
                    if (this.main.getTemperatureManager().getTempData().isEnabledWorld(world)) {
                        Bukkit.getLogger().info("Temperature in this world is now: DISABLED");
                    } else {
                        Bukkit.getLogger().info("Temperature in this world is now: ENABLED");
                    }
                    this.main.getTemperatureManager().getTempData().toggleTemperature(world);
                } else if (stringArray[0].equalsIgnoreCase("set")) {
                    World world = Bukkit.getWorld((String)stringArray[2]);
                    if (world == null) {
                        Bukkit.getLogger().info("ERROR: Invalid world");
                        return true;
                    }
                    if (stringArray[1].equalsIgnoreCase("summer")) {
                        if (!this.setSeason(Season.SUMMER, world)) {
                            Bukkit.getLogger().log(Level.INFO, "You can't have seasons in this type of world!");
                        } else {
                            Bukkit.getLogger().log(Level.INFO, "Manually changed season in this world to: Summer");
                        }
                    } else if (stringArray[1].equalsIgnoreCase("fall")) {
                        if (!this.setSeason(Season.FALL, world)) {
                            Bukkit.getLogger().log(Level.INFO, "You can't have seasons in this type of world!");
                        } else {
                            Bukkit.getLogger().log(Level.INFO, "Manually changed season in this world to: Fall");
                        }
                    } else if (stringArray[1].equalsIgnoreCase("winter")) {
                        if (!this.setSeason(Season.WINTER, world)) {
                            Bukkit.getLogger().log(Level.INFO, "You can't have seasons in this type of world!");
                        } else {
                            Bukkit.getLogger().log(Level.INFO, "Manually changed season in this world to: Winter");
                        }
                    } else if (stringArray[1].equalsIgnoreCase("spring")) {
                        if (!this.setSeason(Season.SPRING, world)) {
                            Bukkit.getLogger().log(Level.INFO, "You can't have seasons in this type of world!");
                        } else {
                            Bukkit.getLogger().log(Level.INFO, "Manually changed season in this world to: Spring");
                        }
                    } else {
                        Bukkit.getLogger().log(Level.INFO, "Please choose between spring, summer, fall and winter");
                    }
                } else if (stringArray[0].equalsIgnoreCase("setdate")) {
                    World world = Bukkit.getWorld((String)stringArray[2]);
                    if (world == null) {
                        Bukkit.getLogger().info("ERROR: Invalid world");
                        return true;
                    }
                    if (stringArray[1].split("/").length != 3) {
                        if (this.main.getSettings().americandateformat) {
                            Bukkit.getLogger().info("Please use the format: mm/dd/yyyy");
                        } else {
                            Bukkit.getLogger().info("Please use the format: dd/mm/yyyy");
                        }
                    } else {
                        boolean bl = true;
                        for (String string13 : stringArray[1].split("/")) {
                            if (JavaUtils.isNumeric(string13)) continue;
                            bl = false;
                        }
                        if (!bl) {
                            if (this.main.getSettings().americandateformat) {
                                Bukkit.getLogger().info("Please use the format: mm/dd/yyyy. Example: 01/05/0001");
                            } else {
                                Bukkit.getLogger().info("Please use the format: dd/mm/yyyy. Example: 01/05/0001");
                            }
                        } else {
                            Date date = Date.fromString(stringArray[1], this.main.getSettings().americandateformat);
                            if (date.getMonth() > this.main.getTimeManager().getCalendar().getTotalMonths()) {
                                Bukkit.getLogger().info("Month can't be more than " + String.valueOf(this.main.getTimeManager().getCalendar().getTotalMonths()));
                            } else if (date.getDay() != 0 && date.getMonth() != 0) {
                                this.main.getTimeManager().setDate(world, date);
                                Bukkit.getLogger().info("Changing date to: " + Date.fromString(stringArray[1], this.main.getSettings().americandateformat).toString(this.main.getSettings().americandateformat));
                            }
                        }
                    }
                } else {
                    if (stringArray[0].equalsIgnoreCase("temperature") && stringArray[1].equalsIgnoreCase("clear")) {
                        String string14 = stringArray[2];
                        if (Bukkit.getPlayer((String)string14) != null) {
                            Player player = Bukkit.getPlayer((String)string14);
                            if (!player.isOnline()) {
                                Bukkit.getLogger().info("Could not find player: " + string14);
                                return true;
                            }
                            this.main.getTemperatureManager().getTempData().clearCustomTemperatureEffects(player);
                            Bukkit.getLogger().info("Removed all custom temperature effects of " + player.getDisplayName());
                        } else {
                            Bukkit.getLogger().info("Could not find player: " + string14);
                        }
                        return true;
                    }
                    this.displayConsoleHelp();
                }
            } else {
                if (stringArray.length == 4) {
                    this.displayConsoleHelp();
                    return true;
                }
                if (stringArray.length == 5) {
                    if (stringArray[0].equalsIgnoreCase("temperature") && stringArray[1].equalsIgnoreCase("modify")) {
                        String string15 = stringArray[2];
                        if (Bukkit.getPlayer((String)string15) != null) {
                            Player player = Bukkit.getPlayer((String)string15);
                            if (!player.isOnline()) {
                                Bukkit.getLogger().info("Could not find player: " + string15);
                                return true;
                            }
                            if (!JavaUtils.isNumeric(stringArray[3])) {
                                Bukkit.getLogger().info("Usage: /rs temperature modify <player> <temperature-change> <duration(s)>");
                                Bukkit.getLogger().info(stringArray[3] + " is not a number.");
                                return true;
                            }
                            if (!stringArray[4].contains("FIXED(")) {
                                if (!JavaUtils.isNumeric(stringArray[4])) {
                                    Bukkit.getLogger().info("Usage: /rs temperature modify <player> <temperature-change> <duration(s)>");
                                    Bukkit.getLogger().info(" is not a number.");
                                    return true;
                                }
                                int n = Integer.parseInt(stringArray[3]);
                                int n12 = Integer.parseInt(stringArray[4]);
                                this.main.getTemperatureManager().getTempData().applyCustomEffect(player, n, n12);
                            } else {
                                int n = Integer.parseInt(stringArray[3]);
                                String[] stringArray3 = stringArray[4].replaceAll("FIXED\\(", "").replaceAll("\\)", "").split(",");
                                int n13 = Integer.valueOf(stringArray3[0]);
                                int n14 = Integer.valueOf(stringArray3[1]);
                                if (this.tempEffects.containsKey(player.getUniqueId())) {
                                    TemperatureEffect temperatureEffect = this.tempEffects.get(player.getUniqueId());
                                    int n15 = temperatureEffect.getModifier();
                                    int n16 = n15 + n;
                                    if (n16 > n14) {
                                        n16 = n14;
                                    }
                                    if (n16 < n13) {
                                        n16 = n13;
                                    }
                                    if (n16 != n15) {
                                        temperatureEffect.cancel();
                                        TemperatureEffect temperatureEffect4 = SeasonsAPI.getInstance().applyPermanentTemperatureEffect(player, n16);
                                        this.tempEffects.put(player.getUniqueId(), temperatureEffect4);
                                    }
                                } else {
                                    if (n > n14) {
                                        n = n14;
                                    }
                                    if (n < n13) {
                                        n = n13;
                                    }
                                    TemperatureEffect temperatureEffect = SeasonsAPI.getInstance().applyPermanentTemperatureEffect(player, n);
                                    this.tempEffects.put(player.getUniqueId(), temperatureEffect);
                                }
                            }
                        } else {
                            Bukkit.getLogger().info("Could not find player: " + string15);
                        }
                    } else {
                        this.displayConsoleHelp();
                    }
                } else {
                    this.displayConsoleHelp();
                }
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void logBiomeRegister() {
        Bukkit.getLogger().info("----------------------------------------------");
        Bukkit.getLogger().info(" ");
        Bukkit.getLogger().info(" Full list of RealisticSeasons biomes: ");
        Bukkit.getLogger().info(" ");
        for (String string : this.main.getNMSUtils().getBiomes(this.main.getSettings().biomeDisplayName)) {
            Bukkit.getLogger().info(string);
        }
        Bukkit.getLogger().info(" ");
        Bukkit.getLogger().info("---------------------------------------");
        Bukkit.getLogger().info(" Biome replacements:");
        ArrayList arrayList = new ArrayList();
        boolean bl = this.main.getSettings().subSeasonsEnabled;
        Season[] seasonArray = new Season[]{Season.SPRING, Season.SUMMER, Season.FALL, Season.WINTER};
        List<String> list = this.main.getNMSUtils().getBiomes("minecraft");
        list.addAll(this.main.getNMSUtils().getCustomBiomes(this.main.getSettings().biomeDisplayName));
        for (String string : list) {
            void object;
            void var7_16;
            Bukkit.getLogger().info("----------------------------------------------");
            Bukkit.getLogger().info(" ");
            Bukkit.getLogger().info("Biome: " + string);
            for (Season season : seasonArray) {
                Bukkit.getLogger().info(" ");
                Bukkit.getLogger().info(season.toString());
                if (season == Season.SUMMER) {
                    if (bl) {
                        arrayList.add(this.main.getNMSUtils().getBiome(BiomeRegister.getMixSummerReplacement(this.main.getNMSUtils().getBiomeID(string), 0)));
                        arrayList.add(this.main.getNMSUtils().getBiome(BiomeRegister.getMixSummerReplacement(this.main.getNMSUtils().getBiomeID(string), 1)));
                        arrayList.add(this.main.getNMSUtils().getBiome(BiomeRegister.getMixSummerReplacement(this.main.getNMSUtils().getBiomeID(string), 2)));
                        arrayList.add(this.main.getNMSUtils().getBiome(BiomeRegister.getMixSummerReplacement(this.main.getNMSUtils().getBiomeID(string), 3)));
                        Bukkit.getLogger().info("Start season: " + this.main.getNMSUtils().getBiome(BiomeRegister.getMixSummerReplacement(this.main.getNMSUtils().getBiomeID(string), 0)));
                        Bukkit.getLogger().info("Early season: " + this.main.getNMSUtils().getBiome(BiomeRegister.getMixSummerReplacement(this.main.getNMSUtils().getBiomeID(string), 1)));
                        Bukkit.getLogger().info("Late season: " + this.main.getNMSUtils().getBiome(BiomeRegister.getMixSummerReplacement(this.main.getNMSUtils().getBiomeID(string), 2)));
                        Bukkit.getLogger().info("End season: " + this.main.getNMSUtils().getBiome(BiomeRegister.getMixSummerReplacement(this.main.getNMSUtils().getBiomeID(string), 3)));
                    }
                    arrayList.add(this.main.getNMSUtils().getBiome(BiomeRegister.getSummerReplacement(this.main.getNMSUtils().getBiomeID(string))));
                    Bukkit.getLogger().info("Mid/Full season: " + this.main.getNMSUtils().getBiome(BiomeRegister.getSummerReplacement(this.main.getNMSUtils().getBiomeID(string))));
                    continue;
                }
                if (season == Season.SPRING) {
                    if (bl) {
                        arrayList.add(this.main.getNMSUtils().getBiome(BiomeRegister.getMixSpringReplacement(this.main.getNMSUtils().getBiomeID(string), 0)));
                        arrayList.add(this.main.getNMSUtils().getBiome(BiomeRegister.getMixSpringReplacement(this.main.getNMSUtils().getBiomeID(string), 1)));
                        arrayList.add(this.main.getNMSUtils().getBiome(BiomeRegister.getMixSpringReplacement(this.main.getNMSUtils().getBiomeID(string), 2)));
                        arrayList.add(this.main.getNMSUtils().getBiome(BiomeRegister.getMixSpringReplacement(this.main.getNMSUtils().getBiomeID(string), 3)));
                        Bukkit.getLogger().info("Start season: " + this.main.getNMSUtils().getBiome(BiomeRegister.getMixSpringReplacement(this.main.getNMSUtils().getBiomeID(string), 0)));
                        Bukkit.getLogger().info("Early season: " + this.main.getNMSUtils().getBiome(BiomeRegister.getMixSpringReplacement(this.main.getNMSUtils().getBiomeID(string), 1)));
                        Bukkit.getLogger().info("Late season: " + this.main.getNMSUtils().getBiome(BiomeRegister.getMixSpringReplacement(this.main.getNMSUtils().getBiomeID(string), 2)));
                        Bukkit.getLogger().info("End season: " + this.main.getNMSUtils().getBiome(BiomeRegister.getMixSpringReplacement(this.main.getNMSUtils().getBiomeID(string), 3)));
                    }
                    arrayList.add(this.main.getNMSUtils().getBiome(BiomeRegister.getSpringReplacement(this.main.getNMSUtils().getBiomeID(string))));
                    Bukkit.getLogger().info("Mid/Full season: " + this.main.getNMSUtils().getBiome(BiomeRegister.getSpringReplacement(this.main.getNMSUtils().getBiomeID(string))));
                    continue;
                }
                if (season == Season.WINTER) {
                    if (bl) {
                        arrayList.add(this.main.getNMSUtils().getBiome(BiomeRegister.getMixWinterReplacement(this.main.getNMSUtils().getBiomeID(string), 0)));
                        arrayList.add(this.main.getNMSUtils().getBiome(BiomeRegister.getMixWinterReplacement(this.main.getNMSUtils().getBiomeID(string), 1)));
                        arrayList.add(this.main.getNMSUtils().getBiome(BiomeRegister.getMixWinterReplacement(this.main.getNMSUtils().getBiomeID(string), 2)));
                        arrayList.add(this.main.getNMSUtils().getBiome(BiomeRegister.getMixWinterReplacement(this.main.getNMSUtils().getBiomeID(string), 3)));
                        Bukkit.getLogger().info("Start season: " + this.main.getNMSUtils().getBiome(BiomeRegister.getMixWinterReplacement(this.main.getNMSUtils().getBiomeID(string), 0)));
                        Bukkit.getLogger().info("Early season: " + this.main.getNMSUtils().getBiome(BiomeRegister.getMixWinterReplacement(this.main.getNMSUtils().getBiomeID(string), 1)));
                        Bukkit.getLogger().info("Late season: " + this.main.getNMSUtils().getBiome(BiomeRegister.getMixWinterReplacement(this.main.getNMSUtils().getBiomeID(string), 2)));
                        Bukkit.getLogger().info("End season: " + this.main.getNMSUtils().getBiome(BiomeRegister.getMixWinterReplacement(this.main.getNMSUtils().getBiomeID(string), 3)));
                    }
                    arrayList.add(this.main.getNMSUtils().getBiome(BiomeRegister.getWinterReplacement(this.main.getNMSUtils().getBiomeID(string))));
                    Bukkit.getLogger().info("Mid/Full season: " + this.main.getNMSUtils().getBiome(BiomeRegister.getWinterReplacement(this.main.getNMSUtils().getBiomeID(string))));
                    continue;
                }
                if (season != Season.FALL) continue;
                if (bl) {
                    arrayList.add(this.main.getNMSUtils().getBiome(BiomeRegister.getMixFallReplacement(this.main.getNMSUtils().getBiomeID(string), 0)));
                    arrayList.add(this.main.getNMSUtils().getBiome(BiomeRegister.getMixFallReplacement(this.main.getNMSUtils().getBiomeID(string), 1)));
                    arrayList.add(this.main.getNMSUtils().getBiome(BiomeRegister.getMixFallReplacement(this.main.getNMSUtils().getBiomeID(string), 2)));
                    arrayList.add(this.main.getNMSUtils().getBiome(BiomeRegister.getMixFallReplacement(this.main.getNMSUtils().getBiomeID(string), 3)));
                    Bukkit.getLogger().info("Start season: " + this.main.getNMSUtils().getBiome(BiomeRegister.getMixFallReplacement(this.main.getNMSUtils().getBiomeID(string), 0)));
                    Bukkit.getLogger().info("Early season: " + this.main.getNMSUtils().getBiome(BiomeRegister.getMixFallReplacement(this.main.getNMSUtils().getBiomeID(string), 1)));
                    Bukkit.getLogger().info("Late season: " + this.main.getNMSUtils().getBiome(BiomeRegister.getMixFallReplacement(this.main.getNMSUtils().getBiomeID(string), 2)));
                    Bukkit.getLogger().info("End season: " + this.main.getNMSUtils().getBiome(BiomeRegister.getMixFallReplacement(this.main.getNMSUtils().getBiomeID(string), 3)));
                }
                List<Integer> list2 = BiomeRegister.getFallReplacements(this.main.getNMSUtils().getBiomeID(string));
                String string2 = null;
                boolean bl2 = true;
                if (list2.size() == 1) {
                    string2 = this.main.getNMSUtils().getBiome(list2.get(0));
                    arrayList.add(string2);
                } else {
                    for (Integer n : list2) {
                        String string3 = this.main.getNMSUtils().getBiome(n);
                        arrayList.add(string3);
                        if (bl2) {
                            string2 = string3;
                            bl2 = false;
                            continue;
                        }
                        string2 = string2 + ", " + string3;
                    }
                }
                Bukkit.getLogger().info("Mid/Full season: " + string2);
            }
            Bukkit.getLogger().info(" ");
            Object var7_10 = null;
            int n = 1;
            if (arrayList.size() == 1) {
                String string4 = (String)arrayList.get(0);
            } else {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    void var7_12;
                    String string5 = (String)iterator.next();
                    if (string5.equals("NONE")) continue;
                    if (n != 0) {
                        String string6 = string5;
                        n = 0;
                        continue;
                    }
                    String string7 = (String)var7_12 + ", " + string5;
                }
            }
            if (var7_16 == null || var7_16 == "") {
                String string8 = "NONE";
            }
            arrayList.clear();
            Bukkit.getLogger().info("All possible replacements for this biome: " + (String)object);
        }
        Bukkit.getLogger().info("----------------------------------------------");
        Bukkit.getLogger().info(" ");
        Bukkit.getLogger().info(" For a better viewing experience, use your server's logs to navigate the list.");
        Bukkit.getLogger().info(" ");
        Bukkit.getLogger().info("----------------------------------------------");
    }

    public void displayHelp(Player player) {
        player.sendMessage(ChatColor.AQUA + "" + ChatColor.BOLD + "Realistic Seasons v" + this.main.getPlugin().getDescription().getVersion());
        player.sendMessage(ChatColor.YELLOW + "Wiki: " + ChatColor.GOLD + "wiki.realisticseasons.com");
        player.sendMessage(ChatColor.YELLOW + "Discord: " + ChatColor.GOLD + "https://discord.gg/tMeXykSNny");
        player.sendMessage(ChatColor.AQUA + "" + ChatColor.UNDERLINE + "Normal commands:");
        player.sendMessage(ChatColor.DARK_GREEN + "/season : " + ChatColor.GREEN + ChatColor.ITALIC + "display current season, year, day and days left until next season");
        player.sendMessage(ChatColor.DARK_GREEN + "/toggleseasoncolors : " + ChatColor.GREEN + ChatColor.ITALIC + "toggle custom biome colors (player running the command only)");
        player.sendMessage(ChatColor.DARK_GREEN + "/toggletemperature (<player>): " + ChatColor.GREEN + ChatColor.ITALIC + "toggle temperature system (player running the command only)");
        player.sendMessage(ChatColor.DARK_GREEN + "/toggleseasonparticles : " + ChatColor.GREEN + ChatColor.ITALIC + "toggle season particles (player running the command only)");
        player.sendMessage(ChatColor.DARK_GREEN + "/togglefahrenheit : " + ChatColor.GREEN + ChatColor.ITALIC + "toggle temperature between Celcius and Fahrenheit (player running the command only)");
        player.sendMessage(ChatColor.AQUA + "" + ChatColor.UNDERLINE + "Admin commands:");
        player.sendMessage(ChatColor.DARK_GREEN + "/rs set <spring/summer/fall/winter> (<world>): " + ChatColor.GREEN + ChatColor.ITALIC + "change the current season in (this) world");
        if (this.main.getSettings().americandateformat) {
            player.sendMessage(ChatColor.DARK_GREEN + "/rs setdate mm/dd/yyyy : " + ChatColor.GREEN + ChatColor.ITALIC + "set the date in the current world");
        } else {
            player.sendMessage(ChatColor.DARK_GREEN + "/rs setdate dd/mm/yyyy : " + ChatColor.GREEN + ChatColor.ITALIC + "set the date in the current world");
        }
        player.sendMessage(ChatColor.DARK_GREEN + "/rs nextseason : " + ChatColor.GREEN + ChatColor.ITALIC + "change the current season in this world to the next one");
        player.sendMessage(ChatColor.DARK_GREEN + "/rs disable : " + ChatColor.GREEN + ChatColor.ITALIC + "disable seasons in this world");
        player.sendMessage(ChatColor.DARK_GREEN + "/rs restoreworld : " + ChatColor.GREEN + ChatColor.ITALIC + "restores all changes done by this plugin in this world");
        player.sendMessage(ChatColor.DARK_GREEN + "/rs getinfo : " + ChatColor.GREEN + ChatColor.ITALIC + "display current season, year, day and days left until next season");
        player.sendMessage(ChatColor.DARK_GREEN + "/rs temperature toggle : " + ChatColor.GREEN + ChatColor.ITALIC + "toggle temperature in the current world. Also works in the nether and the end");
        player.sendMessage(ChatColor.DARK_GREEN + "/rs temperature modify <player> <temperature-change> <duration(s)> : " + ChatColor.GREEN + ChatColor.ITALIC + "apply a temporary temperature change to a specific player. Useful for custom items etc.");
        player.sendMessage(ChatColor.DARK_GREEN + "/rs temperature clear <player> : " + ChatColor.GREEN + ChatColor.ITALIC + "clear all temporary custom temperature effects that were added to a player. Useful for custom items etc.");
        player.sendMessage(ChatColor.DARK_GREEN + "/rs install <generator> : " + ChatColor.GREEN + ChatColor.ITALIC + "install the correct biome files for the specified world generator");
        player.sendMessage(ChatColor.DARK_GREEN + "/rs pausetime : " + ChatColor.GREEN + ChatColor.ITALIC + "temporarily pause/unpause time in the current world");
        player.sendMessage(ChatColor.DARK_GREEN + "/rs reload : " + ChatColor.GREEN + ChatColor.ITALIC + "reload all RealisticSeasons files, except the biome files");
        player.sendMessage(ChatColor.DARK_GREEN + "/rs help : " + ChatColor.GREEN + ChatColor.ITALIC + "display this message");
    }

    public void displayConsoleHelp() {
        Bukkit.getLogger().info("Realistic Seasons v" + this.main.getPlugin().getDescription().getVersion());
        Bukkit.getLogger().info("Wiki: wiki.realisticseasons.com");
        Bukkit.getLogger().info("Discord: https://discord.gg/tMeXykSNny");
        Bukkit.getLogger().info("Normal commands:");
        Bukkit.getLogger().info("/season <world>: display current season, year, day and days left until next season");
        Bukkit.getLogger().info("Admin commands:");
        Bukkit.getLogger().info("/rs set <spring/summer/fall/winter> <world>: change the current season");
        if (this.main.getSettings().americandateformat) {
            Bukkit.getLogger().info("/rs setdate mm/dd/yyyy <world>: set the date");
        } else {
            Bukkit.getLogger().info("/rs setdate dd/mm/yyyy <world>: set the date");
        }
        Bukkit.getLogger().info("/rs nextseason <world>: change the current season to the next one");
        Bukkit.getLogger().info("/rs disable <world>: disable seasons in the specified world");
        Bukkit.getLogger().info("/rs restoreworld <world>: restores all changes done by this plugin");
        Bukkit.getLogger().info("/rs getinfo <world>: display current season, year, day and days left until next season");
        Bukkit.getLogger().info("/rs temperature toggle <world>: toggle temperature. Also works in the nether and the end");
        Bukkit.getLogger().info("/rs temperature modify <player> <temperature-change> <duration(s)> : apply a temporary temperature change to a specific player. Useful for custom items etc.");
        Bukkit.getLogger().info("/rs temperature clear <player> : clear all temporary custom temperature effects that were added to a player. Useful for custom items etc.");
        Bukkit.getLogger().info("/rs install <generator> : install the correct biome files for the specified world generator");
        Bukkit.getLogger().info("/rs pausetime <world>: temporarily pause/unpause time in the specified world");
        Bukkit.getLogger().info("/rs biomelist : Generates a big list of custom biomes that RealisticSeasons uses. Useful for resource packs, creators, etc");
        Bukkit.getLogger().info("/rs reload : reload all RealisticSeasons files, except the biome files");
        Bukkit.getLogger().info("/rs help : display this message");
    }

    public boolean nextSeason(World world) {
        if (this.main.getSeasonManager().getSeason(world) != Season.DISABLED) {
            this.main.getSeasonManager().nextSeason(world);
            return true;
        }
        return false;
    }

    public boolean setSeason(Season season, World world) {
        if (world.getEnvironment() != World.Environment.NETHER && world.getEnvironment() != World.Environment.THE_END) {
            if (this.main.getSettings().subSeasonsEnabled && this.main.getSettings().calendarEnabled && (season == Season.SUMMER || season == Season.WINTER || season == Season.SPRING || season == Season.FALL)) {
                if (this.main.getSeasonManager().getSeason(world) != Season.DISABLED && this.main.getSeasonManager().getSeason(world) != Season.RESTORE) {
                    Date date = this.main.getTimeManager().getHalfwaySeason(season);
                    Date date2 = this.main.getTimeManager().getDate(world);
                    Date date3 = new Date(date.getDay(), date.getMonth(), date2.getYear());
                    if (date3.isLaterInYear(date2)) {
                        date3 = new Date(date.getDay(), date.getMonth(), date2.getYear() + 1);
                    }
                    this.main.getSeasonManager().setSeason(world, season);
                    this.main.getTimeManager().setDate(world, date3);
                } else {
                    Date date = this.main.getTimeManager().getHalfwaySeason(season);
                    Date date4 = new Date(date.getDay(), date.getMonth(), 0);
                    this.main.getSeasonManager().setSeason(world, season);
                    this.main.getTimeManager().setDate(world, date4);
                }
            } else {
                this.main.getSeasonManager().setSeason(world, season);
            }
            return true;
        }
        return false;
    }

    public boolean disable(World world) {
        if (world.getEnvironment() != World.Environment.NETHER && world.getEnvironment() != World.Environment.THE_END) {
            this.main.getSeasonManager().setSeason(world, Season.DISABLED);
            return true;
        }
        return false;
    }

    public boolean hasSeasons(Player player) {
        if (player.getWorld().getEnvironment() != World.Environment.NETHER && player.getWorld().getEnvironment() != World.Environment.THE_END) {
            return true;
        }
        player.sendMessage(ChatColor.RED + "You can't have seasons in this type of world!");
        return false;
    }

    public void reload() {
        this.main.getSettings().reload();
        this.main.getLangManager().reload();
        this.main.getTimeManager().load();
    }

    public void getinfo(Player player) {
        this.main.getSeasonManager().sendSeasonInfo(player);
    }

    public void setByPlayer(Player player, World world, String[] stringArray) {
        if (stringArray[1].equalsIgnoreCase("summer")) {
            if (!this.setSeason(Season.SUMMER, world)) {
                player.sendMessage(ChatColor.RED + "You can't have seasons in this type of world!");
            } else {
                player.sendMessage(ChatColor.GREEN + "Manually changed season in this world to: " + ChatColor.DARK_GREEN + "Summer");
            }
        } else if (stringArray[1].equalsIgnoreCase("fall")) {
            if (!this.setSeason(Season.FALL, world)) {
                player.sendMessage(ChatColor.RED + "You can't have seasons in this type of world!");
            } else {
                player.sendMessage(ChatColor.GREEN + "Manually changed season in this world to: " + ChatColor.DARK_GREEN + "Fall");
            }
        } else if (stringArray[1].equalsIgnoreCase("winter")) {
            if (!this.setSeason(Season.WINTER, world)) {
                player.sendMessage(ChatColor.RED + "You can't have seasons in this type of world!");
            } else {
                player.sendMessage(ChatColor.GREEN + "Manually changed season in this world to: " + ChatColor.DARK_GREEN + "Winter");
            }
        } else if (stringArray[1].equalsIgnoreCase("spring")) {
            if (!this.setSeason(Season.SPRING, world)) {
                player.sendMessage(ChatColor.RED + "You can't have seasons in this type of world!");
            } else {
                player.sendMessage(ChatColor.GREEN + "Manually changed season in this world to: " + ChatColor.DARK_GREEN + "Spring");
            }
        } else {
            player.sendMessage(ChatColor.RED + "Please choose between spring, summer, fall and winter");
        }
    }
}

