/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.api.CustomWorldGenerator;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class RealisticSeasonsTabCompl
implements TabCompleter {
    List<String> results = new ArrayList<String>();
    private RealisticSeasons main;

    public RealisticSeasonsTabCompl(RealisticSeasons realisticSeasons) {
        this.main = realisticSeasons;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (commandSender instanceof Player && !((Player)commandSender).hasPermission("realisticseasons.admin")) {
            this.results.clear();
            return this.results;
        }
        if (stringArray.length == 1) {
            if (command.getLabel().equalsIgnoreCase("rs") || command.getLabel().equalsIgnoreCase("realisticseasons")) {
                this.results.clear();
                this.results.add("set");
                this.results.add("setdate");
                this.results.add("temperature");
                this.results.add("disable");
                this.results.add("getinfo");
                this.results.add("help");
                this.results.add("nextseason");
                this.results.add("restoreworld");
                this.results.add("install");
                this.results.add("pausetime");
                this.results.add("reload");
                return this.sortedResults(stringArray[0]);
            }
        } else if (stringArray.length == 2) {
            if (command.getLabel().equalsIgnoreCase("rs") || command.getLabel().equalsIgnoreCase("realisticseasons")) {
                if (stringArray[0].equalsIgnoreCase("set")) {
                    this.results.clear();
                    this.results.add("summer");
                    this.results.add("winter");
                    this.results.add("spring");
                    this.results.add("fall");
                    return this.sortedResults(stringArray[1]);
                }
                if (stringArray[0].equalsIgnoreCase("setdate")) {
                    if (!this.main.getSettings().americandateformat) {
                        this.results.clear();
                        this.results.add("dd/mm/yyyy");
                        return this.sortedResults(stringArray[1]);
                    }
                    this.results.clear();
                    this.results.add("mm/dd/yyyy");
                    return this.sortedResults(stringArray[1]);
                }
                if (stringArray[0].equalsIgnoreCase("temperature")) {
                    this.results.clear();
                    this.results.add("modify");
                    this.results.add("toggle");
                    this.results.add("clear");
                    return this.sortedResults(stringArray[1]);
                }
                if (stringArray[0].equalsIgnoreCase("install")) {
                    this.results.clear();
                    this.results.addAll(CustomWorldGenerator.getAllGenerators());
                    return this.sortedResults(stringArray[1]);
                }
            }
        } else if (stringArray.length == 3) {
            if (stringArray[0].equalsIgnoreCase("temperature") && (stringArray[1].equals("modify") || stringArray[1].equals("clear"))) {
                this.results.clear();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    this.results.add(player.getName());
                }
                return this.sortedResults(stringArray[2]);
            }
        } else if (stringArray.length == 4) {
            if (stringArray[0].equalsIgnoreCase("temperature") && stringArray[1].equals("modify")) {
                this.results.clear();
                this.results.add("<temperature-change>");
                return this.sortedResults(stringArray[3]);
            }
        } else if (stringArray.length == 5 && stringArray[0].equalsIgnoreCase("temperature") && stringArray[1].equals("modify")) {
            this.results.clear();
            this.results.add("<duration(s)>");
            return this.sortedResults(stringArray[4]);
        }
        this.results.clear();
        return this.sortedResults(stringArray[0]);
    }

    private List<String> sortedResults(String string) {
        ArrayList arrayList = new ArrayList();
        StringUtil.copyPartialMatches((String)string, this.results, arrayList);
        Collections.sort(arrayList);
        this.results.clear();
        for (String string2 : arrayList) {
            this.results.add(string2);
        }
        return this.results;
    }
}

