/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import me.casperge.interfaces.CustomBiome;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.Version;
import me.casperge.realisticseasons.api.SeasonBiome;
import me.casperge.realisticseasons.biome.BiomeRegister;
import me.casperge.realisticseasons.biome.BiomeUtils;
import me.casperge.realisticseasons.data.CustomBiomeData;
import me.casperge.realisticseasons.season.Season;
import me.casperge.realisticseasons.utils.BiomeMappings;
import me.casperge.realisticseasons.utils.ChunkUtils;
import me.casperge.realisticseasons.utils.JavaUtils;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.block.Biome;
import org.bukkit.configuration.file.YamlConfiguration;

public class BiomeFileLoader {
    private List<CustomBiome> created = new ArrayList<CustomBiome>();
    private Season[] seasons = new Season[]{Season.SPRING, Season.FALL, Season.SUMMER, Season.WINTER};
    private String[] filenames = new String[]{"BADLANDS", "JUNGLE", "BEACH", "BIRCH_FOREST", "OCEAN", "DARK_FOREST", "DESERT", "FLOWER_FOREST", "FOREST", "TAIGA", "MOUNTAINS", "MUSHROOM_FIELDS", "PLAINS", "SAVANNA", "RIVER", "FROZEN_BIOMES", "SWAMP", "FROZEN_MOUNTAINS", "CAVES"};
    private HashMap<Season, HashMap<int[], SeasonCustomBiome>> biomes = new HashMap();
    private RealisticSeasons main;
    private BiomeMappings mappings;

    public BiomeFileLoader(RealisticSeasons realisticSeasons) {
        this.main = realisticSeasons;
        this.biomes.put(Season.FALL, new HashMap());
        this.biomes.put(Season.SUMMER, new HashMap());
        this.biomes.put(Season.WINTER, new HashMap());
        this.biomes.put(Season.SPRING, new HashMap());
        this.load();
    }

    public void load() {
        Object object;
        CustomBiomeData customBiomeData;
        this.main.getNMSUtils().changeRegistryLock(false);
        BiomeRegister.kaas = this.main.createSeasonsBiome("plains", "first", "ffff00", "ffff00", "ffff00", "ffff00", "ffff00", "ffff00", false);
        this.created.clear();
        this.mappings = new BiomeMappings(this.main);
        BiomeRegister.fallreplacements.clear();
        BiomeRegister.springreplacements.clear();
        BiomeRegister.summerreplacements.clear();
        BiomeRegister.winterreplacements.clear();
        this.checkDataFolder();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.filenames) {
            CustomBiomeData object2 = this.fromFile(string, false, false);
            if (object2 == null) continue;
            this.loadFile(object2, false, false);
        }
        File file = new File("plugins/RealisticSeasons/biomes/");
        for (File file2 : file.listFiles()) {
            if (!this.isCustomBiomeFile(file2) || (customBiomeData = this.fromFile(file2.getName(), true, false)) == null || (object = customBiomeData.getRelatedConf()) == null || ((String)object).equalsIgnoreCase("NONE") || ((String)object).equalsIgnoreCase("ALL")) continue;
            for (String string : ((String)object).trim().split(",")) {
                arrayList.add(string.trim());
            }
            this.loadFile(customBiomeData, true, false);
        }
        for (File file3 : file.listFiles()) {
            if (!this.isCustomBiomeFile(file3) || !(customBiomeData = YamlConfiguration.loadConfiguration((File)file3)).contains("includes") || !customBiomeData.getString("includes").equalsIgnoreCase("ALL")) continue;
            object = this.fromFile(file3.getName(), true, true);
            for (String string : this.main.getNMSUtils().getCustomBiomes(this.main.getSettings().biomeDisplayName)) {
                try {
                    if (!string.contains(":")) {
                        Bukkit.getLogger().severe("[RealisticSeasons] Could not load biome: " + string + ". Continuing");
                        continue;
                    }
                    if (string.split(":").length != 2) {
                        Bukkit.getLogger().severe("[RealisticSeasons] Could not load biome: " + string + ". Ignoring");
                        continue;
                    }
                    ((CustomBiomeData)object).setBiomeRegName(string.split(":")[1]);
                    ((CustomBiomeData)object).setOriginalBiomeName(string);
                    ((CustomBiomeData)object).setRelatedConf(string);
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    arrayList2.add(string);
                    ((CustomBiomeData)object).relatedbiomescustom = arrayList2;
                    float f = this.main.getNMSUtils().getBiomeTemperature(string);
                    ((CustomBiomeData)object).setTemperatureModifier(BiomeUtils.getSeasonsTemperature(f));
                    if (arrayList.contains(string)) continue;
                    this.loadFile((CustomBiomeData)object, true, true);
                }
                catch (Exception exception) {
                    Bukkit.getLogger().severe("[RealisticSeasons] An error occured loading biome: " + string);
                    exception.printStackTrace();
                }
            }
        }
        this.registerMixedColorBiomes();
        this.main.getNMSUtils().changeRegistryLock(true);
    }

    public CustomBiomeData fromFile(String string, boolean bl, boolean bl2) {
        String string2;
        int n;
        int n2;
        String[] stringArray;
        Object object;
        String string3;
        YamlConfiguration yamlConfiguration;
        File file;
        if (!bl) {
            file = new File(this.main.getDataFolder(), "biomes/" + string + ".yml");
            yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        } else {
            file = new File(this.main.getDataFolder(), "biomes/" + string);
            yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        }
        if (string.equals("FROZEN_BIOMES") || string.equals("FROZEN_MOUNTAINS")) {
            string3 = "SNOWY_TUNDRA";
            if (string.equals("FROZEN_MOUNTAINS") && (!Version.is_1_17_or_up() || Version.version.equals("v1_17_R1"))) {
                return null;
            }
        } else if (string.equals("CAVES")) {
            string3 = "LUSH_CAVES";
            if (!Version.is_1_17_or_up()) {
                return null;
            }
        } else {
            string3 = string;
        }
        CustomBiomeData customBiomeData = new CustomBiomeData();
        customBiomeData.setModifyPlants(yamlConfiguration.getBoolean("modify-plants"));
        customBiomeData.setFreezeInWinter(yamlConfiguration.getBoolean("freeze-in-winter"));
        if (yamlConfiguration.contains("show-snow-particles-in-winter")) {
            boolean bl3 = yamlConfiguration.getBoolean("show-snow-particles-in-winter");
            for (Object object2 : this.seasons) {
                if (object2 == Season.WINTER) {
                    customBiomeData.setDoSnow((Season)((Object)object2), bl3);
                    continue;
                }
                customBiomeData.setDoSnow((Season)((Object)object2), false);
            }
        } else {
            for (Season season : this.seasons) {
                Object object2;
                object2 = season.getConfigName().toLowerCase();
                customBiomeData.setDoSnow(season, yamlConfiguration.getBoolean("show-snow-instead-of-rain." + (String)object2));
            }
        }
        if (bl) {
            customBiomeData.setRelatedConf(yamlConfiguration.getString("includes"));
        }
        customBiomeData.setS(string);
        customBiomeData.setBiomeRegName(customBiomeData.getS());
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl) {
            object = customBiomeData.getRelatedConf();
            if (object == null) {
                return null;
            }
            if (((String)object).equalsIgnoreCase("NONE")) {
                return null;
            }
            stringArray = ((String)object).trim().split(",");
            n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                string2 = stringArray[n];
                arrayList.add(string2.trim());
            }
            string3 = (String)arrayList.get(0);
            if (string3.contains(":")) {
                customBiomeData.setBiomeRegName(string3.split(":")[1]);
            } else {
                customBiomeData.setBiomeRegName(string3);
            }
        } else {
            object = this.main.getNMSUtils().getAssociatedBiomes(string);
            stringArray = object;
            n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                string2 = stringArray[n];
                arrayList.add(this.main.getNMSUtils().getBiomeName((Biome)string2));
            }
        }
        customBiomeData.setOriginalBiomeName(string3);
        customBiomeData.relatedbiomescustom = arrayList;
        if (!yamlConfiguration.contains("temperature-difference")) {
            if (bl) {
                yamlConfiguration.set("temperature-difference", (Object)0);
                customBiomeData.setTemperatureModifier(0);
            } else {
                yamlConfiguration.set("temperature-difference", (Object)BiomeUtils.getDefaultBiomeTemperature(string));
                customBiomeData.setTemperatureModifier(BiomeUtils.getDefaultBiomeTemperature(string));
            }
            try {
                yamlConfiguration.save(file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            customBiomeData.setTemperatureModifier(yamlConfiguration.getInt("temperature-difference"));
        }
        for (Season season : this.seasons) {
            string2 = season.getConfigName().toLowerCase();
            CustomBiomeData.SeasonColorData seasonColorData = new CustomBiomeData.SeasonColorData(customBiomeData);
            seasonColorData.setSkyColor(yamlConfiguration.getString("colors." + string2 + ".skycolor"));
            seasonColorData.setWaterColor(yamlConfiguration.getString("colors." + string2 + ".watercolor"));
            seasonColorData.setWaterFogColor(yamlConfiguration.getString("colors." + string2 + ".waterfogcolor"));
            seasonColorData.setGrassColor(yamlConfiguration.getString("colors." + string2 + ".grasscolor"));
            seasonColorData.setTreeColor(yamlConfiguration.getString("colors." + string2 + ".treecolor"));
            seasonColorData.setFogColor(yamlConfiguration.getString("colors." + string2 + ".fogcolor"));
            customBiomeData.addSeasonColorData(season, seasonColorData);
            if (!yamlConfiguration.contains("water-temperature")) continue;
            customBiomeData.setBiomeWaterTemperatures(season, yamlConfiguration.getInt("water-temperature." + string2));
        }
        return customBiomeData;
    }

    /*
     * WARNING - void declaration
     */
    public void loadFile(CustomBiomeData customBiomeData, boolean bl, boolean bl2) {
        try {
            if (!customBiomeData.getModifyPlants()) {
                for (String string : customBiomeData.relatedbiomescustom) {
                    if (string.contains(":")) {
                        ChunkUtils.affectflora.add(string.split(":")[1]);
                        continue;
                    }
                    ChunkUtils.affectflora.add(string);
                }
            }
            if (!customBiomeData.getFreezeInWinter()) {
                for (String string : customBiomeData.relatedbiomescustom) {
                    if (string.contains(":")) {
                        ChunkUtils.affectinwinter.add(string.split(":")[1]);
                        continue;
                    }
                    ChunkUtils.affectinwinter.add(string);
                }
            }
            for (String string : customBiomeData.relatedbiomescustom) {
                if (string.contains(":")) {
                    this.main.getTemperatureManager().getTempData().addBiomeTemperature(string.split(":")[1], customBiomeData.getTemperatureModifier());
                    if (customBiomeData.getBiomeWaterTemps() == null) continue;
                    this.main.getTemperatureManager().getTempData().addWaterBiomeTemperature(string.split(":")[1], customBiomeData.getBiomeWaterTemps());
                    continue;
                }
                this.main.getTemperatureManager().getTempData().addBiomeTemperature(string, customBiomeData.getTemperatureModifier());
                if (customBiomeData.getBiomeWaterTemps() == null) continue;
                this.main.getTemperatureManager().getTempData().addWaterBiomeTemperature(string, customBiomeData.getBiomeWaterTemps());
            }
            for (Season season : this.seasons) {
                int n;
                String[] stringArray;
                int[] nArray;
                Object object;
                String string;
                Object object2;
                Object object3;
                CustomBiomeData.SeasonColorData seasonColorData = customBiomeData.getSeasonColorData(season);
                if (season != Season.FALL) {
                    if (seasonColorData.getSkyColor().equals("NONE") && seasonColorData.getWaterColor().equals("NONE") && seasonColorData.getWaterFogColor().equals("NONE") && seasonColorData.getGrassColor().equals("NONE") && seasonColorData.getTreeColor().equals("NONE") && seasonColorData.getFogColor().equals("NONE")) {
                        if (!bl) {
                            object3 = this.mappings.getBiomeIDs(customBiomeData.getS());
                        } else {
                            object3 = new int[customBiomeData.relatedbiomescustom.size()];
                            for (int i = 0; i < customBiomeData.relatedbiomescustom.size(); ++i) {
                                object3[i] = this.main.getNMSUtils().getBiomeID(customBiomeData.relatedbiomescustom.get(i));
                            }
                        }
                        for (Object object4 : object3) {
                            if (season == Season.SPRING) {
                                BiomeRegister.springreplacements.put((int)object4, 5555);
                                continue;
                            }
                            if (season == Season.SUMMER) {
                                BiomeRegister.summerreplacements.put((int)object4, 5555);
                                continue;
                            }
                            if (season != Season.WINTER) continue;
                            BiomeRegister.winterreplacements.put((int)object4, 5555);
                        }
                        continue;
                    }
                    object3 = seasonColorData.getSkyColor();
                    object2 = seasonColorData.getWaterColor();
                    String string2 = seasonColorData.getWaterFogColor();
                    String string3 = seasonColorData.getGrassColor();
                    string = seasonColorData.getTreeColor();
                    object = seasonColorData.getFogColor();
                    if (((String)object3).equals("NONE")) {
                        object3 = "";
                    }
                    if (((String)object2).equals("NONE")) {
                        object2 = "";
                    }
                    if (string2.equals("NONE")) {
                        string2 = "";
                    }
                    if (string3.equals("NONE")) {
                        string3 = "";
                    }
                    if (string.equals("NONE")) {
                        string = "";
                    }
                    if (((String)object).equals("NONE")) {
                        object = "";
                    }
                    ((String)object3).replaceAll("\\#", "");
                    ((String)object2).replaceAll("\\#", "");
                    string2.replaceAll("\\#", "");
                    string3.replaceAll("\\#", "");
                    string.replaceAll("\\#", "");
                    ((String)object).replaceAll("\\#", "");
                    boolean bl3 = customBiomeData.isSnow(season);
                    int n2 = bl ? this.main.createSeasonsBiome(customBiomeData.getOriginalBiomeName(), customBiomeData.getOriginalBiomeName().split(":")[0] + "_" + season.getConfigName().toString().toLowerCase() + "_" + customBiomeData.getBiomeRegName().toLowerCase(), (String)object3, (String)object2, string2, string3, string, (String)object, bl3) : this.main.createSeasonsBiome(customBiomeData.getOriginalBiomeName(), season.getConfigName().toString().toLowerCase() + "_" + customBiomeData.getBiomeRegName().toLowerCase(), (String)object3, (String)object2, string2, string3, string, (String)object, bl3);
                    if (!bl) {
                        nArray = this.mappings.getBiomeIDs(customBiomeData.getS());
                        stringArray = this.mappings.getBiomeNames(customBiomeData.getS());
                    } else {
                        nArray = new int[customBiomeData.relatedbiomescustom.size()];
                        stringArray = new String[customBiomeData.relatedbiomescustom.size()];
                        boolean i = false;
                        while (i < customBiomeData.relatedbiomescustom.size()) {
                            nArray[i] = this.main.getNMSUtils().getBiomeID(customBiomeData.relatedbiomescustom.get((int)i));
                            stringArray[i] = customBiomeData.relatedbiomescustom.get((int)i);
                            ++i;
                        }
                    }
                    if (bl) {
                        this.biomes.get((Object)season).put(nArray, new SeasonCustomBiome(customBiomeData.getOriginalBiomeName(), customBiomeData.getOriginalBiomeName().split(":")[0] + "_" + season.getConfigName().toString().toLowerCase() + "_" + customBiomeData.getBiomeRegName().toLowerCase(), (String)object3, (String)object2, string2, string3, string, (String)object, bl3, season));
                    } else {
                        this.biomes.get((Object)season).put(nArray, new SeasonCustomBiome(customBiomeData.getOriginalBiomeName(), season.getConfigName().toString().toLowerCase() + "_" + customBiomeData.getBiomeRegName().toLowerCase(), (String)object3, (String)object2, string2, string3, string, (String)object, bl3, season));
                    }
                    for (int n3 : nArray) {
                        if (season == Season.SPRING) {
                            BiomeRegister.springreplacements.put(n3, n2);
                            continue;
                        }
                        if (season == Season.SUMMER) {
                            BiomeRegister.summerreplacements.put(n3, n2);
                            continue;
                        }
                        if (season != Season.WINTER) continue;
                        BiomeRegister.winterreplacements.put(n3, n2);
                        if (!customBiomeData.isSnow(season)) continue;
                        BiomeRegister.frozeninwinter.add(n3);
                    }
                    String[] stringArray2 = stringArray;
                    int n4 = stringArray2.length;
                    for (n = 0; n < n4; ++n) {
                        String string4 = stringArray2[n];
                        this.main.addSeasonBiomeForAPI(string4, new SeasonBiome(season, customBiomeData.getOriginalBiomeName(), (String)object, (String)object2, string2, (String)object3, string3, string));
                    }
                    continue;
                }
                if (seasonColorData.getSkyColor().equals("NONE") && seasonColorData.getWaterColor().equals("NONE") && seasonColorData.getWaterFogColor().equals("NONE") && seasonColorData.getGrassColor().equals("NONE") && seasonColorData.getTreeColor().equals("NONE") && seasonColorData.getFogColor().equals("NONE")) {
                    if (!bl) {
                        object3 = this.mappings.getBiomeIDs(customBiomeData.getS());
                    } else {
                        object3 = new int[customBiomeData.relatedbiomescustom.size()];
                        for (int i = 0; i < customBiomeData.relatedbiomescustom.size(); ++i) {
                            object3[i] = this.main.getNMSUtils().getBiomeID(customBiomeData.relatedbiomescustom.get(i));
                        }
                    }
                    for (Object object5 : object3) {
                        object = new ArrayList();
                        object.add(5555);
                        BiomeRegister.fallreplacements.put((int)object5, (List<Integer>)object);
                    }
                    continue;
                }
                object3 = seasonColorData.getSkyColor();
                object2 = seasonColorData.getWaterColor();
                String string4 = seasonColorData.getWaterFogColor();
                String string5 = seasonColorData.getGrassColor();
                string = seasonColorData.getTreeColor();
                object = seasonColorData.getFogColor();
                if (((String)object3).equals("NONE")) {
                    object3 = "";
                }
                if (((String)object2).equals("NONE")) {
                    object2 = "";
                }
                if (string4.equals("NONE")) {
                    string4 = "";
                }
                if (string5.equals("NONE")) {
                    string5 = "";
                }
                if (string.equals("NONE")) {
                    string = "";
                }
                if (((String)object).equals("NONE")) {
                    object = "";
                }
                ((String)object3).replaceAll("\\#", "");
                ((String)object2).replaceAll("\\#", "");
                string4.replaceAll("\\#", "");
                string5.replaceAll("\\#", "");
                string.replaceAll("\\#", "");
                ((String)object).replaceAll("\\#", "");
                if (string.contains(",")) {
                    int n5;
                    String[] stringArray2 = string.split(",");
                    if (stringArray2.length != 5) {
                        Bukkit.getLogger().severe("[RealisticSeasons] Could not load file: " + customBiomeData.getS() + ". Fall tree colors should either be 1 color or 5 colors");
                        continue;
                    }
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    for (int i = 0; i < stringArray2.length; ++i) {
                        int n6 = !bl ? this.main.createSeasonsBiome(customBiomeData.getOriginalBiomeName(), season.getConfigName().toLowerCase() + "_" + customBiomeData.getBiomeRegName().toLowerCase() + String.valueOf(i), (String)object3, (String)object2, string4, string5, stringArray2[i].trim(), (String)object, customBiomeData.isSnow(season)) : this.main.createSeasonsBiome(customBiomeData.getOriginalBiomeName(), customBiomeData.getOriginalBiomeName().split(":")[0] + season.getConfigName().toLowerCase() + "_" + customBiomeData.getBiomeRegName().toLowerCase() + String.valueOf(i), (String)object3, (String)object2, string4, string5, stringArray2[i].trim(), (String)object, customBiomeData.isSnow(season));
                        arrayList.add(n6);
                    }
                    if (!bl) {
                        nArray = this.mappings.getBiomeIDs(customBiomeData.getS());
                        stringArray = this.mappings.getBiomeNames(customBiomeData.getS());
                    } else {
                        void var19_44;
                        nArray = new int[customBiomeData.relatedbiomescustom.size()];
                        stringArray = new String[customBiomeData.relatedbiomescustom.size()];
                        boolean bl3 = false;
                        while (var19_44 < customBiomeData.relatedbiomescustom.size()) {
                            nArray[var19_44] = this.main.getNMSUtils().getBiomeID(customBiomeData.relatedbiomescustom.get((int)var19_44));
                            stringArray[var19_44] = customBiomeData.relatedbiomescustom.get((int)var19_44);
                            ++var19_44;
                        }
                    }
                    int[] nArray2 = nArray;
                    int n7 = nArray2.length;
                    for (n = 0; n < n7; ++n) {
                        n5 = nArray2[n];
                        BiomeRegister.fallreplacements.put(n5, arrayList);
                    }
                    if (!bl) {
                        this.biomes.get((Object)Season.FALL).put(nArray, new SeasonCustomBiome(customBiomeData.getOriginalBiomeName(), season.getConfigName().toLowerCase() + "_" + customBiomeData.getBiomeRegName().toLowerCase(), (String)object3, (String)object2, string4, string5, stringArray2[0].trim(), (String)object, customBiomeData.isSnow(season), Season.FALL));
                    } else {
                        this.biomes.get((Object)Season.FALL).put(nArray, new SeasonCustomBiome(customBiomeData.getOriginalBiomeName(), customBiomeData.getOriginalBiomeName().split(":")[0] + season.getConfigName().toLowerCase() + "_" + customBiomeData.getBiomeRegName().toLowerCase(), (String)object3, (String)object2, string4, string5, stringArray2[0].trim(), (String)object, customBiomeData.isSnow(season), Season.FALL));
                    }
                    String[] stringArray3 = new String[stringArray2.length];
                    for (n7 = 0; n7 < stringArray2.length; ++n7) {
                        stringArray3[n7] = stringArray2[n7].trim();
                    }
                    String[] stringArray4 = stringArray;
                    n = stringArray4.length;
                    for (n5 = 0; n5 < n; ++n5) {
                        String string6 = stringArray4[n5];
                        this.main.addSeasonBiomeForAPI(string6, new SeasonBiome(Season.FALL, customBiomeData.getOriginalBiomeName(), (String)object, (String)object2, string4, (String)object3, string5, stringArray3));
                    }
                    continue;
                }
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                int n8 = !bl ? this.main.createSeasonsBiome(customBiomeData.getOriginalBiomeName(), season.getConfigName().toString().toLowerCase() + "_" + customBiomeData.getBiomeRegName().toLowerCase(), (String)object3, (String)object2, string4, string5, string, (String)object, customBiomeData.isSnow(season)) : this.main.createSeasonsBiome(customBiomeData.getOriginalBiomeName(), customBiomeData.getOriginalBiomeName().split(":")[0] + "_" + season.getConfigName().toString().toLowerCase() + "_" + customBiomeData.getBiomeRegName().toLowerCase(), (String)object3, (String)object2, string4, string5, string, (String)object, customBiomeData.isSnow(season));
                arrayList.add(n8);
                if (!bl) {
                    nArray = this.mappings.getBiomeIDs(customBiomeData.getS());
                    stringArray = this.mappings.getBiomeNames(customBiomeData.getS());
                } else {
                    void var19_48;
                    nArray = new int[customBiomeData.relatedbiomescustom.size()];
                    stringArray = new String[customBiomeData.relatedbiomescustom.size()];
                    boolean bl4 = false;
                    while (var19_48 < customBiomeData.relatedbiomescustom.size()) {
                        nArray[var19_48] = this.main.getNMSUtils().getBiomeID(customBiomeData.relatedbiomescustom.get((int)var19_48));
                        stringArray[var19_48] = customBiomeData.relatedbiomescustom.get((int)var19_48);
                        ++var19_48;
                    }
                }
                for (int n9 : nArray) {
                    BiomeRegister.fallreplacements.put(n9, arrayList);
                }
                if (!bl) {
                    this.biomes.get((Object)Season.FALL).put(nArray, new SeasonCustomBiome(customBiomeData.getOriginalBiomeName(), season.getConfigName().toString().toLowerCase() + "_" + customBiomeData.getBiomeRegName().toLowerCase(), (String)object3, (String)object2, string4, string5, string, (String)object, customBiomeData.isSnow(season), Season.FALL));
                } else {
                    this.biomes.get((Object)Season.FALL).put(nArray, new SeasonCustomBiome(customBiomeData.getOriginalBiomeName(), customBiomeData.getOriginalBiomeName().split(":")[0] + "_" + season.getConfigName().toString().toLowerCase() + "_" + customBiomeData.getBiomeRegName().toLowerCase(), (String)object3, (String)object2, string4, string5, string, (String)object, customBiomeData.isSnow(season), Season.FALL));
                }
                String[] stringArray5 = stringArray;
                int n10 = stringArray5.length;
                for (n = 0; n < n10; ++n) {
                    String string7 = stringArray5[n];
                    this.main.addSeasonBiomeForAPI(string7, new SeasonBiome(Season.FALL, customBiomeData.getOriginalBiomeName(), (String)object, (String)object2, string4, (String)object3, string5, string));
                }
            }
        }
        catch (Exception exception) {
            Bukkit.getLogger().severe("Could not load file: " + customBiomeData.getS());
            exception.printStackTrace();
        }
    }

    public void registerMixedColorBiomes() {
        double[] dArray = new double[]{0.45, 0.25, 0.25, 0.45};
        for (Season season : this.seasons) {
            for (int[] nArray : this.biomes.get((Object)season).keySet()) {
                for (int i = 0; i < 4; ++i) {
                    HashMap<Integer, Integer> hashMap;
                    SeasonCustomBiome seasonCustomBiome = this.biomes.get((Object)season).get(nArray);
                    int[] nArray2 = this.main.getNMSUtils().getBiomeColors(seasonCustomBiome.getOriginalBiomeName());
                    String[] stringArray = new String[nArray2.length];
                    for (int j = 0; j < nArray2.length; ++j) {
                        if (nArray2[j] == -9999999) {
                            if (j == 4) {
                                stringArray[j] = BiomeMappings.getGrassHex(seasonCustomBiome.getOriginalBiomeName());
                                continue;
                            }
                            if (j != 5) continue;
                            stringArray[j] = BiomeMappings.getFoliageColor(seasonCustomBiome.getOriginalBiomeName());
                            continue;
                        }
                        stringArray[j] = JavaUtils.decimalToHex(nArray2[j]);
                    }
                    double d2 = dArray[i];
                    SeasonCustomBiome seasonCustomBiome2 = i <= 1 ? this.findMatchingBiome(nArray, season.getPreviousSeason()) : this.findMatchingBiome(nArray, season.getNextSeason());
                    String string = "";
                    String string2 = "";
                    String string3 = "";
                    String string4 = "";
                    String string5 = "";
                    String string6 = "";
                    if (stringArray[4].equals("CUSTOM")) {
                        stringArray[4] = "91bd59";
                    }
                    if (stringArray[5].equals("CUSTOM")) {
                        stringArray[5] = "91bd59";
                    }
                    if (seasonCustomBiome2 == null) {
                        if (seasonCustomBiome.getSkyColor() != "") {
                            string = JavaUtils.mixColor(stringArray[3], seasonCustomBiome.getSkyColor(), d2);
                        }
                        if (seasonCustomBiome.getWaterColor() != "") {
                            string2 = JavaUtils.mixColor(stringArray[1], seasonCustomBiome.getWaterColor(), d2);
                        }
                        if (seasonCustomBiome.getWaterFogColor() != "") {
                            string3 = JavaUtils.mixColor(stringArray[2], seasonCustomBiome.getWaterFogColor(), d2);
                        }
                        if (seasonCustomBiome.getGrassColor() != "") {
                            string4 = JavaUtils.mixColor(stringArray[4], seasonCustomBiome.getGrassColor(), d2);
                        }
                        if (seasonCustomBiome.getTreeColor() != "") {
                            string5 = JavaUtils.mixColor(stringArray[5], seasonCustomBiome.getTreeColor(), d2);
                        }
                        if (seasonCustomBiome.getFogColor() != "") {
                            string6 = JavaUtils.mixColor(stringArray[0], seasonCustomBiome.getFogColor(), d2);
                        }
                    } else {
                        if (seasonCustomBiome.getSkyColor() != "") {
                            string = seasonCustomBiome2.getSkyColor() == "" ? JavaUtils.mixColor(stringArray[3], seasonCustomBiome.getSkyColor(), d2) : JavaUtils.mixColor(seasonCustomBiome2.getSkyColor(), seasonCustomBiome.getSkyColor(), d2);
                        }
                        if (seasonCustomBiome.getWaterColor() != "") {
                            string2 = seasonCustomBiome2.getWaterColor() == "" ? JavaUtils.mixColor(stringArray[1], seasonCustomBiome.getWaterColor(), d2) : JavaUtils.mixColor(seasonCustomBiome2.getWaterColor(), seasonCustomBiome.getWaterColor(), d2);
                        }
                        if (seasonCustomBiome.getWaterFogColor() != "") {
                            string3 = seasonCustomBiome2.getWaterFogColor() == "" ? JavaUtils.mixColor(stringArray[2], seasonCustomBiome.getWaterFogColor(), d2) : JavaUtils.mixColor(seasonCustomBiome2.getWaterFogColor(), seasonCustomBiome.getWaterFogColor(), d2);
                        }
                        if (seasonCustomBiome.getGrassColor() != "") {
                            string4 = seasonCustomBiome2.getGrassColor() == "" ? JavaUtils.mixColor(stringArray[4], seasonCustomBiome.getGrassColor(), d2) : JavaUtils.mixColor(seasonCustomBiome2.getGrassColor(), seasonCustomBiome.getGrassColor(), d2);
                        }
                        if (seasonCustomBiome.getTreeColor() != "") {
                            string5 = seasonCustomBiome2.getTreeColor() == "" ? JavaUtils.mixColor(stringArray[5], seasonCustomBiome.getTreeColor(), d2) : JavaUtils.mixColor(seasonCustomBiome2.getTreeColor(), seasonCustomBiome.getTreeColor(), d2);
                        }
                        if (seasonCustomBiome.getFogColor() != "") {
                            string6 = seasonCustomBiome2.getFogColor() == "" ? JavaUtils.mixColor(stringArray[0], seasonCustomBiome.getFogColor(), d2) : JavaUtils.mixColor(seasonCustomBiome2.getFogColor(), seasonCustomBiome.getFogColor(), d2);
                        }
                    }
                    if (!string5.equals("")) {
                        if (seasonCustomBiome.getSeason() == Season.SUMMER) {
                            if (i < 2) {
                                if (!this.main.getSettings().SpringSummerAdjustment.equals("")) {
                                    string5 = JavaUtils.mixColor(this.main.getSettings().SpringSummerAdjustment, string5, this.main.getSettings().SpringSummerWeight);
                                }
                            } else if (!this.main.getSettings().SummerFallAdjustment.equals("")) {
                                string5 = JavaUtils.mixColor(this.main.getSettings().SummerFallAdjustment, string5, this.main.getSettings().SummerFallWeight);
                            }
                        } else if (seasonCustomBiome.getSeason() == Season.FALL) {
                            if (i < 2) {
                                if (!this.main.getSettings().SummerFallAdjustment.equals("")) {
                                    string5 = JavaUtils.mixColor(this.main.getSettings().SummerFallAdjustment, string5, this.main.getSettings().SummerFallWeight);
                                }
                            } else if (!this.main.getSettings().FallWinterAdjustment.equals("")) {
                                string5 = JavaUtils.mixColor(this.main.getSettings().FallWinterAdjustment, string5, this.main.getSettings().FallWinterWeight);
                            }
                        } else if (seasonCustomBiome.getSeason() == Season.WINTER) {
                            if (i < 2) {
                                if (!this.main.getSettings().FallWinterAdjustment.equals("")) {
                                    string5 = JavaUtils.mixColor(this.main.getSettings().FallWinterAdjustment, string5, this.main.getSettings().FallWinterWeight);
                                }
                            } else if (!this.main.getSettings().WinterSpringAdjustment.equals("")) {
                                string5 = JavaUtils.mixColor(this.main.getSettings().WinterSpringAdjustment, string5, this.main.getSettings().WinterSpringWeight);
                            }
                        }
                        if (seasonCustomBiome.getSeason() == Season.SPRING) {
                            if (i < 2) {
                                if (!this.main.getSettings().WinterSpringAdjustment.equals("")) {
                                    string5 = JavaUtils.mixColor(this.main.getSettings().WinterSpringAdjustment, string5, this.main.getSettings().WinterSpringWeight);
                                }
                            } else if (!this.main.getSettings().SpringSummerAdjustment.equals("")) {
                                string5 = JavaUtils.mixColor(this.main.getSettings().SpringSummerAdjustment, string5, this.main.getSettings().SpringSummerWeight);
                            }
                        }
                    }
                    int n = this.main.createSeasonsBiome(seasonCustomBiome.getOriginalBiomeName(), seasonCustomBiome.getName() + "_blend" + String.valueOf(i), string, string2, string3, string4, string5, string6, seasonCustomBiome.isCold());
                    if (seasonCustomBiome.getSeason() == Season.WINTER) {
                        if (!BiomeRegister.mixwinterreplacements.containsKey(i)) {
                            BiomeRegister.mixwinterreplacements.put(i, new HashMap());
                        }
                        hashMap = BiomeRegister.mixwinterreplacements.get(i);
                        for (int n2 : nArray) {
                            hashMap.put(n2, n);
                        }
                        BiomeRegister.mixwinterreplacements.put(i, hashMap);
                        continue;
                    }
                    if (seasonCustomBiome.getSeason() == Season.SPRING) {
                        if (!BiomeRegister.mixspringreplacements.containsKey(i)) {
                            BiomeRegister.mixspringreplacements.put(i, new HashMap());
                        }
                        hashMap = BiomeRegister.mixspringreplacements.get(i);
                        for (int n2 : nArray) {
                            hashMap.put(n2, n);
                        }
                        BiomeRegister.mixspringreplacements.put(i, hashMap);
                        continue;
                    }
                    if (seasonCustomBiome.getSeason() == Season.SUMMER) {
                        if (!BiomeRegister.mixsummerreplacements.containsKey(i)) {
                            BiomeRegister.mixsummerreplacements.put(i, new HashMap());
                        }
                        hashMap = BiomeRegister.mixsummerreplacements.get(i);
                        for (int n2 : nArray) {
                            hashMap.put(n2, n);
                        }
                        BiomeRegister.mixsummerreplacements.put(i, hashMap);
                        continue;
                    }
                    if (seasonCustomBiome.getSeason() != Season.FALL) continue;
                    if (!BiomeRegister.mixfallreplacements.containsKey(i)) {
                        BiomeRegister.mixfallreplacements.put(i, new HashMap());
                    }
                    hashMap = BiomeRegister.mixfallreplacements.get(i);
                    for (int n2 : nArray) {
                        hashMap.put(n2, n);
                    }
                    BiomeRegister.mixfallreplacements.put(i, hashMap);
                }
            }
        }
    }

    private SeasonCustomBiome findMatchingBiome(int[] nArray, Season season) {
        HashMap<int[], SeasonCustomBiome> hashMap = this.biomes.get((Object)season);
        for (int[] nArray2 : hashMap.keySet()) {
            if (!Arrays.equals(nArray2, nArray)) continue;
            return hashMap.get(nArray2);
        }
        return null;
    }

    public void checkDataFolder() {
        File file = new File(this.main.getDataFolder(), "biomes/");
        if (!file.isDirectory()) {
            file.mkdir();
        }
        for (String string : this.filenames) {
            try {
                File file2 = new File(this.main.getDataFolder(), "biomes/" + string + ".yml");
                if (file2.exists()) continue;
                InputStream inputStream = this.main.getResource(string + ".yml");
                FileUtils.copyInputStreamToFile(inputStream, file2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        try {
            File file3 = new File(this.main.getDataFolder(), "biomes/CUSTOM_EXAMPLE.yml");
            if (!file3.exists()) {
                InputStream inputStream = this.main.getResource("CUSTOM_EXAMPLE.yml");
                FileUtils.copyInputStreamToFile(inputStream, file3);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean isCustomBiomeFile(File file) {
        boolean bl = true;
        for (String string : this.filenames) {
            if (!file.getName().equals(string + ".yml")) continue;
            bl = false;
        }
        return bl;
    }

    class SeasonCustomBiome {
        String originalBiomeName;
        String name;
        String skyColor;
        String waterColor;
        String waterFogColor;
        String grassColor;
        String treeColor;
        String fogColor;
        boolean isCold;
        Season s;

        public String getOriginalBiomeName() {
            return this.originalBiomeName;
        }

        public String getName() {
            return this.name;
        }

        public String getSkyColor() {
            return this.skyColor;
        }

        public String getWaterColor() {
            return this.waterColor;
        }

        public String getWaterFogColor() {
            return this.waterFogColor;
        }

        public String getGrassColor() {
            return this.grassColor;
        }

        public String getTreeColor() {
            return this.treeColor;
        }

        public String getFogColor() {
            return this.fogColor;
        }

        public boolean isCold() {
            return this.isCold;
        }

        public Season getSeason() {
            return this.s;
        }

        public SeasonCustomBiome(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, Season season) {
            this.originalBiomeName = string;
            this.name = string2;
            this.skyColor = string3;
            this.waterColor = string4;
            this.waterFogColor = string5;
            this.grassColor = string6;
            this.treeColor = string7;
            this.fogColor = string8;
            this.isCold = bl;
            this.s = season;
        }
    }
}

