/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.particle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.blockscanner.SimpleLocation;
import me.casperge.realisticseasons.particle.ParticleSpawner;
import me.casperge.realisticseasons.particle.entity.FallingLeaf;
import me.casperge.realisticseasons.particle.entity.FireFlies;
import me.casperge.realisticseasons.particle.entity.Meteorite;
import me.casperge.realisticseasons.particle.entity.SeasonEntity;
import me.casperge.realisticseasons.particle.entity.SmallFallingLeaf;
import me.casperge.realisticseasons.utils.JavaUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class ParticleManager {
    private Random r = new Random();
    private RealisticSeasons main;
    public HashMap<UUID, List<SimpleLocation>> leaveLocations = new HashMap();
    private ParticleSpawner spawner;
    private Vector wind;
    public static List<UUID> disabledParticles = new ArrayList<UUID>();
    int test = 0;
    private HashMap<SeasonEntity, List<Player>> activeEntities = new HashMap();
    int counter = 0;

    public ParticleManager(RealisticSeasons realisticSeasons) {
        this.main = realisticSeasons;
        this.wind = new Vector(JavaUtils.getRandom().nextDouble() / 2.0, 0.0, JavaUtils.getRandom().nextDouble() / 2.0);
        this.spawner = new ParticleSpawner(realisticSeasons, this);
        this.spawner.runTaskTimer((Plugin)realisticSeasons, 2L, 2L);
        Bukkit.getScheduler().runTaskTimer((Plugin)realisticSeasons, new Runnable(){

            @Override
            public void run() {
                ArrayList<SeasonEntity> arrayList = new ArrayList<SeasonEntity>();
                for (SeasonEntity seasonEntity : ParticleManager.this.activeEntities.keySet()) {
                    if (seasonEntity.isDestroyed()) {
                        arrayList.add(seasonEntity);
                        continue;
                    }
                    seasonEntity.tick((List)ParticleManager.this.activeEntities.get(seasonEntity));
                }
                for (SeasonEntity seasonEntity : arrayList) {
                    ParticleManager.this.activeEntities.remove(seasonEntity);
                }
                ++ParticleManager.this.counter;
            }
        }, 2L, 2L);
    }

    public void runTest(Location location, Player player) {
        this.spawnFireFlies(location);
    }

    public void spawnFireFlies(Location location) {
        this.spawnEntity(SeasonEntityType.FIREFLIES, null, location);
    }

    public void spawnSmallFallingLeaves(List<Player> list, Location location) {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        for (Player player : list) {
            if (!disabledParticles.contains(player.getUniqueId())) continue;
            arrayList.add(player);
        }
        list.removeAll(arrayList);
        this.spawnEntity(SeasonEntityType.SMALL_FALLING_LEAVES, list, location);
    }

    public SeasonEntity spawnEntity(SeasonEntityType seasonEntityType, List<Player> list, Location location) {
        switch (seasonEntityType) {
            case METEORITE: {
                Meteorite meteorite = new Meteorite(location, list);
                this.activeEntities.put(meteorite, list);
                return meteorite;
            }
            case FALLING_LEAF: {
                FallingLeaf fallingLeaf = new FallingLeaf(location, list, this.wind, this.main.getSettings().fallingLeafItem, this.main.getSettings().fallingLeafCMD);
                this.activeEntities.put(fallingLeaf, list);
                return fallingLeaf;
            }
            case SMALL_FALLING_LEAVES: {
                SmallFallingLeaf smallFallingLeaf = new SmallFallingLeaf(location, list);
                this.activeEntities.put(smallFallingLeaf, list);
                return smallFallingLeaf;
            }
            case FIREFLIES: {
                FireFlies fireFlies = new FireFlies(location);
                this.activeEntities.put(fireFlies, null);
                return fireFlies;
            }
        }
        return null;
    }

    public void playWhiteSparkles(Player player) {
        if (disabledParticles.contains(player.getUniqueId())) {
            return;
        }
        player.spawnParticle(Particle.END_ROD, player.getLocation().getX(), player.getLocation().getY() + (double)this.main.getSettings().nightSparksHeight, player.getLocation().getZ(), this.main.getSettings().nightSparksHeight, 50.0, 16.0, 50.0, 0.0);
    }

    public void spawnMeteorite(List<Player> list, Location location) {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        for (Player player : list) {
            if (!disabledParticles.contains(player.getUniqueId())) continue;
            arrayList.add(player);
        }
        list.removeAll(arrayList);
        this.spawnEntity(SeasonEntityType.METEORITE, list, location);
    }

    public void spawnLeaf(List<Player> list, Location location) {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        for (Player player : list) {
            if (!disabledParticles.contains(player.getUniqueId())) continue;
            arrayList.add(player);
        }
        list.removeAll(arrayList);
        this.spawnEntity(SeasonEntityType.FALLING_LEAF, list, location);
    }

    public void playRandomSweatParticle(Player player) {
        double d2 = JavaUtils.randomDouble(0.35, 0.65);
        double d3 = JavaUtils.randomDouble(0.35, 0.65);
        double d4 = this.r.nextInt(2) == 1 ? this.r.nextDouble() : this.r.nextDouble() * 0.6 + 1.0;
        Location location = new Location(player.getWorld(), player.getLocation().getX() + (d2 / 2.0 - d2) + 0.5, player.getLocation().getY() + d4, player.getLocation().getZ() + (d3 / 2.0 - d3) + 0.5);
        ArrayList<Player> arrayList = new ArrayList<Player>();
        for (Player player2 : player.getWorld().getPlayers()) {
            if (!(player2.getLocation().distance(location) < 18.0) || !player2.canSee(player) || disabledParticles.contains(player2.getUniqueId())) continue;
            arrayList.add(player2);
        }
        player.spawnParticle(Particle.FALLING_WATER, location, 1);
    }

    public void playColdBreathEffect(final Player player) {
        this.playBreathOnce(player);
        Bukkit.getScheduler().runTaskLater((Plugin)this.main, new Runnable(){

            @Override
            public void run() {
                ParticleManager.this.playBreathOnce(player);
                Bukkit.getScheduler().runTaskLater((Plugin)ParticleManager.this.main, new Runnable(){

                    @Override
                    public void run() {
                        ParticleManager.this.playBreathOnce(player);
                    }
                }, 3L);
            }
        }, 5L);
    }

    private void playBreathOnce(Player player) {
        final Location location = player.getEyeLocation().clone();
        final Vector vector = location.getDirection().clone().multiply(0.1);
        location.add(vector);
        location.add(vector);
        Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)255, (int)255, (int)255), 1.0f);
        final Particle.DustOptions dustOptions2 = new Particle.DustOptions(Color.fromRGB((int)255, (int)255, (int)255), 1.4f);
        final Particle.DustOptions dustOptions3 = new Particle.DustOptions(Color.fromRGB((int)255, (int)255, (int)255), 1.8f);
        final ArrayList<Player> arrayList = new ArrayList<Player>();
        for (Player player2 : player.getWorld().getPlayers()) {
            if (!(player2.getLocation().distance(player.getLocation()) < 17.0) || !player2.canSee(player) || this.main.getSettings().coldBreathHideOwn && player2 == player || disabledParticles.contains(player.getUniqueId())) continue;
            player2.spawnParticle(Particle.REDSTONE, location.getX(), location.getY() - 0.3, location.getZ(), 0, vector.getX(), vector.getY(), vector.getZ(), 0.1, (Object)dustOptions);
            arrayList.add(player2);
        }
        location.add(vector);
        Bukkit.getScheduler().runTaskLater((Plugin)this.main, new Runnable(){

            @Override
            public void run() {
                for (Player player : arrayList) {
                    player.spawnParticle(Particle.REDSTONE, location.getX(), location.getY() - 0.3, location.getZ(), 0, vector.getX(), vector.getY(), vector.getZ(), 0.1, (Object)dustOptions2);
                }
                location.add(vector);
                Bukkit.getScheduler().runTaskLater((Plugin)ParticleManager.this.main, new Runnable(){

                    @Override
                    public void run() {
                        for (Player player : arrayList) {
                            player.spawnParticle(Particle.REDSTONE, location.getX(), location.getY() - 0.3, location.getZ(), 0, vector.getX(), vector.getY(), vector.getZ(), 0.1, (Object)dustOptions3);
                        }
                    }
                }, 2L);
            }
        }, 2L);
    }

    public static enum SeasonEntityType {
        METEORITE,
        FALLING_LEAF,
        SMALL_FALLING_LEAVES,
        FIREFLIES;

    }
}

