/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.runnables;

import java.util.Random;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.season.Season;
import me.casperge.realisticseasons.season.SeasonChunk;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.scheduler.BukkitRunnable;

public class SpringBlockTicker
extends BukkitRunnable {
    private RealisticSeasons main;
    private World w;
    private Random r = new Random();
    private boolean hasChangedBlocks;

    public World getWorld() {
        return this.w;
    }

    public SpringBlockTicker(RealisticSeasons realisticSeasons, World world) {
        this.main = realisticSeasons;
        this.w = world;
        for (Chunk chunk : world.getLoadedChunks()) {
            realisticSeasons.getSeasonManager().getQueue(world, Season.SPRING).add(new SeasonChunk(chunk.getWorld().getName(), chunk.getX(), chunk.getZ(), System.currentTimeMillis()));
        }
    }

    public static void checkChunk(SeasonChunk seasonChunk) {
        RealisticSeasons realisticSeasons = RealisticSeasons.getInstance();
        if (!realisticSeasons.getSettings().modifyBlocks && realisticSeasons.getSettings().springAnimals.size() == 0) {
            return;
        }
        realisticSeasons.getAsyncChunkHandler().remove(seasonChunk);
        boolean bl = false;
        if (!seasonChunk.getWorld().isChunkGenerated(seasonChunk.getX(), seasonChunk.getZ())) {
            return;
        }
        Chunk chunk = seasonChunk.getChunk();
        if (chunk == null) {
            return;
        }
        World world = seasonChunk.getWorld();
        if (world == null) {
            return;
        }
        if (!realisticSeasons.getChunkUtils().affectFlora(chunk)) {
            if (realisticSeasons.hasBlockChanges(chunk.getX(), chunk.getZ(), chunk.getWorld()) && realisticSeasons.hasSeasons(chunk.getX(), chunk.getZ(), chunk.getWorld())) {
                if (realisticSeasons.getSeasonManager().getSubSeason(world).getPhase() > 1) {
                    realisticSeasons.getChunkUtils().unfreezeChunk(chunk);
                } else {
                    realisticSeasons.getChunkUtils().unfreezeChunk(chunk, 0.14);
                }
            }
        } else {
            if (!realisticSeasons.hasSeasons(chunk.getX(), chunk.getZ(), chunk.getWorld())) {
                return;
            }
            if (realisticSeasons.hasBlockChanges(chunk.getX(), chunk.getZ(), chunk.getWorld())) {
                if (realisticSeasons.getSeasonManager().getSubSeason(world).getPhase() > 1) {
                    bl = realisticSeasons.getChunkUtils().unfreezeChunk(chunk);
                    if (realisticSeasons.getSettings().regrowGrass) {
                        bl = true;
                    }
                    realisticSeasons.getChunkUtils().checkPopulation(chunk, 4.0f, realisticSeasons.getSettings().flowerchanceinspring, 3, 3, Season.SPRING, bl);
                } else if (realisticSeasons.getSeasonManager().getSubSeason(world).getPhase() == 0) {
                    bl = realisticSeasons.getChunkUtils().unfreezeChunk(chunk, 0.14);
                    if (realisticSeasons.getSettings().regrowGrass) {
                        bl = true;
                    }
                    realisticSeasons.getChunkUtils().checkPopulation(chunk, 4.0f, realisticSeasons.getSettings().flowerchanceinspring / 4.0f, 3, 3, Season.SPRING, bl);
                } else {
                    bl = realisticSeasons.getChunkUtils().unfreezeChunk(chunk, 0.14);
                    if (realisticSeasons.getSettings().regrowGrass) {
                        bl = true;
                    }
                    realisticSeasons.getChunkUtils().checkPopulation(chunk, 4.0f, realisticSeasons.getSettings().flowerchanceinspring / 2.0f, 3, 3, Season.SPRING, bl);
                }
            }
            realisticSeasons.getAnimalUtils().updateAnimalSpawns(Season.SPRING, chunk);
        }
    }

    public void run() {
        if (this.main.getSeasonManager().getSeason(this.w) == Season.SPRING && this.w.getEnvironment() != World.Environment.NETHER && this.w.getEnvironment() != World.Environment.THE_END) {
            if (!this.main.getSettings().modifyBlocks && this.main.getSettings().springAnimals.size() == 0) {
                return;
            }
            if (!this.main.getSeasonManager().getQueue(this.w, Season.SPRING).isEmpty()) {
                if (this.main.getNMSUtils().getTPS() < this.main.getSettings().minTPS && this.main.getSettings().prioritiseTPS) {
                    return;
                }
                for (int i = 0; i < this.main.getSeasonManager().getQueue(this.w, Season.SPRING).size(); ++i) {
                    SeasonChunk seasonChunk = this.main.getSeasonManager().getQueue(this.w, Season.SPRING).get(this.r.nextInt(this.main.getSeasonManager().getQueue(this.w, Season.SPRING).size()));
                    if (seasonChunk.getWorld() != this.w || System.currentTimeMillis() - seasonChunk.getLoadTime() < 10000L) continue;
                    if (this.main.getSeasonManager().getCheckedList(this.w, Season.SPRING).contains(seasonChunk) && this.main.getSeasonManager().getSubSeason(this.w).getPhase() > 1) {
                        this.main.getSeasonManager().getQueue(this.w, Season.SPRING).remove(seasonChunk);
                        continue;
                    }
                    if (!this.w.isChunkLoaded(seasonChunk.getX(), seasonChunk.getZ())) {
                        this.main.getSeasonManager().getQueue(this.w, Season.SPRING).remove(seasonChunk);
                        continue;
                    }
                    if (seasonChunk.getX() > 1875000 || seasonChunk.getX() > 1875000 || seasonChunk.getX() < -1875000 || seasonChunk.getX() < -1875000) {
                        this.main.getSeasonManager().getQueue(this.w, Season.SPRING).remove(seasonChunk);
                        continue;
                    }
                    if (!this.w.isChunkLoaded(seasonChunk.getX() + 1, seasonChunk.getZ()) || !this.w.isChunkLoaded(seasonChunk.getX() - 1, seasonChunk.getZ()) || !this.w.isChunkLoaded(seasonChunk.getX(), seasonChunk.getZ() + 1) || !this.w.isChunkLoaded(seasonChunk.getX(), seasonChunk.getZ() - 1)) continue;
                    Chunk chunk = seasonChunk.getChunk();
                    if (!this.main.getChunkUtils().affectFlora(chunk)) {
                        if (this.main.hasBlockChanges(chunk.getX(), chunk.getZ(), chunk.getWorld()) && this.main.hasSeasons(chunk.getX(), chunk.getZ(), chunk.getWorld())) {
                            if (this.main.getSeasonManager().getSubSeason(this.w).getPhase() > 1) {
                                this.main.getChunkUtils().unfreezeChunk(chunk);
                                this.main.getAsyncChunkHandler().remove(seasonChunk);
                            } else {
                                this.main.getChunkUtils().unfreezeChunk(chunk, 0.14);
                            }
                        }
                        if (this.main.getSeasonManager().getSubSeason(this.w).getPhase() > 1) {
                            this.main.getSeasonManager().getQueue(this.w, Season.SPRING).remove(seasonChunk);
                            this.main.getSeasonManager().getCheckedList(this.w, Season.SPRING).add(seasonChunk);
                        }
                    } else {
                        if (!this.main.hasSeasons(chunk.getX(), chunk.getZ(), chunk.getWorld())) {
                            if (this.main.getSeasonManager().getSubSeason(this.w).getPhase() <= 1) continue;
                            this.main.getSeasonManager().getQueue(this.w, Season.SPRING).remove(seasonChunk);
                            this.main.getSeasonManager().getCheckedList(this.w, Season.SPRING).add(seasonChunk);
                            continue;
                        }
                        if (this.main.hasBlockChanges(chunk.getX(), chunk.getZ(), chunk.getWorld())) {
                            if (this.main.getSeasonManager().getSubSeason(this.w).getPhase() > 1) {
                                this.hasChangedBlocks = this.main.getChunkUtils().unfreezeChunk(chunk);
                                this.main.getAsyncChunkHandler().remove(seasonChunk);
                                if (this.main.getSettings().regrowGrass) {
                                    this.hasChangedBlocks = true;
                                }
                                this.main.getChunkUtils().checkPopulation(chunk, 4.0f, this.main.getSettings().flowerchanceinspring, 3, 3, Season.SPRING, this.hasChangedBlocks);
                            } else if (this.main.getSeasonManager().getSubSeason(this.w).getPhase() == 0) {
                                this.hasChangedBlocks = this.main.getChunkUtils().unfreezeChunk(chunk, 0.14);
                                if (this.main.getSettings().regrowGrass) {
                                    this.hasChangedBlocks = true;
                                }
                                this.main.getChunkUtils().checkPopulation(chunk, 4.0f, this.main.getSettings().flowerchanceinspring / 4.0f, 3, 3, Season.SPRING, this.hasChangedBlocks);
                            } else {
                                this.hasChangedBlocks = this.main.getChunkUtils().unfreezeChunk(chunk, 0.14);
                                if (this.main.getSettings().regrowGrass) {
                                    this.hasChangedBlocks = true;
                                }
                                this.main.getChunkUtils().checkPopulation(chunk, 4.0f, this.main.getSettings().flowerchanceinspring / 2.0f, 3, 3, Season.SPRING, this.hasChangedBlocks);
                            }
                        }
                        if (!this.main.getSeasonManager().getCheckedList(this.w, Season.SPRING).contains(seasonChunk)) {
                            this.main.getAnimalUtils().updateAnimalSpawns(Season.SPRING, chunk);
                        }
                        if (this.main.getSeasonManager().getSubSeason(this.w).getPhase() > 1) {
                            this.main.getSeasonManager().getQueue(this.w, Season.SPRING).remove(seasonChunk);
                            this.main.getSeasonManager().getCheckedList(this.w, Season.SPRING).add(seasonChunk);
                        }
                    }
                    break;
                }
            }
        } else {
            this.main.getSeasonManager().clearChunkCheckedList(this.w, Season.SPRING);
            this.main.getSeasonManager().clearChunkQueue(this.w, Season.SPRING);
            this.cancel();
        }
    }
}

