/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.runnables;

import java.util.Random;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.season.Season;
import me.casperge.realisticseasons.season.SeasonChunk;
import me.casperge.realisticseasons.season.SubSeason;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.scheduler.BukkitRunnable;

public class SummerBlockTicker
extends BukkitRunnable {
    private RealisticSeasons main;
    private World w;
    private Random r = new Random();
    private boolean hasChangedBlocks;

    public World getWorld() {
        return this.w;
    }

    public SummerBlockTicker(RealisticSeasons realisticSeasons, World world) {
        this.main = realisticSeasons;
        this.w = world;
        for (Chunk chunk : world.getLoadedChunks()) {
            realisticSeasons.getSeasonManager().getQueue(world, Season.SUMMER).add(new SeasonChunk(chunk.getWorld().getName(), chunk.getX(), chunk.getZ(), System.currentTimeMillis()));
        }
    }

    public static void checkChunk(SeasonChunk seasonChunk) {
        RealisticSeasons realisticSeasons = RealisticSeasons.getInstance();
        if (!realisticSeasons.getSettings().modifyBlocks && realisticSeasons.getSettings().summerAnimals.size() == 0) {
            return;
        }
        realisticSeasons.getAsyncChunkHandler().remove(seasonChunk);
        boolean bl = false;
        Chunk chunk = seasonChunk.getChunk();
        if (chunk == null) {
            return;
        }
        chunk.load();
        World world = seasonChunk.getWorld();
        if (world == null) {
            return;
        }
        if (!realisticSeasons.getChunkUtils().affectFlora(chunk)) {
            if (realisticSeasons.hasBlockChanges(chunk.getX(), chunk.getZ(), chunk.getWorld()) && realisticSeasons.hasSeasons(chunk.getX(), chunk.getZ(), chunk.getWorld())) {
                realisticSeasons.getChunkUtils().unfreezeChunk(chunk);
            }
        } else {
            if (!realisticSeasons.hasSeasons(chunk.getX(), chunk.getZ(), chunk.getWorld())) {
                return;
            }
            if (realisticSeasons.hasBlockChanges(chunk.getX(), chunk.getZ(), chunk.getWorld())) {
                bl = realisticSeasons.getChunkUtils().unfreezeChunk(chunk);
                if (realisticSeasons.getSettings().regrowGrass) {
                    bl = true;
                }
                if (realisticSeasons.getSettings().flowerchanceinspring > 0.1f) {
                    if (realisticSeasons.getSeasonManager().getSubSeason(world) == SubSeason.START) {
                        realisticSeasons.getChunkUtils().checkPopulation(chunk, 4.0f, (0.1f + realisticSeasons.getSettings().flowerchanceinspring) / 2.0f, 1, 1, Season.SUMMER, bl);
                    } else if (realisticSeasons.getSeasonManager().getSubSeason(world) == SubSeason.EARLY) {
                        float f = (0.1f + realisticSeasons.getSettings().flowerchanceinspring) / 4.0f;
                        if (f < 0.1f) {
                            f = 0.1f;
                        }
                        realisticSeasons.getChunkUtils().checkPopulation(chunk, 4.0f, f, 1, 1, Season.SUMMER, bl);
                    } else {
                        realisticSeasons.getChunkUtils().checkPopulation(chunk, 4.0f, 0.1f, 1, 1, Season.SUMMER, bl);
                    }
                } else {
                    realisticSeasons.getChunkUtils().checkPopulation(chunk, 4.0f, 0.1f, 1, 1, Season.SUMMER, bl);
                }
            }
            realisticSeasons.getAnimalUtils().updateAnimalSpawns(Season.SUMMER, chunk);
        }
    }

    public void run() {
        if (this.main.getSeasonManager().getSeason(this.w) == Season.SUMMER && this.w.getEnvironment() != World.Environment.NETHER && this.w.getEnvironment() != World.Environment.THE_END) {
            if (!this.main.getSettings().modifyBlocks && this.main.getSettings().summerAnimals.size() == 0) {
                return;
            }
            if (!this.main.getSeasonManager().getQueue(this.w, Season.SUMMER).isEmpty()) {
                if (this.main.getNMSUtils().getTPS() < this.main.getSettings().minTPS && this.main.getSettings().prioritiseTPS) {
                    return;
                }
                for (int i = 0; i < this.main.getSeasonManager().getQueue(this.w, Season.SUMMER).size(); ++i) {
                    SeasonChunk seasonChunk = this.main.getSeasonManager().getQueue(this.w, Season.SUMMER).get(this.r.nextInt(this.main.getSeasonManager().getQueue(this.w, Season.SUMMER).size()));
                    if (seasonChunk.getWorld() != this.w || System.currentTimeMillis() - seasonChunk.getLoadTime() < 10000L) continue;
                    if (this.main.getSeasonManager().getCheckedList(this.w, Season.SUMMER).contains(seasonChunk) || !this.w.isChunkLoaded(seasonChunk.getX(), seasonChunk.getZ())) {
                        this.main.getSeasonManager().getQueue(this.w, Season.SUMMER).remove(seasonChunk);
                        continue;
                    }
                    if (seasonChunk.getX() > 1875000 || seasonChunk.getX() > 1875000 || seasonChunk.getX() < -1875000 || seasonChunk.getX() < -1875000) {
                        this.main.getSeasonManager().getQueue(this.w, Season.SUMMER).remove(seasonChunk);
                        continue;
                    }
                    if (!this.w.isChunkLoaded(seasonChunk.getX(), seasonChunk.getZ())) {
                        this.main.getSeasonManager().getQueue(this.w, Season.SUMMER).remove(seasonChunk);
                        continue;
                    }
                    if (!this.w.isChunkLoaded(seasonChunk.getX() + 1, seasonChunk.getZ()) || !this.w.isChunkLoaded(seasonChunk.getX() - 1, seasonChunk.getZ()) || !this.w.isChunkLoaded(seasonChunk.getX(), seasonChunk.getZ() + 1) || !this.w.isChunkLoaded(seasonChunk.getX(), seasonChunk.getZ() - 1)) continue;
                    Chunk chunk = seasonChunk.getChunk();
                    if (!this.main.getChunkUtils().affectFlora(chunk)) {
                        if (this.main.hasBlockChanges(chunk.getX(), chunk.getZ(), chunk.getWorld()) && this.main.hasSeasons(chunk.getX(), chunk.getZ(), chunk.getWorld())) {
                            this.main.getChunkUtils().unfreezeChunk(chunk);
                            this.main.getAsyncChunkHandler().remove(seasonChunk);
                        }
                        this.main.getSeasonManager().getQueue(this.w, Season.SUMMER).remove(seasonChunk);
                        this.main.getSeasonManager().getCheckedList(this.w, Season.SUMMER).add(seasonChunk);
                    } else {
                        if (!this.main.hasSeasons(chunk.getX(), chunk.getZ(), chunk.getWorld())) {
                            this.main.getSeasonManager().getQueue(this.w, Season.SUMMER).remove(seasonChunk);
                            this.main.getSeasonManager().getCheckedList(this.w, Season.SUMMER).add(seasonChunk);
                            continue;
                        }
                        if (this.main.hasBlockChanges(chunk.getX(), chunk.getZ(), chunk.getWorld())) {
                            this.hasChangedBlocks = this.main.getChunkUtils().unfreezeChunk(chunk);
                            this.main.getAsyncChunkHandler().remove(seasonChunk);
                            if (this.main.getSettings().regrowGrass) {
                                this.hasChangedBlocks = true;
                            }
                            if (this.main.getSettings().flowerchanceinspring > 0.1f) {
                                if (this.main.getSeasonManager().getSubSeason(this.w) == SubSeason.START) {
                                    this.main.getChunkUtils().checkPopulation(chunk, 4.0f, (0.1f + this.main.getSettings().flowerchanceinspring) / 2.0f, 1, 1, Season.SUMMER, this.hasChangedBlocks);
                                } else if (this.main.getSeasonManager().getSubSeason(this.w) == SubSeason.EARLY) {
                                    float f = (0.1f + this.main.getSettings().flowerchanceinspring) / 4.0f;
                                    if (f < 0.1f) {
                                        f = 0.1f;
                                    }
                                    this.main.getChunkUtils().checkPopulation(chunk, 4.0f, f, 1, 1, Season.SUMMER, this.hasChangedBlocks);
                                } else {
                                    this.main.getChunkUtils().checkPopulation(chunk, 4.0f, 0.1f, 1, 1, Season.SUMMER, this.hasChangedBlocks);
                                }
                            } else {
                                this.main.getChunkUtils().checkPopulation(chunk, 4.0f, 0.1f, 1, 1, Season.SUMMER, this.hasChangedBlocks);
                            }
                        }
                        this.main.getAnimalUtils().updateAnimalSpawns(Season.SUMMER, chunk);
                        this.main.getSeasonManager().getQueue(this.w, Season.SUMMER).remove(seasonChunk);
                        this.main.getSeasonManager().getCheckedList(this.w, Season.SUMMER).add(seasonChunk);
                    }
                    break;
                }
            }
        } else {
            this.main.getSeasonManager().clearChunkCheckedList(this.w, Season.SUMMER);
            this.main.getSeasonManager().clearChunkQueue(this.w, Season.SUMMER);
            this.cancel();
        }
    }
}

