/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.seasonevent;

import java.util.ArrayList;
import java.util.List;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.seasonevent.SeasonCustomEvent;
import org.bukkit.configuration.ConfigurationSection;

public class CustomWeeklyEvent
implements SeasonCustomEvent {
    private String name;
    private boolean doDisplay;
    private int weekday;
    private List<String> startCommands = new ArrayList<String>();
    private List<String> stopCommands = new ArrayList<String>();

    public CustomWeeklyEvent(ConfigurationSection configurationSection) {
        if (configurationSection.getBoolean("enabled")) {
            this.startCommands = configurationSection.getStringList("commands.start");
            this.stopCommands = configurationSection.getStringList("commands.stop");
        }
        this.name = configurationSection.getString("name");
        this.doDisplay = configurationSection.getBoolean("display-event");
        this.weekday = RealisticSeasons.getInstance().getTimeManager().getCalendar().weekDayFromString(configurationSection.getString("day"));
    }

    @Override
    public List<String> getCommands(boolean bl) {
        if (bl) {
            return this.startCommands;
        }
        return this.stopCommands;
    }

    public boolean isToday(int n) {
        return n == this.weekday;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean doDisplay() {
        return this.doDisplay;
    }
}

