/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.seasonevent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.api.SeasonEventEnd;
import me.casperge.realisticseasons.api.SeasonEventStart;
import me.casperge.realisticseasons.calendar.Date;
import me.casperge.realisticseasons.seasonevent.CustomDailyEvent;
import me.casperge.realisticseasons.seasonevent.CustomDatedEvent;
import me.casperge.realisticseasons.seasonevent.CustomWeeklyEvent;
import me.casperge.realisticseasons.seasonevent.EventFileLoader;
import me.casperge.realisticseasons.seasonevent.EventUtils;
import me.casperge.realisticseasons.seasonevent.SeasonCustomEvent;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;

public class EventManager {
    private EventUtils utils;
    private List<CustomDatedEvent> dated = new ArrayList<CustomDatedEvent>();
    private List<CustomWeeklyEvent> weekly = new ArrayList<CustomWeeklyEvent>();
    private List<CustomDailyEvent> daily = new ArrayList<CustomDailyEvent>();
    private HashMap<World, List<String>> activeEvents = new HashMap();
    private RealisticSeasons main;

    public EventManager(RealisticSeasons realisticSeasons) {
        this.main = realisticSeasons;
        this.utils = new EventUtils(realisticSeasons);
        this.load();
    }

    public void load() {
        if (this.main.getSettings().calendarEnabled) {
            new EventFileLoader(this.main, this);
            this.activeEvents.clear();
            for (World world : this.main.getSeasonManager().worldData.keySet()) {
                List<String> list;
                Date date = this.main.getTimeManager().getDate(world);
                for (CustomWeeklyEvent customWeeklyEvent : this.weekly) {
                    if (!customWeeklyEvent.isToday(this.main.getTimeManager().getCalendar().getWeekDayAsInt(date)) || !customWeeklyEvent.doDisplay()) continue;
                    list = this.activeEvents.containsKey(world) ? this.activeEvents.get(world) : new ArrayList<String>();
                    list.add(customWeeklyEvent.getName());
                    this.activeEvents.put(world, list);
                }
                for (CustomDatedEvent customDatedEvent : this.dated) {
                    if (!customDatedEvent.isActive(date) || !customDatedEvent.doDisplay()) continue;
                    list = this.activeEvents.containsKey(world) ? this.activeEvents.get(world) : new ArrayList();
                    list.add(customDatedEvent.getName());
                    this.activeEvents.put(world, list);
                }
            }
        }
    }

    private void execute(World world, SeasonCustomEvent seasonCustomEvent, boolean bl, Date date) {
        this.utils.execute(world, seasonCustomEvent.getCommands(bl), date);
    }

    public void start(World world, SeasonCustomEvent seasonCustomEvent, Date date) {
        SeasonEventStart seasonEventStart = new SeasonEventStart(world, seasonCustomEvent);
        Bukkit.getPluginManager().callEvent((Event)seasonEventStart);
        if (seasonEventStart.isCancelled()) {
            return;
        }
        if (seasonCustomEvent.doDisplay()) {
            List<String> list = this.activeEvents.containsKey(world) ? this.activeEvents.get(world) : new ArrayList<String>();
            list.add(seasonCustomEvent.getName());
            this.activeEvents.put(world, list);
        }
        this.execute(world, seasonCustomEvent, true, date);
    }

    public void stop(World world, SeasonCustomEvent seasonCustomEvent, Date date) {
        SeasonEventEnd seasonEventEnd = new SeasonEventEnd(world, seasonCustomEvent);
        Bukkit.getPluginManager().callEvent((Event)seasonEventEnd);
        if (seasonCustomEvent.doDisplay() && this.activeEvents.containsKey(world)) {
            List<String> list = this.activeEvents.get(world);
            list.remove(seasonCustomEvent.getName());
            this.activeEvents.put(world, list);
        }
        this.execute(world, seasonCustomEvent, false, date);
    }

    public void setDatedEvents(List<CustomDatedEvent> list) {
        this.dated = list;
    }

    public void setWeeklyEvents(List<CustomWeeklyEvent> list) {
        this.weekly = list;
    }

    public void setDailyEvents(List<CustomDailyEvent> list) {
        this.daily = list;
    }

    public List<CustomDatedEvent> getDatedEvents() {
        return this.dated;
    }

    public List<CustomWeeklyEvent> getWeeklyEvents() {
        return this.weekly;
    }

    public List<CustomDailyEvent> getDailyEvents() {
        return this.daily;
    }

    public List<String> getActiveEvents(World world) {
        if (this.activeEvents.containsKey(world)) {
            return this.activeEvents.get(world);
        }
        return new ArrayList<String>();
    }

    public String getActiveEventsAsString(World world) {
        if (!this.activeEvents.containsKey(world)) {
            return "-";
        }
        boolean bl = true;
        String string = "";
        for (String string2 : this.activeEvents.get(world)) {
            if (bl) {
                string = string2;
                bl = false;
                continue;
            }
            string = string + ", " + string2;
        }
        if (string.isEmpty()) {
            string = "-";
        }
        return string;
    }
}

