/*
 * Decompiled with CFR 0.152.
 */
package me.casperge.realisticseasons.temperature;

import java.util.Random;
import me.casperge.realisticseasons.RealisticSeasons;
import me.casperge.realisticseasons.Version;
import me.casperge.realisticseasons.season.Season;
import me.casperge.realisticseasons.temperature.CustomTemperatureItem;
import me.casperge.realisticseasons.temperature.TempData;
import me.casperge.realisticseasons.temperature.TempEffect;
import me.casperge.realisticseasons.temperature.TemperatureSettings;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class TempUtils {
    private final Material[] leather = new Material[]{Material.LEATHER_BOOTS, Material.LEATHER_CHESTPLATE, Material.LEATHER_LEGGINGS, Material.LEATHER_HELMET};
    private final Material[] iron = new Material[]{Material.IRON_HELMET, Material.IRON_CHESTPLATE, Material.IRON_LEGGINGS, Material.IRON_BOOTS};
    private final Material[] gold = new Material[]{Material.GOLDEN_HELMET, Material.GOLDEN_CHESTPLATE, Material.GOLDEN_LEGGINGS, Material.GOLDEN_BOOTS};
    private final Material[] diamond = new Material[]{Material.DIAMOND_HELMET, Material.DIAMOND_CHESTPLATE, Material.DIAMOND_LEGGINGS, Material.DIAMOND_BOOTS};
    private final Material[] netherite = new Material[]{Material.NETHERITE_HELMET, Material.NETHERITE_CHESTPLATE, Material.NETHERITE_LEGGINGS, Material.NETHERITE_BOOTS};
    private RealisticSeasons main;
    private TempData tempdata;
    private final Random r = new Random();
    public int tickRate = 40;

    public TempUtils(RealisticSeasons realisticSeasons, TempData tempData) {
        this.main = realisticSeasons;
        this.tempdata = tempData;
    }

    public int getCurrentWorldTemperature(World world) {
        int n = this.getCurrentBaseTemperature(world) + this.getWeatherModifier(world) + this.getCurrentTimeModifier(world);
        if (n > this.tempdata.getTempSettings().getMaxTemperature(this.main.getSeasonManager().getSeason(world))) {
            return this.tempdata.getTempSettings().getMaxTemperature(this.main.getSeasonManager().getSeason(world));
        }
        if (n < this.tempdata.getTempSettings().getMinTemperature(this.main.getSeasonManager().getSeason(world))) {
            return this.tempdata.getTempSettings().getMinTemperature(this.main.getSeasonManager().getSeason(world));
        }
        return n;
    }

    private int getCurrentBaseTemperature(World world) {
        return this.main.getTemperatureManager().getTempData().getBaseTemperature(world);
    }

    private int getWeatherModifier(World world) {
        if (world.isThundering()) {
            return this.tempdata.getTempSettings().getWeatherModifier(TemperatureSettings.Weather.STORM);
        }
        if (world.hasStorm()) {
            return this.tempdata.getTempSettings().getWeatherModifier(TemperatureSettings.Weather.RAIN);
        }
        return 0;
    }

    private int getCurrentTimeModifier(World world) {
        if (world.getTime() >= 22500L || world.getTime() < 6000L) {
            if (world.getTime() >= 22500L && world.getTime() < 23500L) {
                return -5;
            }
            if (world.getTime() >= 23500L || world.getTime() < 500L) {
                return -4;
            }
            if (world.getTime() >= 500L && world.getTime() < 1500L) {
                return -3;
            }
            if (world.getTime() >= 1500L && world.getTime() < 2500L) {
                return -2;
            }
            if (world.getTime() >= 2500L && world.getTime() < 3500L) {
                return -1;
            }
            if (world.getTime() >= 3500L && world.getTime() < 4500L) {
                return 0;
            }
            if (world.getTime() >= 4500L && world.getTime() < 5500L) {
                return 1;
            }
            if (world.getTime() >= 5500L) {
                return 2;
            }
        } else {
            if (world.getTime() >= 14800L && world.getTime() < 22500L) {
                return -5;
            }
            if (world.getTime() >= 6000L && world.getTime() < 12000L) {
                return 3;
            }
            if (world.getTime() >= 12000L && world.getTime() < 12450L) {
                return 2;
            }
            if (world.getTime() >= 12450L && world.getTime() < 12900L) {
                return 1;
            }
            if (world.getTime() >= 12900L && world.getTime() < 13350L) {
                return 0;
            }
            if (world.getTime() >= 13350L && world.getTime() < 13800L) {
                return -1;
            }
            if (world.getTime() >= 13800L && world.getTime() < 14200L) {
                return -2;
            }
            if (world.getTime() >= 14200L && world.getTime() < 14400L) {
                return -3;
            }
            if (world.getTime() >= 14400L && world.getTime() < 14600L) {
                return -4;
            }
            if (world.getTime() >= 14600L && world.getTime() < 14800L) {
                return -5;
            }
        }
        return 0;
    }

    public int getArmorModified(Player player, int n) {
        if (player.getInventory().getArmorContents().length == 0) {
            return n;
        }
        float f = 0.0f;
        for (ItemStack itemStack : player.getInventory().getArmorContents()) {
            if (itemStack == null) continue;
            boolean bl = false;
            CustomTemperatureItem customTemperatureItem = null;
            for (CustomTemperatureItem customTemperatureItem2 : this.tempdata.getTempSettings().getCustomItems()) {
                if (!customTemperatureItem2.onWear() || !customTemperatureItem2.isItem(itemStack)) continue;
                bl = true;
                customTemperatureItem = customTemperatureItem2;
            }
            if (bl) {
                f += (float)customTemperatureItem.getModifier();
                continue;
            }
            if (this.containsMaterial(itemStack.getType(), this.leather)) {
                if (!(f + (float)n < (float)this.tempdata.getTempSettings().getLeatherCap())) continue;
                f += (float)this.tempdata.getTempSettings().getArmorModifier(TemperatureSettings.Armor.LEATHER) / 4.0f;
                continue;
            }
            if (this.containsMaterial(itemStack.getType(), this.iron)) {
                f += (float)this.tempdata.getTempSettings().getArmorModifier(TemperatureSettings.Armor.IRON) / 4.0f;
                continue;
            }
            if (this.containsMaterial(itemStack.getType(), this.gold)) {
                f += (float)this.tempdata.getTempSettings().getArmorModifier(TemperatureSettings.Armor.GOLD) / 4.0f;
                continue;
            }
            if (this.containsMaterial(itemStack.getType(), this.diamond)) {
                f += (float)this.tempdata.getTempSettings().getArmorModifier(TemperatureSettings.Armor.DIAMOND) / 4.0f;
                continue;
            }
            if (!this.containsMaterial(itemStack.getType(), this.netherite)) continue;
            f += (float)this.tempdata.getTempSettings().getArmorModifier(TemperatureSettings.Armor.NETHERITE) / 4.0f;
        }
        return (int)((float)n + f);
    }

    public int getWaterModified(Player player, int n, Season season) {
        boolean bl = false;
        if (player.isInsideVehicle()) {
            if (player.getVehicle().getType() == EntityType.BOAT) {
                bl = true;
            } else if (Version.is_1_19_or_up() && player.getVehicle().getType() == EntityType.CHEST_BOAT) {
                bl = true;
            }
        }
        if ((this.isInWater(player) || this.main.getNMSUtils().isPlayerInPowderedSnow(player)) && !bl) {
            int n2 = this.main.getTemperatureManager().getTempData().getWaterTemperatureModifier(player.getLocation(), season);
            if (n2 == 5555) {
                n2 = this.tempdata.getTempSettings().getSwimmingModifier(this.main.getSeasonManager().getSeason(player.getWorld()));
            }
            this.main.getTemperatureManager().getTempData().setWaterModifier(player, n2);
            return n + n2;
        }
        int n3 = this.main.getTemperatureManager().getTempData().getWaterModifier(player);
        if (n3 >= 0) {
            if (n3 <= 1) {
                this.main.getTemperatureManager().getTempData().removeFromWaterList(player);
                return n;
            }
            this.main.getTemperatureManager().getTempData().setWaterModifier(player, n3 - 1);
            return n + (n3 - 1);
        }
        if (n3 == -1) {
            this.main.getTemperatureManager().getTempData().removeFromWaterList(player);
            return n;
        }
        this.main.getTemperatureManager().getTempData().setWaterModifier(player, n3 + 1);
        return n + (n3 + 1);
    }

    public int getSprintingModified(Player player, int n) {
        int n2 = this.main.getTemperatureManager().getTempData().getSprintingModifier(player);
        if (player.isSprinting() && !player.isFlying() && !player.isGliding() && !player.isSwimming()) {
            if (n2 >= this.tempdata.getTempSettings().getMaxSprintingModifier()) {
                return n + n2;
            }
            if (n2 + 1 == this.tempdata.getTempSettings().getMaxSprintingModifier()) {
                this.main.getTemperatureManager().getTempData().setSprintingModifier(player, n2 + 1);
                return n + n2 + 1;
            }
            this.main.getTemperatureManager().getTempData().setSprintingModifier(player, n2 + 2);
            return n + n2 + 2;
        }
        if (n2 <= 0) {
            return n;
        }
        this.main.getTemperatureManager().getTempData().setSprintingModifier(player, n2 - 1);
        return n + n2 - 1;
    }

    public int getFoodModified(Player player, int n) {
        if (n > 25) {
            if (this.hasDrinked(player)) {
                if (n + this.tempdata.getTempSettings().getWaterBottleModifier() < 25) {
                    return 25;
                }
                return n + this.tempdata.getTempSettings().getWaterBottleModifier();
            }
        } else if (player.getFoodLevel() >= 20) {
            if (n + this.tempdata.getTempSettings().getFullHungerModifier() > 25) {
                return 25;
            }
            return n + this.tempdata.getTempSettings().getFullHungerModifier();
        }
        return n;
    }

    public int getHeightModified(Location location, int n) {
        if (!this.tempdata.getTempSettings().isHeightModifying()) {
            return n;
        }
        if (this.main.getSeasonManager().getSeason(location.getWorld()) == Season.WINTER) {
            if (location.getBlockY() < 64) {
                return n + (64 - location.getBlockY()) / 10;
            }
        } else if (location.getBlockY() > 64) {
            return n - (int)((float)(location.getBlockY() - 64) * 0.08f);
        }
        return n;
    }

    public int getBiomeModified(Location location, int n) {
        return n + this.main.getTemperatureManager().getTempData().getBiomeTemperatureModifier(location);
    }

    public void applyEffect(Player player, TempEffect tempEffect) {
        switch (tempEffect) {
            case COLD_FREEZING: {
                this.main.getTemperatureManager().setFreezing(player, true, true);
                break;
            }
            case COLD_HUNGER: {
                player.addPotionEffect(new PotionEffect(PotionEffectType.HUNGER, this.tickRate + 60, 1, false, false));
                break;
            }
            case COLD_SLOWNESS: {
                player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, this.tickRate + 60, 2, false, false));
                this.main.getTemperatureManager().setFreezing(player, true, false);
                break;
            }
            case HEAT_FIRE: {
                if (this.tickRate < 40) {
                    player.setFireTicks(this.tickRate + 40);
                    break;
                }
                player.setFireTicks(this.tickRate + 20);
                break;
            }
            case HEAT_NO_HEALING: {
                this.main.getTemperatureManager().setHealing(player, false);
                break;
            }
            case HEAT_SLOWNESS: {
                player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, this.tickRate + 60, 2, false, false));
                break;
            }
            case BOOSTS: {
                for (PotionEffectType potionEffectType : this.tempdata.getTempSettings().getBoostPotionEffects()) {
                    if (potionEffectType.equals((Object)PotionEffectType.HEALTH_BOOST)) {
                        if (!player.hasPotionEffect(potionEffectType)) {
                            player.addPotionEffect(new PotionEffect(potionEffectType, Integer.MAX_VALUE, 0, false, false));
                        }
                        return;
                    }
                    if (!player.hasPotionEffect(potionEffectType)) {
                        player.addPotionEffect(new PotionEffect(potionEffectType, this.tickRate + 240, 0, false, false));
                        continue;
                    }
                    if (player.getPotionEffect(potionEffectType).getDuration() >= 120) continue;
                    player.addPotionEffect(new PotionEffect(potionEffectType, this.tickRate + 240, 0, false, false));
                }
                break;
            }
        }
    }

    public int generateNewBaseTemperature(World world) {
        int n;
        Season season = this.main.getSeasonManager().getSeason(world);
        int n2 = this.tempdata.getTempSettings().getMinTemperature(season);
        if (n2 > (n = this.tempdata.getTempSettings().getMaxTemperature(season))) {
            int n3 = n2;
            n2 = n;
            n = n3;
        }
        if (n2 == n) {
            return n;
        }
        return this.r.nextInt(n - n2 + 1) + n2;
    }

    public int generateNextDayBaseTemp(World world, int n) {
        Season season = this.main.getSeasonManager().getSeason(world);
        int n2 = this.tempdata.getTempSettings().getMinTemperature(season);
        int n3 = this.tempdata.getTempSettings().getMaxTemperature(season);
        int n4 = this.r.nextInt(n3 - n2 + 1) + n2;
        if (n4 < n) {
            return n - 2;
        }
        if (n4 > n) {
            return n + 2;
        }
        return n;
    }

    public boolean containsMaterial(Material material, Material[] materialArray) {
        for (Material material2 : materialArray) {
            if (material2 != material) continue;
            return true;
        }
        return false;
    }

    public boolean isInWater(Player player) {
        return player.getLocation().getBlock().getType() == Material.WATER || player.getLocation().getBlock().getRelative(0, 1, 0).getType() == Material.WATER;
    }

    public boolean hasDrinked(Player player) {
        return System.currentTimeMillis() - this.main.getTemperatureManager().getTempData().getLastDrink(player) < (long)(this.main.getTemperatureManager().getTempData().getTempSettings().getWaterBottleEffectDuration() * 1000);
    }
}

