/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.FilterReader;
import java.io.Reader;
import java.util.function.IntPredicate;

public abstract class AbstractCharacterFilterReader
extends FilterReader {
    protected static final IntPredicate SKIP_NONE = n -> false;
    private final IntPredicate skip;

    protected AbstractCharacterFilterReader(Reader reader) {
        this(reader, SKIP_NONE);
    }

    protected AbstractCharacterFilterReader(Reader reader, IntPredicate intPredicate) {
        super(reader);
        this.skip = intPredicate == null ? SKIP_NONE : intPredicate;
    }

    protected boolean filter(int n) {
        return this.skip.test(n);
    }

    @Override
    public int read() {
        int n;
        while ((n = this.in.read()) != -1 && this.filter(n)) {
        }
        return n;
    }

    @Override
    public int read(char[] cArray, int n, int n2) {
        int n3 = super.read(cArray, n, n2);
        if (n3 == -1) {
            return -1;
        }
        int n4 = n - 1;
        for (int i = n; i < n + n3; ++i) {
            if (this.filter(cArray[i]) || ++n4 >= i) continue;
            cArray[n4] = cArray[i];
        }
        return n4 - n + 1;
    }
}

