/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;

public final class BufferedFileChannelInputStream
extends InputStream {
    private final ByteBuffer byteBuffer;
    private final FileChannel fileChannel;
    private static final Class<?> DIRECT_BUFFER_CLASS = BufferedFileChannelInputStream.getDirectBufferClass();

    private static Class<?> getDirectBufferClass() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("sun.nio.ch.DirectBuffer");
        }
        catch (ClassNotFoundException | IllegalAccessError throwable) {
            // empty catch block
        }
        return clazz;
    }

    private static boolean isDirectBuffer(Object object) {
        return DIRECT_BUFFER_CLASS != null && DIRECT_BUFFER_CLASS.isInstance(object);
    }

    public BufferedFileChannelInputStream(File file) {
        this(file, 8192);
    }

    public BufferedFileChannelInputStream(File file, int n) {
        this(file.toPath(), n);
    }

    public BufferedFileChannelInputStream(Path path) {
        this(path, 8192);
    }

    public BufferedFileChannelInputStream(Path path, int n) {
        Objects.requireNonNull(path, "path");
        this.fileChannel = FileChannel.open(path, StandardOpenOption.READ);
        this.byteBuffer = ByteBuffer.allocateDirect(n);
        this.byteBuffer.flip();
    }

    @Override
    public synchronized int available() {
        return this.byteBuffer.remaining();
    }

    private void clean(ByteBuffer byteBuffer) {
        if (BufferedFileChannelInputStream.isDirectBuffer(byteBuffer)) {
            this.cleanDirectBuffer(byteBuffer);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void cleanDirectBuffer(ByteBuffer byteBuffer) {
        String string = System.getProperty("java.specification.version");
        if ("1.8".equals(string)) {
            try {
                Class<?> clazz = Class.forName("sun.misc.Cleaner");
                Method method = DIRECT_BUFFER_CLASS.getMethod("cleaner", new Class[0]);
                Object object = method.invoke((Object)byteBuffer, new Object[0]);
                if (object == null) return;
                Method method2 = clazz.getMethod("clean", new Class[0]);
                method2.invoke(object, new Object[0]);
                return;
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new IllegalStateException(reflectiveOperationException);
            }
        }
        try {
            Class<?> clazz = Class.forName("sun.misc.Unsafe");
            Method method = clazz.getMethod("invokeCleaner", ByteBuffer.class);
            Field field = clazz.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            method.invoke(field.get(null), byteBuffer);
            return;
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new IllegalStateException(reflectiveOperationException);
        }
    }

    @Override
    public synchronized void close() {
        try {
            this.fileChannel.close();
        }
        finally {
            this.clean(this.byteBuffer);
        }
    }

    @Override
    public synchronized int read() {
        if (!this.refill()) {
            return -1;
        }
        return this.byteBuffer.get() & 0xFF;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.refill()) {
            return -1;
        }
        n2 = Math.min(n2, this.byteBuffer.remaining());
        this.byteBuffer.get(byArray, n, n2);
        return n2;
    }

    private boolean refill() {
        if (!this.byteBuffer.hasRemaining()) {
            this.byteBuffer.clear();
            int n = 0;
            while (n == 0) {
                n = this.fileChannel.read(this.byteBuffer);
            }
            this.byteBuffer.flip();
            return n >= 0;
        }
        return true;
    }

    @Override
    public synchronized long skip(long l) {
        if (l <= 0L) {
            return 0L;
        }
        if ((long)this.byteBuffer.remaining() >= l) {
            this.byteBuffer.position(this.byteBuffer.position() + (int)l);
            return l;
        }
        long l2 = this.byteBuffer.remaining();
        long l3 = l - l2;
        this.byteBuffer.position(0);
        this.byteBuffer.flip();
        return l2 + this.skipFromFileChannel(l3);
    }

    private long skipFromFileChannel(long l) {
        long l2 = this.fileChannel.position();
        long l3 = this.fileChannel.size();
        if (l > l3 - l2) {
            this.fileChannel.position(l3);
            return l3 - l2;
        }
        this.fileChannel.position(l2 + l);
        return l;
    }
}

