/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.Writer;
import java.util.Objects;

public class AppendableWriter<T extends Appendable>
extends Writer {
    private final T appendable;

    public AppendableWriter(T t) {
        this.appendable = t;
    }

    @Override
    public Writer append(char c2) {
        this.appendable.append(c2);
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence) {
        this.appendable.append(charSequence);
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence, int n, int n2) {
        this.appendable.append(charSequence, n, n2);
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    public T getAppendable() {
        return this.appendable;
    }

    @Override
    public void write(char[] cArray, int n, int n2) {
        Objects.requireNonNull(cArray, "Character array is missing");
        if (n2 < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException("Array Size=" + cArray.length + ", offset=" + n + ", length=" + n2);
        }
        for (int i = 0; i < n2; ++i) {
            this.appendable.append(cArray[n + i]);
        }
    }

    @Override
    public void write(int n) {
        this.appendable.append((char)n);
    }

    @Override
    public void write(String string, int n, int n2) {
        Objects.requireNonNull(string, "String is missing");
        this.appendable.append(string, n, n + n2);
    }
}

