/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.commands.executors.boxes;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.commands.Command;
import com.xericker.mysteryboxes.commands.CommandInterface;
import com.xericker.mysteryboxes.commands.CommandUtils;
import com.xericker.mysteryboxes.config.files.LanguageValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.handlers.data.boxes.Box;
import com.xericker.mysteryboxes.handlers.data.boxes.BoxManager;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import com.xericker.mysteryboxes.playerdata.player.PlayerIdentifier;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import utils.PluginUtils;

public class ExecuteRBoxUpdater
implements CommandInterface {
    @Override
    public boolean execute(CommandSender commandSender, Command command, String[] stringArray) {
        int n;
        if (stringArray.length < 3) {
            CommandUtils.sendMessage(commandSender, "Oops! Some arguments are missing!", command);
            return false;
        }
        if (BoxManager.getList().isEmpty()) {
            CommandUtils.sendMessage(commandSender, "There are no Mystery Boxes registered!", command);
            return false;
        }
        String string = stringArray[1];
        Player player = Bukkit.getPlayer((String)string);
        if (player == null && PlayerIdentifier.getId(string) == null) {
            for (String string2 : ConfigParser.getStringList(LanguageValue.GENERAL_PLAYER_NOT_FOUND)) {
                commandSender.sendMessage(string2);
            }
            return false;
        }
        if (player != null) {
            string = player.getName();
            player.closeInventory();
        }
        UUID uUID = player != null ? player.getUniqueId() : PlayerIdentifier.getId(string);
        PlayerData playerData = PlayerDataManager.getData(uUID);
        List<Box> list = BoxManager.getList();
        Box box = list.get(Main.getRandom().nextInt(list.size()));
        String string3 = stringArray[2];
        if (string3.contains("-")) {
            String[] stringArray2 = string3.split("-");
            if (string3.length() < 2 || !PluginUtils.isInteger(stringArray2[0]) || !PluginUtils.isInteger(stringArray2[1])) {
                String[] stringArray3 = new String[]{"The [range] argument is invalid!", "The range must be: [number (from)]-[number (to)]"};
                CommandUtils.sendMessage(commandSender, stringArray3, command);
                return false;
            }
            int n2 = Integer.parseInt(stringArray2[0]);
            int n3 = Integer.parseInt((String)stringArray2[1]);
            if (n2 <= 0 || n3 <= 0 || n2 > n3) {
                String[] stringArray4 = new String[]{"The [range] argument is invalid!", "The range must be: [number (from)]-[number (to)]"};
                CommandUtils.sendMessage(commandSender, stringArray4, command);
                return false;
            }
            n = PluginUtils.getRandomInt(n2, n3);
        } else {
            if (!PluginUtils.isInteger(stringArray[2])) {
                CommandUtils.sendMessage(commandSender, "The [amount] argument must be a number!", command);
                return false;
            }
            n = Integer.parseInt(stringArray[2]);
        }
        playerData.setBoxes(box, playerData.getBoxes(box) + n);
        for (String string4 : ConfigParser.getStringList(LanguageValue.BOX_RANDOM_ADD)) {
            string4 = string4.replace("{PLAYER}", string);
            string4 = string4.replace("{AMOUNT}", String.valueOf(n));
            commandSender.sendMessage(string4);
        }
        return false;
    }
}

