/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.commands.executors.dust;

import com.xericker.mysteryboxes.Main;
import com.xericker.mysteryboxes.commands.Command;
import com.xericker.mysteryboxes.commands.CommandInterface;
import com.xericker.mysteryboxes.commands.CommandUtils;
import com.xericker.mysteryboxes.config.files.LanguageValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.handlers.placeholders.GeneralPlaceholders;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import utils.PluginUtils;

public class ExecuteDustUpdater
implements CommandInterface {
    @Override
    public boolean execute(CommandSender commandSender, Command command, String[] stringArray) {
        if (stringArray.length < 3) {
            CommandUtils.sendMessage(commandSender, "Oops! Some arguments are missing!", command);
            return false;
        }
        if (!PluginUtils.isInteger(stringArray[2])) {
            CommandUtils.sendMessage(commandSender, "The [amount] argument must be a number!", command);
            return false;
        }
        int n = Integer.parseInt(stringArray[2]);
        PlayerData playerData = CommandUtils.getPlayerData(commandSender, stringArray[1]);
        if (playerData == null) {
            return false;
        }
        Player player = Bukkit.getPlayer((UUID)playerData.getPlayerId());
        String string = player != null ? player.getName() : stringArray[1];
        long l = System.currentTimeMillis();
        if (!playerData.isDataSynced()) {
            commandSender.sendMessage("\u00a77[\u00a7dMB\u00a77] \u00a7r\u00a7eGathering information about the player...");
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getPlugin(), () -> {
            do {
                long l2;
                if ((l2 = System.currentTimeMillis()) - l < 5000L) continue;
                commandSender.sendMessage("\u00a77[\u00a7dMB\u00a77] \u00a7r\u00a7cFailed to gather information about the player!");
                return;
            } while (!playerData.isDataSynced());
            List<Object> list = new ArrayList();
            switch (command) {
                case SETDUST: {
                    playerData.setDust(n);
                    list = ConfigParser.getStringList(LanguageValue.DUST_SET);
                    break;
                }
                case ADDDUST: {
                    playerData.setDust(playerData.getDust() + n);
                    list = ConfigParser.getStringList(LanguageValue.DUST_ADD);
                    break;
                }
                case REMOVEDUST: {
                    playerData.setDust(playerData.getDust() - n);
                    list = ConfigParser.getStringList(LanguageValue.DUST_REMOVE);
                }
            }
            for (String string2 : list) {
                string2 = GeneralPlaceholders.translate((Object)playerData.getPlayerId(), string2);
                string2 = string2.replace("{PLAYER}", string);
                string2 = string2.replace("{AMOUNT}", String.valueOf(n));
                commandSender.sendMessage(string2);
            }
            if (player == null) {
                PlayerDataManager.saveData(playerData, true, true);
            }
        });
        return false;
    }
}

