/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.compiled;

import com.xericker.mysteryboxes.compiled.NBTCompound;
import com.xericker.mysteryboxes.compiled.NBTCompoundList;
import com.xericker.mysteryboxes.compiled.NBTContainer;
import com.xericker.mysteryboxes.compiled.NBTListCompound;
import com.xericker.mysteryboxes.compiled.NBTReflectionUtil;
import com.xericker.mysteryboxes.compiled.NbtApiException;
import com.xericker.mysteryboxes.compiled.iface.ReadWriteItemNBT;
import com.xericker.mysteryboxes.compiled.iface.ReadWriteNBT;
import com.xericker.mysteryboxes.compiled.iface.ReadableNBT;
import com.xericker.mysteryboxes.compiled.utils.nmsmappings.ClassWrapper;
import com.xericker.mysteryboxes.compiled.utils.nmsmappings.ReflectionMethod;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class NBTItem
extends NBTCompound
implements ReadWriteItemNBT {
    private ItemStack bukkitItem;
    private final boolean directApply;
    private final boolean finalizer;
    private ItemStack originalSrcStack = null;
    private Object cachedCompound = null;
    private boolean closed = false;

    public NBTItem(ItemStack itemStack) {
        this(itemStack, false);
    }

    protected NBTItem(ItemStack itemStack, boolean bl, boolean bl2, boolean bl3) {
        super(null, null, bl2);
        if (itemStack == null || itemStack.getType() == Material.AIR || itemStack.getAmount() <= 0) {
            throw new NullPointerException("ItemStack can't be null/air/amount of 0! This is not a NBTAPI bug!");
        }
        this.finalizer = bl3;
        if (bl3) {
            this.bukkitItem = itemStack;
            this.originalSrcStack = itemStack;
            this.directApply = false;
        } else if (bl2) {
            this.bukkitItem = itemStack;
            this.directApply = false;
        } else {
            this.directApply = bl;
            this.bukkitItem = itemStack.clone();
            if (bl) {
                this.originalSrcStack = itemStack;
            }
        }
    }

    @Deprecated
    public NBTItem(ItemStack itemStack, boolean bl) {
        super(null, null);
        if (itemStack == null || itemStack.getType() == Material.AIR || itemStack.getAmount() <= 0) {
            throw new NullPointerException("ItemStack can't be null/air/amount of 0! This is not a NBTAPI bug!");
        }
        this.finalizer = false;
        this.directApply = bl;
        this.bukkitItem = itemStack.clone();
        if (bl) {
            this.originalSrcStack = itemStack;
        }
    }

    @Override
    public Object getCompound() {
        if (this.closed) {
            throw new NbtApiException("Tried using closed NBT data!");
        }
        if (this.isReadOnly() && (this.cachedCompound != null || ClassWrapper.CRAFT_ITEMSTACK.getClazz().isAssignableFrom(this.bukkitItem.getClass()))) {
            if (this.cachedCompound == null) {
                this.cachedCompound = NBTReflectionUtil.getItemRootNBTTagCompound(NBTReflectionUtil.getCraftItemHandle(this.bukkitItem));
            }
            return this.cachedCompound;
        }
        if (this.finalizer) {
            if (this.cachedCompound == null) {
                this.updateCachedCompound();
            }
            return this.cachedCompound;
        }
        return NBTReflectionUtil.getItemRootNBTTagCompound(ReflectionMethod.ITEMSTACK_NMSCOPY.run(null, this.bukkitItem));
    }

    private void updateCachedCompound() {
        if (this.finalizer) {
            this.cachedCompound = NBTReflectionUtil.getItemRootNBTTagCompound(ReflectionMethod.ITEMSTACK_NMSCOPY.run(null, this.bukkitItem));
        }
    }

    protected void finalizeChanges() {
        if (!this.finalizer || this.cachedCompound == null) {
            return;
        }
        if (NBTReflectionUtil.getKeys(this).isEmpty()) {
            this.cachedCompound = null;
        }
        if (ClassWrapper.CRAFT_ITEMSTACK.getClazz().isAssignableFrom(this.originalSrcStack.getClass())) {
            Object object = NBTReflectionUtil.getCraftItemHandle(this.originalSrcStack);
            ReflectionMethod.ITEMSTACK_SET_TAG.run(object, this.cachedCompound);
            this.bukkitItem = this.originalSrcStack;
        } else {
            Object object = ReflectionMethod.ITEMSTACK_NMSCOPY.run(null, this.bukkitItem);
            ReflectionMethod.ITEMSTACK_SET_TAG.run(object, this.cachedCompound);
            this.bukkitItem = (ItemStack)ReflectionMethod.ITEMSTACK_BUKKITMIRROR.run(null, object);
            this.originalSrcStack.setItemMeta(this.bukkitItem.getItemMeta());
        }
    }

    @Override
    protected void setClosed() {
        this.closed = true;
    }

    @Override
    protected boolean isClosed() {
        return this.closed;
    }

    @Override
    protected void setCompound(Object object) {
        if (this.isReadOnly()) {
            throw new NbtApiException("Tried setting data in read only mode!");
        }
        if (this.closed) {
            throw new NbtApiException("Tried using closed NBT data!");
        }
        if (this.finalizer) {
            this.cachedCompound = object;
            return;
        }
        if (object != null && ((Set)ReflectionMethod.COMPOUND_GET_KEYS.run(object, new Object[0])).isEmpty()) {
            object = null;
        }
        if (ClassWrapper.CRAFT_ITEMSTACK.getClazz().isAssignableFrom(this.bukkitItem.getClass())) {
            Object object2 = NBTReflectionUtil.getCraftItemHandle(this.bukkitItem);
            ReflectionMethod.ITEMSTACK_SET_TAG.run(object2, object);
        } else {
            Object object3 = ReflectionMethod.ITEMSTACK_NMSCOPY.run(null, this.bukkitItem);
            ReflectionMethod.ITEMSTACK_SET_TAG.run(object3, object);
            this.bukkitItem = (ItemStack)ReflectionMethod.ITEMSTACK_BUKKITMIRROR.run(null, object3);
        }
    }

    public void applyNBT(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            throw new NullPointerException("ItemStack can't be null/Air! This is not a NBTAPI bug!");
        }
        NBTItem nBTItem = new NBTItem(new ItemStack(itemStack.getType()));
        nBTItem.mergeCompound(this);
        itemStack.setItemMeta(nBTItem.getItem().getItemMeta());
    }

    public void mergeNBT(ItemStack itemStack) {
        NBTItem nBTItem = new NBTItem(itemStack);
        nBTItem.mergeCompound(this);
        itemStack.setItemMeta(nBTItem.getItem().getItemMeta());
    }

    public void mergeCustomNBT(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            throw new NullPointerException("ItemStack can't be null/Air!");
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        NBTReflectionUtil.getUnhandledNBTTags(itemMeta).putAll(NBTReflectionUtil.getUnhandledNBTTags(this.bukkitItem.getItemMeta()));
        itemStack.setItemMeta(itemMeta);
    }

    @Override
    public boolean hasCustomNbtData() {
        this.finalizeChanges();
        ItemMeta itemMeta = this.bukkitItem.getItemMeta();
        return !NBTReflectionUtil.getUnhandledNBTTags(itemMeta).isEmpty();
    }

    @Override
    public void clearCustomNBT() {
        this.finalizeChanges();
        ItemMeta itemMeta = this.bukkitItem.getItemMeta();
        NBTReflectionUtil.getUnhandledNBTTags(itemMeta).clear();
        this.bukkitItem.setItemMeta(itemMeta);
        this.updateCachedCompound();
    }

    public ItemStack getItem() {
        return this.bukkitItem;
    }

    protected void setItem(ItemStack itemStack) {
        this.bukkitItem = itemStack;
    }

    @Override
    public boolean hasNBTData() {
        return this.getCompound() != null;
    }

    @Override
    public void modifyMeta(BiConsumer<ReadableNBT, ItemMeta> biConsumer) {
        this.finalizeChanges();
        ItemMeta itemMeta = this.bukkitItem.getItemMeta();
        biConsumer.accept(new NBTContainer(this.getResolvedObject()).setReadOnly(true), itemMeta);
        this.bukkitItem.setItemMeta(itemMeta);
        this.updateCachedCompound();
        if (this.directApply) {
            this.applyNBT(this.originalSrcStack);
        }
    }

    @Override
    public <T extends ItemMeta> void modifyMeta(Class<T> clazz, BiConsumer<ReadableNBT, T> biConsumer) {
        this.finalizeChanges();
        ItemMeta itemMeta = this.bukkitItem.getItemMeta();
        biConsumer.accept(new NBTContainer(this.getResolvedObject()).setReadOnly(true), (ReadableNBT)itemMeta);
        this.bukkitItem.setItemMeta(itemMeta);
        this.updateCachedCompound();
        if (this.directApply) {
            this.applyNBT(this.originalSrcStack);
        }
    }

    public static NBTContainer convertItemtoNBT(ItemStack itemStack) {
        return NBTReflectionUtil.convertNMSItemtoNBTCompound(ReflectionMethod.ITEMSTACK_NMSCOPY.run(null, itemStack));
    }

    @Nullable
    public static ItemStack convertNBTtoItem(NBTCompound nBTCompound) {
        return (ItemStack)ReflectionMethod.ITEMSTACK_BUKKITMIRROR.run(null, NBTReflectionUtil.convertNBTCompoundtoNMSItem(nBTCompound));
    }

    public static NBTContainer convertItemArraytoNBT(ItemStack[] itemStackArray) {
        NBTContainer nBTContainer = new NBTContainer();
        nBTContainer.setInteger("size", itemStackArray.length);
        NBTCompoundList nBTCompoundList = nBTContainer.getCompoundList("items");
        for (int i = 0; i < itemStackArray.length; ++i) {
            ItemStack itemStack = itemStackArray[i];
            if (itemStack == null || itemStack.getType() == Material.AIR) continue;
            NBTListCompound nBTListCompound = nBTCompoundList.addCompound();
            nBTListCompound.setInteger("Slot", i);
            nBTListCompound.mergeCompound(NBTItem.convertItemtoNBT(itemStack));
        }
        return nBTContainer;
    }

    @Nullable
    public static ItemStack[] convertNBTtoItemArray(NBTCompound nBTCompound) {
        if (!nBTCompound.hasTag("size")) {
            return null;
        }
        ItemStack[] itemStackArray = new ItemStack[nBTCompound.getInteger("size").intValue()];
        for (int i = 0; i < itemStackArray.length; ++i) {
            itemStackArray[i] = new ItemStack(Material.AIR);
        }
        if (!nBTCompound.hasTag("items")) {
            return itemStackArray;
        }
        NBTCompoundList nBTCompoundList = nBTCompound.getCompoundList("items");
        for (ReadWriteNBT readWriteNBT : nBTCompoundList) {
            if (!(readWriteNBT instanceof NBTCompound)) continue;
            int n = readWriteNBT.getInteger("Slot");
            itemStackArray[n] = NBTItem.convertNBTtoItem((NBTCompound)readWriteNBT);
        }
        return itemStackArray;
    }

    @Override
    protected void saveCompound() {
        if (this.directApply) {
            this.applyNBT(this.originalSrcStack);
        }
    }
}

