/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.core.vaults.holograms.animations;

import com.xericker.mysteryboxes.core.vaults.holograms.animations.AnimationData;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class HologramAnimation {
    private String path;
    private FileConfiguration configFile;
    private int animationStep;
    private List<String> displayOrder;
    private List<AnimationData> dataRequired;
    private String id;
    private String display;

    public HologramAnimation(String string, String string2, FileConfiguration fileConfiguration) {
        this.id = string;
        this.path = string2;
        this.configFile = fileConfiguration;
    }

    public void register() {
        this.animationStep = -1;
        this.displayOrder = this.configFile.getStringList(this.path + ".display-order");
        this.dataRequired = new ArrayList<AnimationData>();
        String string = this.configFile.getString(this.path + ".data-required");
        if (string != null) {
            Set set = Arrays.stream(AnimationData.values()).map(Enum::name).collect(Collectors.toSet());
            for (String string2 : string.split(",")) {
                if (!set.contains(string2.trim().toUpperCase())) continue;
                this.dataRequired.add(AnimationData.valueOf(string2.trim().toUpperCase()));
            }
        }
    }

    public void next() {
        if (this.displayOrder.size() == 9) {
            return;
        }
        ++this.animationStep;
        if (this.animationStep == this.displayOrder.size()) {
            this.animationStep = 0;
        }
        this.display = this.displayOrder.get(this.animationStep);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplay() {
        return this.display;
    }

    public boolean validateData(Player player) {
        PlayerData playerData = PlayerDataManager.getData(player);
        if (!this.dataRequired.contains((Object)AnimationData.SYNCING_DATA) && !playerData.isDataSynced()) {
            return false;
        }
        boolean bl = true;
        for (AnimationData animationData : this.dataRequired) {
            switch (animationData) {
                case BOXES: {
                    bl = playerData.getBoxesAvailable() > 0;
                    break;
                }
                case GIFTS: {
                    bl = playerData.getGiftsAvailable() > 0;
                    break;
                }
                case DUST: {
                    bl = playerData.getDust() > 0;
                    break;
                }
                case SYNCING_DATA: {
                    boolean bl2 = bl = !playerData.isDataSynced();
                }
            }
            if (bl) continue;
            break;
        }
        return bl;
    }
}

