/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.events;

import com.xericker.mysteryboxes.core.vaults.Vault;
import com.xericker.mysteryboxes.core.vaults.VaultAction;
import com.xericker.mysteryboxes.core.vaults.editor.EditorHandler;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;

public class EventPlayerInteract
implements Listener {
    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.getAction() != Action.LEFT_CLICK_BLOCK && playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK || playerInteractEvent.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        PlayerData playerData = PlayerDataManager.getData(player);
        Block block = playerInteractEvent.getClickedBlock();
        if (block == null || block.isLiquid()) {
            return;
        }
        Location location = block.getLocation();
        if (playerData.getVaultAction() == VaultAction.VAULT_EDITOR && playerInteractEvent.getAction() == Action.LEFT_CLICK_BLOCK) {
            EditorHandler.removeVault(player, location);
            playerInteractEvent.setCancelled(true);
            return;
        }
        if (playerData.getVaultAction() == VaultAction.VAULT_EDITOR && playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK) {
            EditorHandler.createVault(player, location);
            playerInteractEvent.setCancelled(true);
            return;
        }
        if (Vault.interact(player, location)) {
            playerInteractEvent.setCancelled(true);
        }
    }
}

