/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.handlers.data.upgrades;

import com.xericker.mysteryboxes.config.files.ConfigValue;
import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeData;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeInterface;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeManager;
import com.xericker.mysteryboxes.handlers.data.upgrades.data.DustCollectorUpgrade;
import com.xericker.mysteryboxes.handlers.data.upgrades.data.TimeBoxUpgrade;
import com.xericker.mysteryboxes.handlers.data.upgrades.data.TreasureHunterUpgrade;
import com.xericker.mysteryboxes.playerdata.player.PlayerData;
import com.xericker.mysteryboxes.playerdata.player.PlayerDataManager;
import java.util.UUID;
import libraries.ConfigAPI;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public enum Upgrade {
    TIME_BOX(TimeBoxUpgrade.class),
    DUST_COLLECTOR(DustCollectorUpgrade.class),
    TREASURE_HUNTER(TreasureHunterUpgrade.class);

    private final Class<? extends UpgradeInterface> classInstance;

    private Upgrade(Class<? extends UpgradeInterface> clazz) {
        this.classInstance = clazz;
    }

    public String getId() {
        return this.name().toLowerCase().replace("_", "-");
    }

    public String getConfigId() {
        return "upgrade_" + this.getId();
    }

    public FileConfiguration getConfig() {
        ConfigAPI.Config config = ConfigAPI.getConfig(this.getConfigId());
        if (config == null) {
            return null;
        }
        return config.getFileConfig();
    }

    public Class<? extends UpgradeInterface> getClassInstance() {
        return this.classInstance;
    }

    public boolean hasPermission(Player player) {
        String string = "mysteryboxes.upgrade.*";
        String string2 = string.replace("*", "") + this.getId();
        return player.hasPermission(string) || player.hasPermission(string2);
    }

    public boolean canUpgrade(Object object) {
        UUID uUID;
        UpgradeData upgradeData = UpgradeManager.getData(this);
        if (upgradeData == null) {
            return false;
        }
        PlayerData playerData = PlayerDataManager.getData(object instanceof UUID ? (uUID = (UUID)object) : ((Player)object).getUniqueId());
        int n = playerData.getUpgrade(this);
        return n < upgradeData.getInterface().getMaxLevel();
    }

    public int getDustCost(Object object) {
        UUID uUID;
        Object object2;
        UpgradeData upgradeData = UpgradeManager.getData(this);
        if (upgradeData == null) {
            return 0;
        }
        if (object instanceof UUID) {
            object2 = (UUID)object;
            uUID = object2;
        } else {
            uUID = ((Player)object).getUniqueId();
        }
        PlayerData playerData = PlayerDataManager.getData(uUID);
        object2 = upgradeData.getInterface().getDustMap();
        int n = playerData.getUpgrade(this);
        if (n < 0) {
            n = 0;
        }
        if (n >= object2.size()) {
            n = object2.size() - 1;
        }
        return (Integer)object2.get(n);
    }

    public boolean hasDust(Object object) {
        UUID uUID;
        UpgradeData upgradeData = UpgradeManager.getData(this);
        if (upgradeData == null) {
            return false;
        }
        PlayerData playerData = PlayerDataManager.getData(object instanceof UUID ? (uUID = (UUID)object) : ((Player)object).getUniqueId());
        boolean bl = playerData.getDust() >= this.getDustCost(object);
        boolean bl2 = ConfigParser.getBoolean(ConfigValue.UNLOCK_DUST);
        return bl2 || bl;
    }
}

