/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.handlers.data.upgrades;

import com.xericker.mysteryboxes.config.handlers.ConfigParser;
import com.xericker.mysteryboxes.handlers.data.upgrades.Upgrade;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeInterface;
import com.xericker.mysteryboxes.handlers.data.upgrades.UpgradeStatus;
import java.lang.reflect.Constructor;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;

public class UpgradeData {
    private FileConfiguration configFile;
    private Upgrade upgrade;
    private UpgradeStatus upgradeStatus;
    private UpgradeInterface upgradeInterface;
    private GeneralSettings generalSettings;
    private IconBuilder iconBuilder;

    public UpgradeData(Upgrade upgrade, FileConfiguration fileConfiguration) {
        this.configFile = fileConfiguration;
        this.upgrade = upgrade;
        this.upgradeStatus = UpgradeStatus.ENABLED;
        this.generalSettings = new GeneralSettings();
        if (this.upgradeStatus != UpgradeStatus.ERROR_GENERAL_SETTINGS && !this.generalSettings.enabled) {
            this.upgradeStatus = UpgradeStatus.DISABLED;
        }
        if (this.upgradeStatus == UpgradeStatus.ERROR_GENERAL_SETTINGS) {
            return;
        }
        this.iconBuilder = new IconBuilder();
        try {
            Class<? extends UpgradeInterface> clazz = this.upgrade.getClassInstance();
            Constructor<? extends UpgradeInterface> constructor = clazz.getConstructor(Upgrade.class);
            this.upgradeInterface = constructor.newInstance(new Object[]{upgrade});
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public FileConfiguration getConfigFile() {
        return this.configFile;
    }

    public Upgrade getUpgrade() {
        return this.upgrade;
    }

    public UpgradeStatus getStatus() {
        return this.upgradeStatus;
    }

    public UpgradeInterface getInterface() {
        return this.upgradeInterface;
    }

    public GeneralSettings getGeneralSettings() {
        return this.generalSettings;
    }

    public IconBuilder getIconBuilder() {
        return this.iconBuilder;
    }

    public class GeneralSettings {
        public boolean enabled;
        public String name;
        public List<String> description;

        GeneralSettings() {
            try {
                String string = "general-settings.";
                this.enabled = UpgradeData.this.configFile.getBoolean(string + "enabled");
                this.description = ConfigParser.getStringList(UpgradeData.this.configFile, string + "description");
                this.name = ConfigParser.getString(UpgradeData.this.configFile, string + "name");
                if (this.name.isEmpty()) {
                    this.name = "\u00a7c\u26a0 The name is null";
                    UpgradeData.this.upgradeStatus = UpgradeStatus.ERROR_GENERAL_SETTINGS;
                }
            }
            catch (Exception exception) {
                UpgradeData.this.upgradeStatus = UpgradeStatus.ERROR_GENERAL_SETTINGS;
            }
        }
    }

    public class IconBuilder {
        public Material type;
        public boolean glow;
        public int amount;
        public int model;
        public String head;

        IconBuilder() {
            try {
                String string = "icon-builder.";
                this.type = Material.matchMaterial((String)ConfigParser.getString(UpgradeData.this.configFile, string + "type"));
                if (this.type == null) {
                    UpgradeData.this.upgradeStatus = UpgradeStatus.ERROR_ITEM_SETTINGS;
                }
                this.glow = UpgradeData.this.configFile.getBoolean(string + "glow");
                this.amount = UpgradeData.this.configFile.getInt(string + "amount");
                this.model = UpgradeData.this.configFile.getInt(string + "model");
                this.head = UpgradeData.this.configFile.getString(string + "head");
                if (this.head == null || this.head.isEmpty()) {
                    this.head = UpgradeData.this.configFile.getString(string + "custom-head");
                }
            }
            catch (Exception exception) {
                UpgradeData.this.upgradeStatus = UpgradeStatus.ERROR_ITEM_SETTINGS;
            }
        }
    }
}

