/*
 * Decompiled with CFR 0.152.
 */
package com.xericker.mysteryboxes.menus.menus.craftboxes;

import com.xericker.mysteryboxes.handlers.data.boxes.Box;
import com.xericker.mysteryboxes.handlers.data.boxes.BoxManager;
import com.xericker.mysteryboxes.handlers.placeholders.CraftPlaceholders;
import com.xericker.mysteryboxes.menus.Menu;
import com.xericker.mysteryboxes.menus.MenuBuilder;
import com.xericker.mysteryboxes.menus.MenuTrigger;
import com.xericker.mysteryboxes.playerdata.menus.MenuData;
import com.xericker.mysteryboxes.playerdata.menus.MenuDataManager;
import java.util.Objects;
import misc.ItemNBT;
import misc.MenuSound;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class MenuEventCraftBoxes
implements Listener {
    @EventHandler
    public void onInventoryClick(InventoryClickEvent inventoryClickEvent) {
        Object object;
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        MenuData menuData = MenuDataManager.getData(player);
        MenuBuilder menuBuilder = menuData.getMenu();
        if (menuData.getCurrentType() != Menu.CRAFT_BOXES) {
            return;
        }
        ItemStack itemStack = inventoryClickEvent.getCurrentItem();
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return;
        }
        if (inventoryClickEvent.getClickedInventory() == null || inventoryClickEvent.getClickedInventory() != inventoryClickEvent.getInventory()) {
            return;
        }
        if (inventoryClickEvent.getAction() != InventoryAction.PICKUP_ALL && inventoryClickEvent.getAction() != InventoryAction.PICKUP_HALF) {
            return;
        }
        if (ItemNBT.contains(itemStack, "itemTrigger")) {
            object = ItemNBT.getString(itemStack, "itemTrigger");
            if (Objects.equals(object, MenuTrigger.PREVIOUS_PAGE.name())) {
                menuBuilder.setPage(menuBuilder.getPage() - 1);
                menuBuilder.update();
                MenuSound.SUCCESS.play(player);
            }
            if (Objects.equals(object, MenuTrigger.NEXT_PAGE.name())) {
                menuBuilder.setPage(menuBuilder.getPage() + 1);
                menuBuilder.update();
                MenuSound.SUCCESS.play(player);
            }
        }
        if (!ItemNBT.contains(itemStack, "boxId")) {
            return;
        }
        object = BoxManager.getBox(ItemNBT.getString(itemStack, "boxId"));
        boolean bl = CraftPlaceholders.sendMessage(player, (Box)object);
        if (!bl) {
            MenuSound.ERROR.play(player);
            return;
        }
        ((Box)object).craftBox(player);
        player.closeInventory();
    }
}

