/*
 * Decompiled with CFR 0.152.
 */
package libraries;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigAPI {
    private static List<Config> configs = new ArrayList<Config>();

    public static List<Config> getConfigs() {
        return configs;
    }

    public static Config getConfig(String string) {
        for (Config config : configs) {
            if (!config.getConfigId().equals(string)) continue;
            return config;
        }
        return null;
    }

    public static Config registerConfig(String string, String string2, String string3, boolean bl, JavaPlugin javaPlugin) {
        return ConfigAPI.registerConfig(string, null, string2, string3, bl, javaPlugin);
    }

    public static Config registerConfig(String string, String string2, String string3, String string4, boolean bl, JavaPlugin javaPlugin) {
        try {
            File file = new File(string4, string3);
            InputStream inputStream = javaPlugin.getResource((String)(string2 != null ? string2 + string3 : string3));
            if (bl && !file.exists() && inputStream != null) {
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdirs();
                }
                ConfigAPI.copyConfig(inputStream, file);
            }
            Config config = new Config(string, file);
            for (Config config2 : configs) {
                if (!config2.equals(config)) continue;
                return config;
            }
            configs.add(config);
            return config;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void unregisterConfig(String string) {
        configs.remove(ConfigAPI.getConfig(string));
    }

    public static void saveConfigs() {
        try {
            for (Config config : configs) {
                config.save();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void saveConfig(String string) {
        Config config = ConfigAPI.getConfig(string);
        if (config == null) {
            return;
        }
        try {
            config.save();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void loadConfigs() {
        try {
            for (Config config : configs) {
                config.load();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void loadConfig(String string) {
        Config config = ConfigAPI.getConfig(string);
        if (config == null) {
            return;
        }
        try {
            config.load();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void copyConfig(InputStream inputStream, File file) {
        try (InputStream inputStream2 = inputStream;
             FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int n;
            byte[] byArray = new byte[1024];
            while ((n = inputStream2.read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
        }
    }

    public static void clearConfig(String string) {
        Config config = ConfigAPI.getConfig(string);
        if (config == null) {
            return;
        }
        configs.remove(config);
        configs.add(new Config(config.getConfigId(), config.getFile()));
    }

    public static class Config {
        private String configId;
        private File file;
        private FileConfiguration fileConfig;

        private Config(String string, File file) {
            this.configId = string;
            this.file = file;
            this.fileConfig = YamlConfiguration.loadConfiguration((File)file);
        }

        public String getConfigId() {
            return this.configId;
        }

        public File getFile() {
            return this.file;
        }

        public FileConfiguration getFileConfig() {
            return this.fileConfig;
        }

        public boolean equals(Config config) {
            return config.getConfigId().equals(this.configId);
        }

        public void save() {
            this.fileConfig.save(this.file);
        }

        public void load() {
            this.fileConfig.load(this.file);
        }
    }
}

