/*
 * Decompiled with CFR 0.152.
 */
package libraries;

import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;

public class RandomCollection<E> {
    private final NavigableMap<Double, E> NAVIGABLE_MAP = new TreeMap<Double, E>();
    private final Random RANDOM;
    private double total = 0.0;

    public RandomCollection() {
        this(new Random());
    }

    public RandomCollection(Random random) {
        this.RANDOM = random;
    }

    public void add(double d, E e) {
        if (d <= 0.0) {
            return;
        }
        this.total += d;
        this.NAVIGABLE_MAP.put(this.total, e);
    }

    public E next() {
        double d = this.RANDOM.nextDouble() * this.total;
        return this.NAVIGABLE_MAP.higherEntry(d).getValue();
    }
}

