/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.adapters;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.reflections.ReflectionUtils;
import org.reflections.adapters.MetadataAdapter;
import org.reflections.util.Utils;
import org.reflections.vfs.Vfs;

public class JavaReflectionAdapter
implements MetadataAdapter<Class, Field, Member> {
    @Override
    public List<Field> getFields(Class clazz) {
        return Arrays.asList(clazz.getDeclaredFields());
    }

    @Override
    public List<Member> getMethods(Class clazz) {
        ArrayList<Member> arrayList = new ArrayList<Member>();
        arrayList.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        arrayList.addAll(Arrays.asList(clazz.getDeclaredConstructors()));
        return arrayList;
    }

    @Override
    public String getMethodName(Member member) {
        return member instanceof Method ? member.getName() : (member instanceof Constructor ? "<init>" : null);
    }

    @Override
    public List<String> getParameterNames(Member member) {
        Class<?>[] classArray = member instanceof Method ? ((Method)member).getParameterTypes() : (member instanceof Constructor ? ((Constructor)member).getParameterTypes() : null);
        return classArray != null ? Arrays.stream(classArray).map(JavaReflectionAdapter::getName).collect(Collectors.toList()) : Collections.emptyList();
    }

    @Override
    public List<String> getClassAnnotationNames(Class clazz) {
        return this.getAnnotationNames(clazz.getDeclaredAnnotations());
    }

    @Override
    public List<String> getFieldAnnotationNames(Field field) {
        return this.getAnnotationNames(field.getDeclaredAnnotations());
    }

    @Override
    public List<String> getMethodAnnotationNames(Member member) {
        Annotation[] annotationArray = member instanceof Method ? ((Method)member).getDeclaredAnnotations() : (member instanceof Constructor ? ((Constructor)member).getDeclaredAnnotations() : null);
        return this.getAnnotationNames(annotationArray);
    }

    @Override
    public List<String> getParameterAnnotationNames(Member member, int n) {
        Annotation[][] annotationArray = member instanceof Method ? ((Method)member).getParameterAnnotations() : (member instanceof Constructor ? ((Constructor)member).getParameterAnnotations() : (Annotation[][])null);
        return this.getAnnotationNames(annotationArray != null ? annotationArray[n] : null);
    }

    @Override
    public String getReturnTypeName(Member member) {
        return ((Method)member).getReturnType().getName();
    }

    @Override
    public String getFieldName(Field field) {
        return field.getName();
    }

    @Override
    public Class getOrCreateClassObject(Vfs.File file) {
        return this.getOrCreateClassObject(file, null);
    }

    public Class getOrCreateClassObject(Vfs.File file, ClassLoader ... classLoaderArray) {
        String string = file.getRelativePath().replace("/", ".").replace(".class", "");
        return ReflectionUtils.forName(string, classLoaderArray);
    }

    @Override
    public String getMethodModifier(Member member) {
        return Modifier.toString(member.getModifiers());
    }

    @Override
    public String getMethodKey(Class clazz, Member member) {
        return this.getMethodName(member) + "(" + Utils.join(this.getParameterNames(member), ", ") + ")";
    }

    @Override
    public String getMethodFullKey(Class clazz, Member member) {
        return this.getClassName(clazz) + "." + this.getMethodKey(clazz, member);
    }

    @Override
    public boolean isPublic(Object object) {
        Integer n = object instanceof Class ? ((Class)object).getModifiers() : (object instanceof Member ? Integer.valueOf(((Member)object).getModifiers()) : null).intValue();
        return n != null && Modifier.isPublic(n);
    }

    @Override
    public String getClassName(Class clazz) {
        return clazz.getName();
    }

    @Override
    public String getSuperclassName(Class clazz) {
        Class clazz2 = clazz.getSuperclass();
        return clazz2 != null ? clazz2.getName() : "";
    }

    @Override
    public List<String> getInterfacesNames(Class clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        return classArray != null ? Arrays.stream(classArray).map(Class::getName).collect(Collectors.toList()) : Collections.emptyList();
    }

    @Override
    public boolean acceptsInput(String string) {
        return string.endsWith(".class");
    }

    private List<String> getAnnotationNames(Annotation[] annotationArray) {
        return Arrays.stream(annotationArray).map(annotation -> annotation.annotationType().getName()).collect(Collectors.toList());
    }

    public static String getName(Class clazz) {
        if (clazz.isArray()) {
            try {
                Class<?> clazz2 = clazz;
                int n = 0;
                while (clazz2.isArray()) {
                    ++n;
                    clazz2 = clazz2.getComponentType();
                }
                return clazz2.getName() + Utils.repeat("[]", n);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return clazz.getName();
    }
}

