/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.adapters;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javassist.bytecode.AccessFlag;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.Descriptor;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import org.reflections.ReflectionsException;
import org.reflections.adapters.MetadataAdapter;
import org.reflections.util.Utils;
import org.reflections.vfs.Vfs;

public class JavassistAdapter
implements MetadataAdapter<ClassFile, FieldInfo, MethodInfo> {
    public static boolean includeInvisibleTag = true;

    @Override
    public List<FieldInfo> getFields(ClassFile classFile) {
        return classFile.getFields();
    }

    @Override
    public List<MethodInfo> getMethods(ClassFile classFile) {
        return classFile.getMethods();
    }

    @Override
    public String getMethodName(MethodInfo methodInfo) {
        return methodInfo.getName();
    }

    @Override
    public List<String> getParameterNames(MethodInfo methodInfo) {
        String string = methodInfo.getDescriptor();
        string = string.substring(string.indexOf("(") + 1, string.lastIndexOf(")"));
        return this.splitDescriptorToTypeNames(string);
    }

    @Override
    public List<String> getClassAnnotationNames(ClassFile classFile) {
        return this.getAnnotationNames((AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations"), includeInvisibleTag ? (AnnotationsAttribute)classFile.getAttribute("RuntimeInvisibleAnnotations") : null);
    }

    @Override
    public List<String> getFieldAnnotationNames(FieldInfo fieldInfo) {
        return this.getAnnotationNames((AnnotationsAttribute)fieldInfo.getAttribute("RuntimeVisibleAnnotations"), includeInvisibleTag ? (AnnotationsAttribute)fieldInfo.getAttribute("RuntimeInvisibleAnnotations") : null);
    }

    @Override
    public List<String> getMethodAnnotationNames(MethodInfo methodInfo) {
        return this.getAnnotationNames((AnnotationsAttribute)methodInfo.getAttribute("RuntimeVisibleAnnotations"), includeInvisibleTag ? (AnnotationsAttribute)methodInfo.getAttribute("RuntimeInvisibleAnnotations") : null);
    }

    @Override
    public List<String> getParameterAnnotationNames(MethodInfo methodInfo, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ParameterAnnotationsAttribute> list = Arrays.asList((ParameterAnnotationsAttribute)methodInfo.getAttribute("RuntimeVisibleParameterAnnotations"), (ParameterAnnotationsAttribute)methodInfo.getAttribute("RuntimeInvisibleParameterAnnotations"));
        for (ParameterAnnotationsAttribute parameterAnnotationsAttribute : list) {
            Annotation[][] annotationArray;
            if (parameterAnnotationsAttribute == null || n >= (annotationArray = parameterAnnotationsAttribute.getAnnotations()).length) continue;
            Annotation[] annotationArray2 = annotationArray[n];
            arrayList.addAll(this.getAnnotationNames(annotationArray2));
        }
        return arrayList;
    }

    @Override
    public String getReturnTypeName(MethodInfo methodInfo) {
        String string = methodInfo.getDescriptor();
        string = string.substring(string.lastIndexOf(")") + 1);
        return this.splitDescriptorToTypeNames(string).get(0);
    }

    @Override
    public String getFieldName(FieldInfo fieldInfo) {
        return fieldInfo.getName();
    }

    @Override
    public ClassFile getOrCreateClassObject(Vfs.File file) {
        InputStream inputStream = null;
        try {
            inputStream = file.openInputStream();
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
            ClassFile classFile = new ClassFile(dataInputStream);
            return classFile;
        }
        catch (IOException iOException) {
            throw new ReflectionsException("could not create class file from " + file.getName(), iOException);
        }
        finally {
            Utils.close(inputStream);
        }
    }

    @Override
    public String getMethodModifier(MethodInfo methodInfo) {
        int n = methodInfo.getAccessFlags();
        return AccessFlag.isPrivate(n) ? "private" : (AccessFlag.isProtected(n) ? "protected" : (this.isPublic(n) ? "public" : ""));
    }

    @Override
    public String getMethodKey(ClassFile classFile, MethodInfo methodInfo) {
        return this.getMethodName(methodInfo) + "(" + Utils.join(this.getParameterNames(methodInfo), ", ") + ")";
    }

    @Override
    public String getMethodFullKey(ClassFile classFile, MethodInfo methodInfo) {
        return this.getClassName(classFile) + "." + this.getMethodKey(classFile, methodInfo);
    }

    @Override
    public boolean isPublic(Object object) {
        Integer n = object instanceof ClassFile ? ((ClassFile)object).getAccessFlags() : (object instanceof FieldInfo ? ((FieldInfo)object).getAccessFlags() : (object instanceof MethodInfo ? Integer.valueOf(((MethodInfo)object).getAccessFlags()) : null).intValue());
        return n != null && AccessFlag.isPublic(n);
    }

    @Override
    public String getClassName(ClassFile classFile) {
        return classFile.getName();
    }

    @Override
    public String getSuperclassName(ClassFile classFile) {
        return classFile.getSuperclass();
    }

    @Override
    public List<String> getInterfacesNames(ClassFile classFile) {
        return Arrays.asList(classFile.getInterfaces());
    }

    @Override
    public boolean acceptsInput(String string) {
        return string.endsWith(".class");
    }

    private List<String> getAnnotationNames(AnnotationsAttribute ... annotationsAttributeArray) {
        if (annotationsAttributeArray != null) {
            return Arrays.stream(annotationsAttributeArray).filter(Objects::nonNull).flatMap(annotationsAttribute -> Arrays.stream(annotationsAttribute.getAnnotations())).map(Annotation::getTypeName).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<String> getAnnotationNames(Annotation[] annotationArray) {
        return Arrays.stream(annotationArray).map(Annotation::getTypeName).collect(Collectors.toList());
    }

    private List<String> splitDescriptorToTypeNames(String string) {
        List<String> list = new ArrayList<String>();
        if (string != null && string.length() != 0) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            Descriptor.Iterator iterator = new Descriptor.Iterator(string);
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            arrayList.add(string.length());
            list = IntStream.range(0, arrayList.size() - 1).mapToObj(n -> Descriptor.toString(string.substring((Integer)arrayList.get(n), (Integer)arrayList.get(n + 1)))).collect(Collectors.toList());
        }
        return list;
    }
}

