/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.scanners;

import java.util.function.Predicate;
import org.reflections.Configuration;
import org.reflections.ReflectionsException;
import org.reflections.Store;
import org.reflections.adapters.MetadataAdapter;
import org.reflections.scanners.Scanner;
import org.reflections.util.Utils;
import org.reflections.vfs.Vfs;

public abstract class AbstractScanner
implements Scanner {
    private Configuration configuration;
    private Predicate<String> resultFilter = string -> true;

    @Override
    public boolean acceptsInput(String string) {
        return this.getMetadataAdapter().acceptsInput(string);
    }

    @Override
    public Object scan(Vfs.File file, Object object, Store store) {
        if (object == null) {
            try {
                object = this.configuration.getMetadataAdapter().getOrCreateClassObject(file);
            }
            catch (Exception exception) {
                throw new ReflectionsException("could not create class object from file " + file.getRelativePath(), exception);
            }
        }
        this.scan(object, store);
        return object;
    }

    public abstract void scan(Object var1, Store var2);

    protected void put(Store store, String string, String string2) {
        store.put(Utils.index(this.getClass()), string, string2);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Predicate<String> getResultFilter() {
        return this.resultFilter;
    }

    public void setResultFilter(Predicate<String> predicate) {
        this.resultFilter = predicate;
    }

    @Override
    public Scanner filterResultsBy(Predicate<String> predicate) {
        this.setResultFilter(predicate);
        return this;
    }

    @Override
    public boolean acceptResult(String string) {
        return string != null && this.resultFilter.test(string);
    }

    protected MetadataAdapter getMetadataAdapter() {
        return this.configuration.getMetadataAdapter();
    }

    public boolean equals(Object object) {
        return this == object || object != null && this.getClass() == object.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

