/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.reflections.ReflectionsException;
import org.reflections.util.Utils;

public class FilterBuilder
implements Predicate<String> {
    private final List<Predicate<String>> chain;

    public FilterBuilder() {
        this.chain = new ArrayList<Predicate<String>>();
    }

    private FilterBuilder(Collection<Predicate<String>> collection) {
        this.chain = new ArrayList<Predicate<String>>(collection);
    }

    public FilterBuilder include(String string) {
        return this.add(new Include(string));
    }

    public FilterBuilder exclude(String string) {
        this.add(new Exclude(string));
        return this;
    }

    public FilterBuilder add(Predicate<String> predicate) {
        this.chain.add(predicate);
        return this;
    }

    public FilterBuilder includePackage(Class<?> clazz) {
        return this.add(new Include(FilterBuilder.packageNameRegex(clazz)));
    }

    public FilterBuilder excludePackage(Class<?> clazz) {
        return this.add(new Exclude(FilterBuilder.packageNameRegex(clazz)));
    }

    public FilterBuilder includePackage(String ... stringArray) {
        for (String string : stringArray) {
            this.add(new Include(FilterBuilder.prefix(string)));
        }
        return this;
    }

    public FilterBuilder excludePackage(String string) {
        return this.add(new Exclude(FilterBuilder.prefix(string)));
    }

    private static String packageNameRegex(Class<?> clazz) {
        return FilterBuilder.prefix(clazz.getPackage().getName() + ".");
    }

    public static String prefix(String string) {
        return string.replace(".", "\\.") + ".*";
    }

    public String toString() {
        return Utils.join(this.chain, ", ");
    }

    @Override
    public boolean test(String string) {
        boolean bl = this.chain.isEmpty() || this.chain.get(0) instanceof Exclude;
        for (Predicate<String> predicate : this.chain) {
            if (bl && predicate instanceof Include || !bl && predicate instanceof Exclude || (bl = predicate.test(string)) || !(predicate instanceof Exclude)) continue;
            break;
        }
        return bl;
    }

    public static FilterBuilder parse(String string) {
        ArrayList<Predicate<String>> arrayList = new ArrayList<Predicate<String>>();
        if (!Utils.isEmpty(string)) {
            for (String string2 : string.split(",")) {
                Matcher matcher;
                String string3 = string2.trim();
                char c = string3.charAt(0);
                String string4 = string3.substring(1);
                switch (c) {
                    case '+': {
                        matcher = new Include(string4);
                        break;
                    }
                    case '-': {
                        matcher = new Exclude(string4);
                        break;
                    }
                    default: {
                        throw new ReflectionsException("includeExclude should start with either + or -");
                    }
                }
                arrayList.add(matcher);
            }
            return new FilterBuilder(arrayList);
        }
        return new FilterBuilder();
    }

    public static FilterBuilder parsePackages(String string) {
        ArrayList<Predicate<String>> arrayList = new ArrayList<Predicate<String>>();
        if (!Utils.isEmpty(string)) {
            for (String string2 : string.split(",")) {
                Matcher matcher;
                String string3 = string2.trim();
                char c = string3.charAt(0);
                String string4 = string3.substring(1);
                if (!string4.endsWith(".")) {
                    string4 = string4 + ".";
                }
                string4 = FilterBuilder.prefix(string4);
                switch (c) {
                    case '+': {
                        matcher = new Include(string4);
                        break;
                    }
                    case '-': {
                        matcher = new Exclude(string4);
                        break;
                    }
                    default: {
                        throw new ReflectionsException("includeExclude should start with either + or -");
                    }
                }
                arrayList.add(matcher);
            }
            return new FilterBuilder(arrayList);
        }
        return new FilterBuilder();
    }

    public static class Exclude
    extends Matcher {
        public Exclude(String string) {
            super(string);
        }

        @Override
        public boolean test(String string) {
            return !this.pattern.matcher(string).matches();
        }

        @Override
        public String toString() {
            return "-" + super.toString();
        }
    }

    public static class Include
    extends Matcher {
        public Include(String string) {
            super(string);
        }

        @Override
        public boolean test(String string) {
            return this.pattern.matcher(string).matches();
        }

        @Override
        public String toString() {
            return "+" + super.toString();
        }
    }

    public static abstract class Matcher
    implements Predicate<String> {
        final Pattern pattern;

        public Matcher(String string) {
            this.pattern = Pattern.compile(string);
        }

        public String toString() {
            return this.pattern.pattern();
        }
    }
}

