/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.vfs;

import java.io.File;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import org.reflections.vfs.Vfs;
import org.reflections.vfs.ZipDir;

public class ZipFile
implements Vfs.File {
    private final ZipDir root;
    private final ZipEntry entry;

    public ZipFile(ZipDir zipDir, ZipEntry zipEntry) {
        this.root = zipDir;
        this.entry = zipEntry;
    }

    @Override
    public String getName() {
        String string = this.entry.getName();
        return string.substring(string.lastIndexOf("/") + 1);
    }

    @Override
    public String getRelativePath() {
        return this.entry.getName();
    }

    @Override
    public InputStream openInputStream() {
        return this.root.jarFile.getInputStream(this.entry);
    }

    public String toString() {
        return this.root.getPath() + "!" + File.separatorChar + this.entry.toString();
    }
}

