/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtils {
    public static void copyFolder(File file, File file2) {
        FileUtils.copyFolder(file, file2, null);
    }

    public static void copyFolder(File file, File file2, List<String> list) {
        try {
            String[] stringArray;
            if (!file.isDirectory()) {
                Files.copy(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
                return;
            }
            if (!file2.exists()) {
                file2.mkdir();
            }
            for (String string : stringArray = file.list()) {
                if (list != null && list.contains(string)) continue;
                File file3 = new File(file, string);
                File file4 = new File(file2, string);
                FileUtils.copyFolder(file3, file4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void deleteFolder(File file) {
        try {
            if (!file.exists()) {
                file.delete();
                return;
            }
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                file.delete();
                return;
            }
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    FileUtils.deleteFolder(file2);
                    continue;
                }
                file2.delete();
            }
            file.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void zipFile(File file, String string, ZipOutputStream zipOutputStream) {
        int n;
        if (file.isHidden()) {
            return;
        }
        if (file.isDirectory()) {
            if (string.endsWith("/")) {
                zipOutputStream.putNextEntry(new ZipEntry(string));
                zipOutputStream.closeEntry();
            } else {
                zipOutputStream.putNextEntry(new ZipEntry(string + "/"));
                zipOutputStream.closeEntry();
            }
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            for (File file2 : fileArray) {
                FileUtils.zipFile(file2, string + "/" + file2.getName(), zipOutputStream);
            }
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        ZipEntry zipEntry = new ZipEntry(string);
        zipOutputStream.putNextEntry(zipEntry);
        byte[] byArray = new byte[1024];
        while ((n = fileInputStream.read(byArray)) >= 0) {
            zipOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
    }

    public static void zipSubFolders(File file, ZipOutputStream zipOutputStream) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            int n;
            if (file2.isDirectory()) {
                FileUtils.zipSubFolders(file2, zipOutputStream);
                continue;
            }
            String string = file2.getCanonicalPath();
            ZipEntry zipEntry = new ZipEntry(string.substring(file.getCanonicalPath().length() + 1));
            zipOutputStream.putNextEntry(zipEntry);
            FileInputStream fileInputStream = new FileInputStream(string);
            byte[] byArray = new byte[1024];
            while ((n = fileInputStream.read(byArray)) > 0) {
                zipOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            zipOutputStream.closeEntry();
        }
    }

    public static void addFolderToZip(ZipOutputStream zipOutputStream, File file, String string) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            int n;
            if (file2.isDirectory()) {
                FileUtils.addFolderToZip(zipOutputStream, file2, string + file2.getName() + "/");
                continue;
            }
            byte[] byArray = new byte[1024];
            FileInputStream fileInputStream = new FileInputStream(file2);
            zipOutputStream.putNextEntry(new ZipEntry(string + file2.getName()));
            while ((n = fileInputStream.read(byArray)) > 0) {
                zipOutputStream.write(byArray, 0, n);
            }
            zipOutputStream.closeEntry();
            fileInputStream.close();
        }
    }
}

